/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerProperties;
import org.apache.helix.HelixManagerProperty;
import org.apache.helix.HelixPropertyFactory;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.InstanceConfigChangeListener;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.LiveInstanceInfoProvider;
import org.apache.helix.MessageListener;
import org.apache.helix.PreConnectCallback;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.PropertyType;
import org.apache.helix.ScopedConfigChangeListener;
import org.apache.helix.api.listeners.ClusterConfigChangeListener;
import org.apache.helix.api.listeners.ConfigChangeListener;
import org.apache.helix.api.listeners.CustomizedStateChangeListener;
import org.apache.helix.api.listeners.CustomizedStateConfigChangeListener;
import org.apache.helix.api.listeners.CustomizedStateRootChangeListener;
import org.apache.helix.api.listeners.CustomizedViewChangeListener;
import org.apache.helix.api.listeners.CustomizedViewRootChangeListener;
import org.apache.helix.api.listeners.ResourceConfigChangeListener;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.healthcheck.ParticipantHealthReportCollector;
import org.apache.helix.healthcheck.ParticipantHealthReportCollectorImpl;
import org.apache.helix.healthcheck.ParticipantHealthReportTask;
import org.apache.helix.manager.zk.CallbackHandler;
import org.apache.helix.manager.zk.DistributedLeaderElection;
import org.apache.helix.manager.zk.HelixManagerStateListener;
import org.apache.helix.manager.zk.ParticipantManager;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.ZKPathDataDumpTask;
import org.apache.helix.monitoring.mbeans.HelixCallbackMonitor;
import org.apache.helix.monitoring.mbeans.MonitorLevel;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.store.zk.AutoFallbackPropertyStore;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ChainedPathZkSerializer;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.HelixZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKHelixManager
implements HelixManager,
IZkStateListener {
    private static Logger LOG = LoggerFactory.getLogger(ZKHelixManager.class);
    public static final String ALLOW_PARTICIPANT_AUTO_JOIN = "allowParticipantAutoJoin";
    private static final int FLAPPING_TIME_WINDOW = 300000;
    public static final int DEFAULT_MAX_DISCONNECT_THRESHOLD = 600;
    private static final int DEFAULT_WAIT_CONNECTED_TIMEOUT = 10000;
    protected final String _zkAddress;
    private final String _clusterName;
    private final String _instanceName;
    private final InstanceType _instanceType;
    private final int _waitForConnectedTimeout;
    private final int _sessionTimeout;
    private final int _connectionInitTimeout;
    private final List<PreConnectCallback> _preConnectCallbacks;
    protected final List<CallbackHandler> _handlers;
    private final HelixManagerProperties _properties;
    private final HelixManagerProperty _helixManagerProperty;
    private final HelixManagerStateListener _stateListener;
    private final String _version;
    private int _reportLatency;
    protected RealmAwareZkClient _zkclient;
    private final DefaultMessagingService _messagingService;
    private Map<HelixConstants.ChangeType, HelixCallbackMonitor> _callbackMonitors;
    private final MonitorLevel _monitorLevel;
    private BaseDataAccessor<ZNRecord> _baseDataAccessor;
    private ZKHelixDataAccessor _dataAccessor;
    private final PropertyKey.Builder _keyBuilder;
    private ConfigAccessor _configAccessor;
    private ZkHelixPropertyStore<ZNRecord> _helixPropertyStore;
    protected LiveInstanceInfoProvider _liveInstanceInfoProvider = null;
    private volatile String _sessionId;
    private final List<Long> _disconnectTimeHistory = new ArrayList<Long>();
    private final int _flappingTimeWindowMs;
    private final int _maxDisconnectThreshold;
    private final StateMachineEngine _stateMachineEngine;
    private final List<HelixTimerTask> _timerTasks = new ArrayList<HelixTimerTask>();
    private final ParticipantHealthReportCollectorImpl _participantHealthInfoCollector;
    private Long _sessionStartTime;
    private ParticipantManager _participantManager;
    private GenericHelixController _controller;
    private Set<Pipeline.Type> _enabledPipelineTypes;
    private CallbackHandler _leaderElectionHandler = null;
    protected final List<HelixTimerTask> _controllerTimerTasks = new ArrayList<HelixTimerTask>();

    public ZKHelixManager(String clusterName, String instanceName, InstanceType instanceType, String zkAddress) {
        this(clusterName, instanceName, instanceType, zkAddress, null);
    }

    public ZKHelixManager(String clusterName, String instanceName, InstanceType instanceType, String zkAddress, HelixManagerStateListener stateListener) {
        this(clusterName, instanceName, instanceType, zkAddress, stateListener, HelixPropertyFactory.getInstance().getHelixManagerProperty(zkAddress, clusterName));
    }

    public ZKHelixManager(String clusterName, String instanceName, InstanceType instanceType, String zkAddress, HelixManagerStateListener stateListener, HelixManagerProperty helixManagerProperty) {
        MonitorLevel configuredMonitorLevel;
        LOG.info("Create a zk-based cluster manager. zkSvr: " + zkAddress + ", clusterName: " + clusterName + ", instanceName: " + instanceName + ", type: " + (Object)((Object)instanceType));
        this._zkAddress = zkAddress;
        this._clusterName = clusterName;
        this._instanceType = instanceType;
        if (instanceName == null) {
            try {
                instanceName = InetAddress.getLocalHost().getCanonicalHostName() + "-" + instanceType.toString();
            }
            catch (UnknownHostException e) {
                LOG.info("Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
                instanceName = "UNKNOWN";
            }
        }
        this._instanceName = instanceName;
        this._enabledPipelineTypes = Sets.newHashSet((Object[])new Pipeline.Type[]{Pipeline.Type.DEFAULT, Pipeline.Type.TASK});
        this._preConnectCallbacks = new ArrayList<PreConnectCallback>();
        this._handlers = new ArrayList<CallbackHandler>();
        this._properties = new HelixManagerProperties("cluster-manager-version.properties");
        this._version = this._properties.getVersion();
        this._keyBuilder = new PropertyKey.Builder(clusterName);
        this._messagingService = new DefaultMessagingService(this);
        try {
            this._callbackMonitors = new HashMap<HelixConstants.ChangeType, HelixCallbackMonitor>();
            for (HelixConstants.ChangeType changeType : HelixConstants.ChangeType.values()) {
                HelixCallbackMonitor callbackMonitor = new HelixCallbackMonitor(instanceType, clusterName, instanceName, changeType);
                callbackMonitor.register();
                this._callbackMonitors.put(changeType, callbackMonitor);
            }
        }
        catch (JMException e) {
            LOG.error("Error in creating callback monitor.", (Throwable)e);
        }
        this._stateListener = stateListener;
        this._helixManagerProperty = helixManagerProperty;
        this._flappingTimeWindowMs = HelixUtil.getSystemPropertyAsInt("helixmanager.flappingTimeWindow", 300000);
        this._maxDisconnectThreshold = HelixUtil.getSystemPropertyAsInt("helixmanager.maxDisconnectThreshold", 600);
        this._sessionTimeout = HelixUtil.getSystemPropertyAsInt("zk.session.timeout", 30000);
        this._connectionInitTimeout = HelixUtil.getSystemPropertyAsInt("zk.connection.timeout", 60000);
        this._waitForConnectedTimeout = HelixUtil.getSystemPropertyAsInt("helixmanager.waitForConnectedTimeout", 10000);
        this._reportLatency = HelixUtil.getSystemPropertyAsInt("helixmanager.participantHealthReport.reportLatency", 60000);
        try {
            configuredMonitorLevel = MonitorLevel.valueOf(System.getProperty("helixmanager.monitorLevel", MonitorLevel.DEFAULT.name()));
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Unrecognizable Monitor Level configuration. Use DEFAULT monitor level.", (Throwable)ex);
            configuredMonitorLevel = MonitorLevel.DEFAULT;
        }
        this._monitorLevel = configuredMonitorLevel;
        switch (instanceType) {
            case PARTICIPANT: {
                this._stateMachineEngine = new HelixStateMachineEngine(this);
                this._participantHealthInfoCollector = new ParticipantHealthReportCollectorImpl(this, this._instanceName);
                this._timerTasks.add(new ParticipantHealthReportTask(this._participantHealthInfoCollector, this._reportLatency));
                break;
            }
            case CONTROLLER: {
                this._stateMachineEngine = null;
                this._participantHealthInfoCollector = null;
                this._controllerTimerTasks.add(new StatusDumpTask(this));
                break;
            }
            case CONTROLLER_PARTICIPANT: {
                this._stateMachineEngine = new HelixStateMachineEngine(this);
                this._participantHealthInfoCollector = new ParticipantHealthReportCollectorImpl(this, this._instanceName);
                this._timerTasks.add(new ParticipantHealthReportTask(this._participantHealthInfoCollector, this._reportLatency));
                this._controllerTimerTasks.add(new StatusDumpTask(this));
                break;
            }
            case ADMINISTRATOR: 
            case SPECTATOR: {
                this._stateMachineEngine = null;
                this._participantHealthInfoCollector = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unrecognized type: " + (Object)((Object)instanceType));
            }
        }
    }

    @Override
    public void setEnabledControlPipelineTypes(Set<Pipeline.Type> types) {
        if (!InstanceType.CONTROLLER.equals((Object)this._instanceType) && !InstanceType.CONTROLLER_PARTICIPANT.equals((Object)this._instanceType)) {
            throw new IllegalStateException(String.format("Cannot enable control pipeline for instance type %s", new Object[]{this._instanceType}));
        }
        this._enabledPipelineTypes = types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(PropertyKey key, Object listener) {
        LOG.info("Removing listener: " + listener + " on path: " + key.getPath() + " from cluster: " + this._clusterName + " by instance: " + this._instanceName);
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            ArrayList<CallbackHandler> toRemove = new ArrayList<CallbackHandler>();
            for (CallbackHandler handler : this._handlers) {
                if (!handler.getPath().equals(key.getPath()) || !handler.getListener().equals(listener)) continue;
                toRemove.add(handler);
            }
            this._handlers.removeAll(toRemove);
            for (CallbackHandler handler : toRemove) {
                handler.reset(true);
            }
        }
        return true;
    }

    void checkConnected() {
        this.checkConnected(-1L);
    }

    void checkConnected(long timeout) {
        if (this._zkclient == null || this._zkclient.isClosed()) {
            throw new HelixException("HelixManager (ZkClient) is not connected. Call HelixManager#connect()");
        }
        boolean isConnected = this.isConnected();
        if (!isConnected && timeout > 0L) {
            LOG.warn("zkClient to " + this._zkAddress + " is not connected, wait for " + this._waitForConnectedTimeout + "ms.");
            isConnected = this._zkclient.waitUntilConnected(this._waitForConnectedTimeout, TimeUnit.MILLISECONDS);
        }
        if (!isConnected) {
            LOG.error("zkClient is not connected after waiting " + timeout + "ms., clusterName: " + this._clusterName + ", zkAddress: " + this._zkAddress);
            throw new HelixException("HelixManager is not connected within retry timeout for cluster " + this._clusterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(Object listener, PropertyKey propertyKey, HelixConstants.ChangeType changeType, Watcher.Event.EventType[] eventType) {
        this.checkConnected(this._waitForConnectedTimeout);
        PropertyType type = propertyKey.getType();
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            for (CallbackHandler handler : this._handlers) {
                if (!handler.getPath().equals(propertyKey.getPath()) || !handler.getListener().equals(listener)) continue;
                LOG.info("Listener: " + listener + " on path: " + propertyKey.getPath() + " already exists. skip add");
                return;
            }
            CallbackHandler newHandler = new CallbackHandler(this, this._zkclient, propertyKey, listener, eventType, changeType, this._callbackMonitors.get((Object)changeType));
            this._handlers.add(newHandler);
            LOG.info("Added listener: " + listener + " for type: " + (Object)((Object)type) + " to path: " + newHandler.getPath());
        }
    }

    @Override
    public void addIdealStateChangeListener(org.apache.helix.api.listeners.IdealStateChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).idealStates(), HelixConstants.ChangeType.IDEAL_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addIdealStateChangeListener(IdealStateChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).idealStates(), HelixConstants.ChangeType.IDEAL_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addLiveInstanceChangeListener(org.apache.helix.api.listeners.LiveInstanceChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).liveInstances(), HelixConstants.ChangeType.LIVE_INSTANCE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addLiveInstanceChangeListener(LiveInstanceChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).liveInstances(), HelixConstants.ChangeType.LIVE_INSTANCE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addConfigChangeListener(ConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).instanceConfigs(), HelixConstants.ChangeType.INSTANCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addInstanceConfigChangeListener(org.apache.helix.api.listeners.InstanceConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).instanceConfigs(), HelixConstants.ChangeType.INSTANCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addInstanceConfigChangeListener(InstanceConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).instanceConfigs(), HelixConstants.ChangeType.INSTANCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addResourceConfigChangeListener(ResourceConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).resourceConfigs(), HelixConstants.ChangeType.RESOURCE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCustomizedStateConfigChangeListener(CustomizedStateConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).customizedStateConfig(), HelixConstants.ChangeType.CUSTOMIZED_STATE_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged});
    }

    @Override
    public void addClusterfigChangeListener(ClusterConfigChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).clusterConfig(), HelixConstants.ChangeType.CLUSTER_CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged});
    }

    @Override
    public void addConfigChangeListener(org.apache.helix.api.listeners.ScopedConfigChangeListener listener, HelixConfigScope.ConfigScopeProperty scope) throws Exception {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(this._clusterName);
        PropertyKey propertyKey = null;
        switch (scope) {
            case CLUSTER: {
                propertyKey = keyBuilder.clusterConfigs();
                break;
            }
            case PARTICIPANT: {
                propertyKey = keyBuilder.instanceConfigs();
                break;
            }
            case RESOURCE: {
                propertyKey = keyBuilder.resourceConfigs();
                break;
            }
        }
        if (propertyKey != null) {
            this.addListener(listener, propertyKey, HelixConstants.ChangeType.CONFIG, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
        } else {
            LOG.error("Can't add listener to config scope: " + (Object)((Object)scope));
        }
    }

    @Override
    @Deprecated
    public void addConfigChangeListener(ScopedConfigChangeListener listener, HelixConfigScope.ConfigScopeProperty scope) throws Exception {
        this.addConfigChangeListener((org.apache.helix.api.listeners.ScopedConfigChangeListener)listener, scope);
    }

    @Override
    public void addMessageListener(org.apache.helix.api.listeners.MessageListener listener, String instanceName) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).messages(instanceName), HelixConstants.ChangeType.MESSAGE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addMessageListener(MessageListener listener, String instanceName) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).messages(instanceName), HelixConstants.ChangeType.MESSAGE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addControllerMessageListener(org.apache.helix.api.listeners.MessageListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controllerMessages(), HelixConstants.ChangeType.MESSAGES_CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addControllerMessageListener(MessageListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controllerMessages(), HelixConstants.ChangeType.MESSAGES_CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCurrentStateChangeListener(org.apache.helix.api.listeners.CurrentStateChangeListener listener, String instanceName, String sessionId) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).currentStates(instanceName, sessionId), HelixConstants.ChangeType.CURRENT_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addCurrentStateChangeListener(CurrentStateChangeListener listener, String instanceName, String sessionId) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).currentStates(instanceName, sessionId), HelixConstants.ChangeType.CURRENT_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCustomizedStateRootChangeListener(CustomizedStateRootChangeListener listener, String instanceName) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).customizedStatesRoot(instanceName), HelixConstants.ChangeType.CUSTOMIZED_STATE_ROOT, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCustomizedStateChangeListener(CustomizedStateChangeListener listener, String instanceName, String customizedStateType) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).customizedStates(instanceName, customizedStateType), HelixConstants.ChangeType.CUSTOMIZED_STATE, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addExternalViewChangeListener(org.apache.helix.api.listeners.ExternalViewChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).externalViews(), HelixConstants.ChangeType.EXTERNAL_VIEW, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCustomizedViewChangeListener(CustomizedViewChangeListener listener, String customizedStateType) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).customizedView(customizedStateType), HelixConstants.ChangeType.CUSTOMIZED_VIEW, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addCustomizedViewRootChangeListener(CustomizedViewRootChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).customizedViews(), HelixConstants.ChangeType.CUSTOMIZED_VIEW_ROOT, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addTargetExternalViewChangeListener(org.apache.helix.api.listeners.ExternalViewChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).externalViews(), HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addExternalViewChangeListener(ExternalViewChangeListener listener) throws Exception {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).externalViews(), HelixConstants.ChangeType.EXTERNAL_VIEW, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public void addControllerListener(org.apache.helix.api.listeners.ControllerChangeListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controller(), HelixConstants.ChangeType.CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    @Deprecated
    public void addControllerListener(ControllerChangeListener listener) {
        this.addListener(listener, new PropertyKey.Builder(this._clusterName).controller(), HelixConstants.ChangeType.CONTROLLER, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged});
    }

    @Override
    public HelixDataAccessor getHelixDataAccessor() {
        this.checkConnected(this._waitForConnectedTimeout);
        return this._dataAccessor;
    }

    @Override
    public ConfigAccessor getConfigAccessor() {
        this.checkConnected(this._waitForConnectedTimeout);
        return this._configAccessor;
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public String getMetadataStoreConnectionString() {
        return this._zkAddress;
    }

    @Override
    public String getInstanceName() {
        return this._instanceName;
    }

    BaseDataAccessor<ZNRecord> createBaseDataAccessor() {
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkclient);
        return baseDataAccessor;
    }

    private void addBuiltInStateModelDefinitions() {
        for (BuiltInStateModelDefinitions def : BuiltInStateModelDefinitions.values()) {
            this._dataAccessor.createStateModelDef(def.getStateModelDefinition());
        }
    }

    private boolean isMonitorRootPathOnly() {
        switch (this._monitorLevel) {
            case ALL: {
                return false;
            }
            case AGGREGATED_ONLY: {
                return true;
            }
        }
        return !this._instanceType.equals((Object)InstanceType.CONTROLLER) && !this._instanceType.equals((Object)InstanceType.CONTROLLER_PARTICIPANT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createClient() throws Exception {
        RealmAwareZkClient newClient = this.createSingleRealmZkClient();
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            if (this._zkclient != null) {
                this._zkclient.close();
            }
            this._zkclient = newClient;
            this._baseDataAccessor = this.createBaseDataAccessor();
            this._dataAccessor = new ZKHelixDataAccessor(this._clusterName, this._instanceType, this._baseDataAccessor);
            this._configAccessor = new ConfigAccessor(this._zkclient);
            if (this._instanceType == InstanceType.CONTROLLER || this._instanceType == InstanceType.CONTROLLER_PARTICIPANT) {
                this.addBuiltInStateModelDefinitions();
            }
        }
        this._zkclient.subscribeStateChanges(this);
        int retryCount = 0;
        while (retryCount < 3) {
            try {
                long sessionId = this._zkclient.waitForEstablishedSession(this._connectionInitTimeout, TimeUnit.MILLISECONDS);
                this.handleStateChanged(Watcher.Event.KeeperState.SyncConnected);
                this.handleNewSession(ZKUtil.toHexSessionId(sessionId));
                break;
            }
            catch (HelixException e) {
                LOG.error("fail to createClient.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("fail to createClient. retry " + ++retryCount, (Throwable)e);
                if (retryCount != 3) continue;
                throw e;
            }
        }
    }

    @Override
    public void connect() throws Exception {
        LOG.info("ClusterManager.connect()");
        if (this.isConnected()) {
            LOG.warn("Cluster manager: " + this._instanceName + " for cluster: " + this._clusterName + " already connected. skip connect");
            return;
        }
        switch (this._instanceType) {
            case CONTROLLER: 
            case CONTROLLER_PARTICIPANT: {
                if (this._controller != null) break;
                this._controller = new GenericHelixController(this._clusterName, this._enabledPipelineTypes);
                this._messagingService.getExecutor().setController(this._controller);
                break;
            }
        }
        try {
            this.createClient();
            this._messagingService.onConnected();
        }
        catch (Exception e) {
            LOG.error("fail to connect " + this._instanceName, (Throwable)e);
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this._zkclient == null || this._zkclient.isClosed()) {
            LOG.info("instanceName: " + this._instanceName + " already disconnected");
            return;
        }
        LOG.info("disconnect " + this._instanceName + "(" + (Object)((Object)this._instanceType) + ") from " + this._clusterName);
        try {
            this.stopTimerTasks();
            this._messagingService.getExecutor().shutdown();
            this.resetHandlers(true);
            if (this._leaderElectionHandler != null) {
                this._leaderElectionHandler.reset(true);
            }
        }
        finally {
            ParticipantManager participantManager;
            GenericHelixController controller = this._controller;
            if (controller != null) {
                try {
                    controller.shutdown();
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupted shutting down GenericHelixController", (Throwable)e);
                }
            }
            if ((participantManager = this._participantManager) != null) {
                participantManager.disconnect();
            }
            for (HelixCallbackMonitor callbackMonitor : this._callbackMonitors.values()) {
                callbackMonitor.unregister();
            }
            this._helixPropertyStore = null;
            ZKHelixManager zKHelixManager = this;
            synchronized (zKHelixManager) {
                if (this._controller != null) {
                    this._controller = null;
                    this._leaderElectionHandler = null;
                }
                if (this._participantManager != null) {
                    this._participantManager = null;
                }
                if (this._zkclient != null) {
                    this._zkclient.close();
                }
            }
            this._sessionStartTime = null;
            LOG.info("Cluster manager: " + this._instanceName + " disconnected");
        }
    }

    @Override
    public String getSessionId() {
        this.checkConnected(this._waitForConnectedTimeout);
        return this._sessionId;
    }

    @Override
    public boolean isConnected() {
        if (this._zkclient == null || this._zkclient.isClosed()) {
            return false;
        }
        try {
            return this._zkclient.waitUntilConnected(0L, TimeUnit.MILLISECONDS);
        }
        catch (ZkInterruptedException ex) {
            return false;
        }
    }

    @Override
    public long getLastNotificationTime() {
        return 0L;
    }

    @Override
    public void addPreConnectCallback(PreConnectCallback callback) {
        LOG.info("Adding preconnect callback: " + callback);
        this._preConnectCallbacks.add(callback);
    }

    @Override
    public boolean isLeader() {
        String warnLogPrefix = String.format("Instance %s is not leader of cluster %s due to", this._instanceName, this._clusterName);
        if (this._instanceType != InstanceType.CONTROLLER && this._instanceType != InstanceType.CONTROLLER_PARTICIPANT) {
            LOG.warn(String.format("%s instance type %s does not match to CONTROLLER/CONTROLLER_PARTICIPANT", warnLogPrefix, this._instanceType.name()));
            return false;
        }
        if (!this.isConnected()) {
            LOG.warn(String.format("%s HelixManager is not connected", warnLogPrefix));
            return false;
        }
        try {
            LiveInstance leader = (LiveInstance)this._dataAccessor.getProperty(this._keyBuilder.controllerLeader());
            if (leader != null) {
                String leaderName = leader.getInstanceName();
                String sessionId = leader.getEphemeralOwner();
                if (leaderName != null && leaderName.equals(this._instanceName) && sessionId.equals(this._sessionId)) {
                    return true;
                }
                LOG.warn(String.format("%s current session %s does not match leader session %s", warnLogPrefix, this._sessionId, sessionId));
            } else {
                LOG.warn(String.format("%s leader ZNode is null", warnLogPrefix));
            }
        }
        catch (Exception e) {
            LOG.warn(String.format("%s exception happen when session check", warnLogPrefix), (Throwable)e);
        }
        return false;
    }

    @Override
    public synchronized ZkHelixPropertyStore<ZNRecord> getHelixPropertyStore() {
        this.checkConnected(this._waitForConnectedTimeout);
        if (this._helixPropertyStore == null) {
            String path = PropertyPathBuilder.propertyStore(this._clusterName);
            String fallbackPath = String.format("/%s/%s", this._clusterName, "HELIX_PROPERTYSTORE");
            this._helixPropertyStore = new AutoFallbackPropertyStore<ZNRecord>(new ZkBaseDataAccessor(this._zkclient), path, fallbackPath);
        }
        return this._helixPropertyStore;
    }

    @Override
    public synchronized HelixAdmin getClusterManagmentTool() {
        this.checkConnected(this._waitForConnectedTimeout);
        if (this._zkclient != null && !this._zkclient.isClosed()) {
            return new ZKHelixAdmin(this._zkclient);
        }
        LOG.error("Couldn't get ZKClusterManagementTool because zkclient is null");
        return null;
    }

    @Override
    public ClusterMessagingService getMessagingService() {
        return this._messagingService;
    }

    @Override
    public InstanceType getInstanceType() {
        return this._instanceType;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public HelixManagerProperties getProperties() {
        return this._properties;
    }

    @Override
    public StateMachineEngine getStateMachineEngine() {
        return this._stateMachineEngine;
    }

    @Override
    public void startTimerTasks() {
        for (HelixTimerTask task : this._timerTasks) {
            task.start();
        }
    }

    @Override
    public void stopTimerTasks() {
        for (HelixTimerTask task : this._timerTasks) {
            task.stop();
        }
    }

    @Override
    public void setLiveInstanceInfoProvider(LiveInstanceInfoProvider liveInstanceInfoProvider) {
        this._liveInstanceInfoProvider = liveInstanceInfoProvider;
    }

    void waitUntilConnected() {
        boolean isConnected;
        do {
            if (!(isConnected = this._zkclient.waitUntilConnected(60000L, TimeUnit.MILLISECONDS))) {
                LOG.error("fail to connect zkserver: " + this._zkAddress + " in " + 60000 + "ms. expiredSessionId: " + this._sessionId + ", clusterName: " + this._clusterName);
                continue;
            }
            this._sessionId = ZKUtil.toHexSessionId(this._zkclient.getSessionId());
        } while (!isConnected || "0".equals(this._sessionId));
        LOG.info("Handling new session, session id: " + this._sessionId + ", instance: " + this._instanceName + ", instanceTye: " + (Object)((Object)this._instanceType) + ", cluster: " + this._clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initHandlers(List<CallbackHandler> handlers) {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            if (handlers != null) {
                ArrayList<CallbackHandler> tmpHandlers = new ArrayList<CallbackHandler>(handlers);
                for (CallbackHandler handler : tmpHandlers) {
                    handler.init();
                    LOG.info("init handler: " + handler.getPath() + ", " + handler.getListener());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetHandlers(boolean isShutdown) {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            if (this._handlers != null) {
                ArrayList<CallbackHandler> tmpHandlers = new ArrayList<CallbackHandler>(this._handlers);
                for (CallbackHandler handler : tmpHandlers) {
                    handler.reset(isShutdown);
                    LOG.info("reset handler: " + handler.getPath() + ", " + handler.getListener());
                }
            }
        }
    }

    boolean isFlapping() {
        if (this._disconnectTimeHistory.size() == 0) {
            return false;
        }
        long mostRecentTimestamp = this._disconnectTimeHistory.get(this._disconnectTimeHistory.size() - 1);
        while (this._disconnectTimeHistory.get(0) + (long)this._flappingTimeWindowMs < mostRecentTimestamp) {
            this._disconnectTimeHistory.remove(0);
        }
        return this._disconnectTimeHistory.size() > this._maxDisconnectThreshold;
    }

    @Override
    public void handleStateChanged(Watcher.Event.KeeperState state) {
        switch (state) {
            case SyncConnected: {
                LOG.info("KeeperState: " + state + ", instance: " + this._instanceName + ", type: " + (Object)((Object)this._instanceType));
                break;
            }
            case Disconnected: {
                this._disconnectTimeHistory.add(System.currentTimeMillis());
                if (this.isFlapping()) {
                    String errorMsg = "instanceName: " + this._instanceName + " is flapping. disconnect it.  maxDisconnectThreshold: " + this._maxDisconnectThreshold + " disconnects in " + this._flappingTimeWindowMs + "ms.";
                    LOG.error(errorMsg);
                    if (this._instanceType.equals((Object)InstanceType.PARTICIPANT)) {
                        LOG.warn("instanceName: " + this._instanceName + " is flapping. Since it is a participant, disable it.");
                        try {
                            this.getClusterManagmentTool().enableInstance(this._clusterName, this._instanceName, false);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to disable participant before disconnecting participant.", (Throwable)e);
                        }
                    }
                    try {
                        this.disconnect();
                    }
                    catch (Exception ex) {
                        LOG.error("Disconnect HelixManager is not completely done.", (Throwable)ex);
                    }
                    if (this._stateListener == null) break;
                    try {
                        this._stateListener.onDisconnected(this, new HelixException(errorMsg));
                    }
                    catch (Exception e) {
                        LOG.warn("stateListener.onDisconnected callback fails", (Throwable)e);
                    }
                    break;
                }
            }
            case Expired: {
                LOG.warn("KeeperState:" + state + ", SessionId: " + this._sessionId + ", instance: " + this._instanceName + ", type: " + (Object)((Object)this._instanceType));
                break;
            }
            default: {
                LOG.info("KeeperState:" + state + ", currentSessionId: " + this._sessionId + ", instance: " + this._instanceName + ", type: " + (Object)((Object)this._instanceType));
            }
        }
    }

    @Deprecated
    public void handleNewSession() throws Exception {
        this.handleNewSession(null);
    }

    @Override
    public void handleNewSession(String sessionId) throws Exception {
        this.waitUntilConnected();
        if (sessionId != null && !this.getSessionId().equals(sessionId)) {
            LOG.warn("Session is expired and not handled. Expected: {}. Actual: {}.", (Object)sessionId, (Object)this.getSessionId());
            return;
        }
        if (sessionId == null) {
            sessionId = this.getSessionId();
            LOG.debug("Session id: <null> is passed in. Current session id: {} will be used.", (Object)sessionId);
        }
        LOG.info("Handle new session, instance: {}, type: {}, session id: {}.", new Object[]{this._instanceName, this._instanceType, sessionId});
        this.stopTimerTasks();
        if (this._leaderElectionHandler != null) {
            this._leaderElectionHandler.reset(false);
        }
        this.resetHandlers(false);
        this._baseDataAccessor.reset();
        if (!ZKUtil.isClusterSetup(this._clusterName, this._zkclient)) {
            throw new HelixException("Cluster structure is not set up for cluster: " + this._clusterName);
        }
        this._sessionStartTime = System.currentTimeMillis();
        switch (this._instanceType) {
            case PARTICIPANT: {
                this.handleNewSessionAsParticipant(sessionId);
                break;
            }
            case CONTROLLER: {
                this.handleNewSessionAsController();
                break;
            }
            case CONTROLLER_PARTICIPANT: {
                this.handleNewSessionAsParticipant(sessionId);
                this.handleNewSessionAsController();
                break;
            }
        }
        this.startTimerTasks();
        this.initHandlers(this._handlers);
        if (this._stateListener != null) {
            try {
                this._stateListener.onConnected(this);
            }
            catch (Exception e) {
                LOG.warn("stateListener.onConnected callback fails", (Throwable)e);
            }
        }
    }

    void handleNewSessionAsParticipant(String sessionId) throws Exception {
        if (this._participantManager != null) {
            this._participantManager.reset();
        }
        this._participantManager = new ParticipantManager(this, this._zkclient, this._sessionTimeout, this._liveInstanceInfoProvider, this._preConnectCallbacks, sessionId, this._helixManagerProperty);
        this._participantManager.handleNewSession();
    }

    void handleNewSessionAsController() {
        if (this._leaderElectionHandler != null) {
            this._leaderElectionHandler.init();
        } else {
            this._leaderElectionHandler = new CallbackHandler(this, this._zkclient, this._keyBuilder.controller(), new DistributedLeaderElection(this, this._controller, this._controllerTimerTasks), new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.CONTROLLER, this._callbackMonitors.get((Object)HelixConstants.ChangeType.CONTROLLER));
        }
    }

    @Override
    public ParticipantHealthReportCollector getHealthReportCollector() {
        return this._participantHealthInfoCollector;
    }

    @Override
    public void handleSessionEstablishmentError(Throwable error) throws Exception {
        LOG.warn("Handling Session Establishment Error. Disconnect Helix Manager.", error);
        this.disconnect();
        if (this._stateListener != null) {
            this._stateListener.onDisconnected(this, error);
        }
    }

    @Override
    public Long getSessionStartTime() {
        return this._sessionStartTime;
    }

    private RealmAwareZkClient createSingleRealmZkClient() {
        String shardingKey = this.buildShardingKey();
        ChainedPathZkSerializer zkSerializer = ChainedPathZkSerializer.builder(new ZNRecordSerializer()).build();
        RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().setRealmMode(RealmAwareZkClient.RealmMode.SINGLE_REALM).setZkRealmShardingKey(shardingKey).setSessionTimeout(this._sessionTimeout).build();
        RealmAwareZkClient.RealmAwareZkClientConfig clientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig();
        clientConfig.setZkSerializer(zkSerializer).setConnectInitTimeout(this._connectionInitTimeout).setMonitorType(this._instanceType.name()).setMonitorKey(this._clusterName).setMonitorInstanceName(this._instanceName).setMonitorRootPathOnly(this.isMonitorRootPathOnly());
        if (this._instanceType == InstanceType.ADMINISTRATOR) {
            return this.resolveZkClient(SharedZkClientFactory.getInstance(), connectionConfig, clientConfig);
        }
        return this.resolveZkClient(DedicatedZkClientFactory.getInstance(), connectionConfig, clientConfig);
    }

    private RealmAwareZkClient resolveZkClient(HelixZkClientFactory zkClientFactory, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) {
        if (Boolean.getBoolean("helix.multiZkEnabled")) {
            try {
                return zkClientFactory.buildZkClient(connectionConfig, clientConfig);
            }
            catch (IOException | IllegalArgumentException | InvalidRoutingDataException e) {
                throw new HelixException("Not able to connect on realm-aware mode for sharding key: " + connectionConfig.getZkRealmShardingKey(), e);
            }
        }
        HelixZkClient.ZkClientConfig helixZkClientConfig = clientConfig.createHelixZkClientConfig();
        HelixZkClient.ZkConnectionConfig helixZkConnectionConfig = new HelixZkClient.ZkConnectionConfig(this._zkAddress).setSessionTimeout(connectionConfig.getSessionTimeout());
        return zkClientFactory.buildZkClient(helixZkConnectionConfig, helixZkClientConfig);
    }

    private String buildShardingKey() {
        return this._clusterName.charAt(0) == '/' ? this._clusterName : "/" + this._clusterName;
    }

    protected static class StatusDumpTask
    extends HelixTimerTask {
        final HelixManager helixController;

        public StatusDumpTask(HelixManager helixController) {
            this.helixController = helixController;
        }

        @Override
        public synchronized void start() {
            long initialDelay = 0L;
            long period = 900000L;
            long timeThresholdNoChangeForStatusUpdates = 900000L;
            long timeThresholdNoChangeForErrors = 86400000L;
            int maximumNumberOfLeafNodesAllowed = 100;
            if (this._timer == null) {
                LOG.info("Start StatusDumpTask");
                this._timer = new Timer("StatusDumpTimerTask", true);
                this._timer.scheduleAtFixedRate((TimerTask)new ZKPathDataDumpTask(this.helixController, timeThresholdNoChangeForStatusUpdates, timeThresholdNoChangeForErrors, maximumNumberOfLeafNodesAllowed), initialDelay, period);
            }
        }

        @Override
        public synchronized void stop() {
            if (this._timer != null) {
                LOG.info("Stop StatusDumpTask");
                this._timer.cancel();
                this._timer = null;
            }
        }
    }
}

