/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.IOException;
import org.apache.helix.HelixException;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;

public abstract class GenericZkHelixApiBuilder<B extends GenericZkHelixApiBuilder<B>> {
    protected String _zkAddress;
    protected RealmAwareZkClient.RealmMode _realmMode;
    protected RealmAwareZkClient.RealmAwareZkConnectionConfig _realmAwareZkConnectionConfig;
    protected RealmAwareZkClient.RealmAwareZkClientConfig _realmAwareZkClientConfig;

    public B setZkAddress(String zkAddress) {
        this._zkAddress = zkAddress;
        return this.self();
    }

    public B setRealmMode(RealmAwareZkClient.RealmMode realmMode) {
        this._realmMode = realmMode;
        return this.self();
    }

    public B setRealmAwareZkConnectionConfig(RealmAwareZkClient.RealmAwareZkConnectionConfig realmAwareZkConnectionConfig) {
        this._realmAwareZkConnectionConfig = realmAwareZkConnectionConfig;
        return this.self();
    }

    public B setRealmAwareZkClientConfig(RealmAwareZkClient.RealmAwareZkClientConfig realmAwareZkClientConfig) {
        this._realmAwareZkClientConfig = realmAwareZkClientConfig;
        return this.self();
    }

    protected void validate() {
        boolean isZkAddressSet;
        boolean bl = isZkAddressSet = this._zkAddress != null && !this._zkAddress.isEmpty();
        if (this._realmMode == RealmAwareZkClient.RealmMode.SINGLE_REALM && !isZkAddressSet) {
            throw new HelixException("RealmMode cannot be single-realm without a valid ZkAddress set!");
        }
        if (this._realmMode == RealmAwareZkClient.RealmMode.MULTI_REALM && isZkAddressSet) {
            throw new HelixException("ZkAddress cannot be set on multi-realm mode!");
        }
        if (this._realmMode == null) {
            this._realmMode = isZkAddressSet ? RealmAwareZkClient.RealmMode.SINGLE_REALM : RealmAwareZkClient.RealmMode.MULTI_REALM;
        }
        this.initializeConfigsIfNull();
    }

    protected void initializeConfigsIfNull() {
        if (this._realmAwareZkConnectionConfig == null) {
            this._realmAwareZkConnectionConfig = new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().build();
        }
        if (this._realmAwareZkClientConfig == null) {
            this._realmAwareZkClientConfig = new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(new ZNRecordSerializer());
        }
    }

    protected RealmAwareZkClient createZkClient(RealmAwareZkClient.RealmMode realmMode, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig, String zkAddress) {
        switch (realmMode) {
            case MULTI_REALM: {
                try {
                    return new FederatedZkClient(connectionConfig, clientConfig.setZkSerializer(new ZNRecordSerializer()));
                }
                catch (IOException | IllegalStateException | InvalidRoutingDataException e) {
                    throw new HelixException("Failed to create FederatedZkClient!", e);
                }
            }
            case SINGLE_REALM: {
                return SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), clientConfig.createHelixZkClientConfig().setZkSerializer(new ZNRecordSerializer()));
            }
        }
        throw new HelixException("Invalid RealmMode given: " + (Object)((Object)realmMode));
    }

    final B self() {
        return (B)this;
    }
}

