/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.GenericZkHelixApiBuilder;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.api.client.ZkClientType;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;

public class GenericBaseDataAccessorBuilder<B extends GenericBaseDataAccessorBuilder<B>>
extends GenericZkHelixApiBuilder<B> {
    private ZkClientType _zkClientType;

    public B setZkClientType(ZkBaseDataAccessor.ZkClientType zkClientType) {
        return this.setZkClientType(Enum.valueOf(ZkClientType.class, zkClientType.name()));
    }

    public B setZkClientType(ZkClientType zkClientType) {
        this._zkClientType = zkClientType;
        return (B)((GenericBaseDataAccessorBuilder)this.self());
    }

    @Override
    protected void validate() {
        super.validate();
        this.validateZkClientType(this._zkClientType, this._realmMode);
    }

    @Override
    protected RealmAwareZkClient createZkClient(RealmAwareZkClient.RealmMode realmMode, RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig, String zkAddress) {
        RealmAwareZkClient zkClient;
        switch (realmMode) {
            case MULTI_REALM: {
                try {
                    if (this._zkClientType == ZkClientType.DEDICATED) {
                        zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(connectionConfig, clientConfig);
                        break;
                    }
                    if (this._zkClientType == ZkClientType.SHARED) {
                        zkClient = SharedZkClientFactory.getInstance().buildZkClient(connectionConfig, clientConfig);
                        break;
                    }
                    zkClient = new FederatedZkClient(connectionConfig, clientConfig);
                    break;
                }
                catch (IOException | IllegalStateException | InvalidRoutingDataException e) {
                    throw new HelixException("Not able to connect on multi-realm mode.", e);
                }
            }
            case SINGLE_REALM: {
                if (this._zkClientType == ZkClientType.DEDICATED) {
                    zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), clientConfig.createHelixZkClientConfig());
                    break;
                }
                zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddress), clientConfig.createHelixZkClientConfig());
                zkClient.waitUntilConnected(60000L, TimeUnit.MILLISECONDS);
                break;
            }
            default: {
                throw new HelixException("Invalid RealmMode given: " + (Object)((Object)realmMode));
            }
        }
        return zkClient;
    }

    private void validateZkClientType(ZkClientType zkClientType, RealmAwareZkClient.RealmMode realmMode) {
        boolean isZkClientTypeSet;
        boolean bl = isZkClientTypeSet = zkClientType != null;
        if (isZkClientTypeSet && realmMode == RealmAwareZkClient.RealmMode.MULTI_REALM) {
            throw new HelixException("ZkClientType cannot be set on multi-realm mode!");
        }
        if (!isZkClientTypeSet && realmMode == RealmAwareZkClient.RealmMode.SINGLE_REALM) {
            zkClientType = ZkClientType.SHARED;
        }
        if (realmMode == RealmAwareZkClient.RealmMode.SINGLE_REALM && zkClientType == ZkClientType.FEDERATED) {
            throw new HelixException("FederatedZkClient cannot be set on single-realm mode!");
        }
    }
}

