/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.Criteria;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.AsyncCallback;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.StatusUpdate;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerMessageHandlerFactory
implements MultiTypeMessageHandlerFactory {
    public static final String WAIT_ALL = "WAIT_ALL";
    public static final String SCHEDULER_MSG_ID = "SchedulerMessageId";
    public static final String SCHEDULER_TASK_QUEUE = "SchedulerTaskQueue";
    public static final String CONTROLLER_MSG_ID = "controllerMsgId";
    public static final int TASKQUEUE_BUCKET_NUM = 10;
    private static Logger _logger = LoggerFactory.getLogger(DefaultSchedulerMessageHandlerFactory.class);
    HelixManager _manager;

    public DefaultSchedulerMessageHandlerFactory(HelixManager manager) {
        this._manager = manager;
    }

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        String type = message.getMsgType();
        if (!type.equals(this.getMessageType())) {
            throw new HelixException("Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType());
        }
        return new DefaultSchedulerMessageHandler(message, context, this._manager);
    }

    @Override
    public String getMessageType() {
        return Message.MessageType.SCHEDULER_MSG.name();
    }

    @Override
    public List<String> getMessageTypes() {
        return ImmutableList.of((Object)Message.MessageType.SCHEDULER_MSG.name());
    }

    @Override
    public void reset() {
    }

    public static class DefaultSchedulerMessageHandler
    extends MessageHandler {
        HelixManager _manager;

        public DefaultSchedulerMessageHandler(Message message, NotificationContext context, HelixManager manager) {
            super(message, context);
            this._manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleMessageUsingScheduledTaskQueue(Criteria recipientCriteria, Message messageTemplate, String controllerMsgId) {
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            String clusterName = recipientCriteria.getClusterName();
            if (clusterName != null && !clusterName.equals(this._manager.getClusterName())) {
                throw new HelixException(String.format("ScheduledTaskQueue cannot send message to another cluster. Local cluster name %s, remote cluster name %s.", this._manager.getClusterName(), clusterName));
            }
            HashMap<String, String> sendSummary = new HashMap<String, String>();
            sendSummary.put("MessageCount", "0");
            Map<InstanceType, List<Message>> messages = this._manager.getMessagingService().generateMessage(recipientCriteria, messageTemplate);
            if (messages.size() > 0) {
                String taskQueueName = this._message.getRecord().getSimpleField(DefaultSchedulerMessageHandlerFactory.SCHEDULER_TASK_QUEUE);
                if (taskQueueName == null) {
                    throw new HelixException("SchedulerTaskMessage need to have SchedulerTaskQueue specified.");
                }
                IdealState newAddedScheduledTasks = new IdealState(taskQueueName);
                newAddedScheduledTasks.setBucketSize(10);
                newAddedScheduledTasks.setStateModelDefRef(DefaultSchedulerMessageHandlerFactory.SCHEDULER_TASK_QUEUE);
                HelixManager helixManager = this._manager;
                synchronized (helixManager) {
                    int existingTopPartitionId = 0;
                    IdealState currentTaskQueue = (IdealState)this._manager.getHelixDataAccessor().getProperty(accessor.keyBuilder().idealStates(newAddedScheduledTasks.getId()));
                    if (currentTaskQueue != null) {
                        existingTopPartitionId = this.findTopPartitionId(currentTaskQueue) + 1;
                    }
                    List taskMessages = (List)messages.values().toArray()[0];
                    for (Message task : taskMessages) {
                        String partitionId = taskQueueName + "_" + existingTopPartitionId;
                        ++existingTopPartitionId;
                        String instanceName = task.getTgtName();
                        newAddedScheduledTasks.setPartitionState(partitionId, instanceName, "COMPLETED");
                        task.getRecord().setSimpleField(instanceName, "COMPLETED");
                        task.getRecord().setSimpleField(DefaultSchedulerMessageHandlerFactory.CONTROLLER_MSG_ID, controllerMsgId);
                        LinkedList<String> priorityList = new LinkedList<String>();
                        priorityList.add(instanceName);
                        newAddedScheduledTasks.getRecord().setListField(partitionId, priorityList);
                        newAddedScheduledTasks.getRecord().setMapField(partitionId, task.getRecord().getSimpleFields());
                        _logger.info("Scheduling for controllerMsg " + controllerMsgId + " , sending task " + partitionId + " " + task.getMsgId() + " to " + instanceName);
                        if (!_logger.isDebugEnabled()) continue;
                        _logger.debug(task.getRecord().getSimpleFields().toString());
                    }
                    this._manager.getHelixDataAccessor().updateProperty(accessor.keyBuilder().idealStates(newAddedScheduledTasks.getId()), newAddedScheduledTasks);
                    sendSummary.put("MessageCount", "" + taskMessages.size());
                }
            }
            ZNRecord statusUpdate = ((HelixProperty)accessor.getProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), this._message.getMsgId()))).getRecord();
            statusUpdate.getMapFields().put("SentMessageCount", sendSummary);
            accessor.updateProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), this._message.getMsgId()), new StatusUpdate(statusUpdate));
        }

        private int findTopPartitionId(IdealState currentTaskQueue) {
            int topId = 0;
            for (String partitionName : currentTaskQueue.getPartitionSet()) {
                try {
                    String partitionNumStr = partitionName.substring(partitionName.lastIndexOf(95) + 1);
                    int num = Integer.parseInt(partitionNumStr);
                    if (topId >= num) continue;
                    topId = num;
                }
                catch (Exception e) {
                    _logger.error("", (Throwable)e);
                }
            }
            return topId;
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            Criteria recipientCriteria;
            String type = this._message.getMsgType();
            HelixTaskResult result = new HelixTaskResult();
            if (!type.equals(Message.MessageType.SCHEDULER_MSG.name())) {
                throw new HelixException("Unexpected msg type for message " + this._message.getMsgId() + " type:" + this._message.getMsgType());
            }
            int timeOut = -1;
            if (this._message.getRecord().getSimpleFields().containsKey("TIMEOUT")) {
                try {
                    timeOut = Integer.parseInt(this._message.getRecord().getSimpleFields().get("TIMEOUT"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ZNRecord record = new ZNRecord("templateMessage");
            record.getSimpleFields().putAll(this._message.getRecord().getMapField("MessageTemplate"));
            Message messageTemplate = new Message(record);
            StringReader sr = new StringReader(this._message.getRecord().getSimpleField("Criteria"));
            ObjectMapper mapper = new ObjectMapper();
            try {
                recipientCriteria = (Criteria)mapper.readValue((Reader)sr, Criteria.class);
            }
            catch (Exception e) {
                _logger.error("", (Throwable)e);
                result.setException(e);
                result.setSuccess(false);
                return result;
            }
            _logger.info("Scheduler sending message, criteria:" + recipientCriteria);
            boolean waitAll = false;
            if (this._message.getRecord().getSimpleField(DefaultSchedulerMessageHandlerFactory.WAIT_ALL) != null) {
                try {
                    waitAll = Boolean.parseBoolean(this._message.getRecord().getSimpleField(DefaultSchedulerMessageHandlerFactory.WAIT_ALL));
                }
                catch (Exception e) {
                    _logger.warn("", (Throwable)e);
                }
            }
            boolean hasSchedulerTaskQueue = this._message.getRecord().getSimpleFields().containsKey(DefaultSchedulerMessageHandlerFactory.SCHEDULER_TASK_QUEUE);
            if (InstanceType.PARTICIPANT == recipientCriteria.getRecipientInstanceType() && hasSchedulerTaskQueue) {
                this.handleMessageUsingScheduledTaskQueue(recipientCriteria, messageTemplate, this._message.getMsgId());
                result.setSuccess(true);
                result.getTaskResultMap().put(DefaultSchedulerMessageHandlerFactory.SCHEDULER_MSG_ID, this._message.getMsgId());
                result.getTaskResultMap().put("ControllerResult", "msg " + this._message.getMsgId() + " from " + this._message.getMsgSrc() + " processed");
                return result;
            }
            _logger.info("Scheduler sending message to Controller");
            int nMsgsSent = 0;
            SchedulerAsyncCallback callback = new SchedulerAsyncCallback(this._message, this._manager);
            nMsgsSent = waitAll ? this._manager.getMessagingService().sendAndWait(recipientCriteria, messageTemplate, callback, timeOut) : this._manager.getMessagingService().send(recipientCriteria, messageTemplate, callback, timeOut);
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            HashMap<String, String> sendSummary = new HashMap<String, String>();
            sendSummary.put("MessageCount", "" + nMsgsSent);
            ZNRecord statusUpdate = ((HelixProperty)accessor.getProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), this._message.getMsgId()))).getRecord();
            statusUpdate.getMapFields().put("SentMessageCount", sendSummary);
            accessor.setProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), this._message.getMsgId()), new StatusUpdate(statusUpdate));
            result.getTaskResultMap().put("ControllerResult", "msg " + this._message.getMsgId() + " from " + this._message.getMsgSrc() + " processed");
            result.getTaskResultMap().put(DefaultSchedulerMessageHandlerFactory.SCHEDULER_MSG_ID, this._message.getMsgId());
            result.setSuccess(true);
            return result;
        }

        @Override
        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            _logger.error("Message handling pipeline get an exception. MsgId:" + this._message.getMsgId(), (Throwable)e);
        }
    }

    public static class SchedulerAsyncCallback
    extends AsyncCallback {
        StatusUpdateUtil _statusUpdateUtil = new StatusUpdateUtil();
        Message _originalMessage;
        HelixManager _manager;
        final Map<String, Map<String, String>> _resultSummaryMap = new ConcurrentHashMap<String, Map<String, String>>();

        public SchedulerAsyncCallback(Message originalMessage, HelixManager manager) {
            this._originalMessage = originalMessage;
            this._manager = manager;
        }

        @Override
        public void onTimeOut() {
            _logger.info("Scheduler msg timeout " + this._originalMessage.getMsgId() + " timout with " + this._timeout + " Ms");
            this._statusUpdateUtil.logError(this._originalMessage, SchedulerAsyncCallback.class, "Task timeout", this._manager);
            this.addSummary(this._resultSummaryMap, this._originalMessage, this._manager, true);
        }

        @Override
        public void onReplyMessage(Message message) {
            _logger.info("Update for scheduler msg " + this._originalMessage.getMsgId() + " Message " + message.getMsgSrc() + " id " + message.getCorrelationId() + " completed");
            String key = "MessageResult " + message.getMsgSrc() + " " + UUID.randomUUID();
            this._resultSummaryMap.put(key, message.getResultMap());
            if (this.isDone()) {
                _logger.info("Scheduler msg " + this._originalMessage.getMsgId() + " completed");
                this._statusUpdateUtil.logInfo(this._originalMessage, SchedulerAsyncCallback.class, "Scheduler task completed", this._manager);
                this.addSummary(this._resultSummaryMap, this._originalMessage, this._manager, false);
            }
        }

        private void addSummary(Map<String, Map<String, String>> _resultSummaryMap, Message originalMessage, HelixManager manager, boolean timeOut) {
            TreeMap<String, String> summary = new TreeMap<String, String>();
            summary.put("TotalMessages:", "" + _resultSummaryMap.size());
            summary.put("Timeout", "" + timeOut);
            _resultSummaryMap.put("Summary", summary);
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            ZNRecord statusUpdate = ((HelixProperty)accessor.getProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), originalMessage.getMsgId()))).getRecord();
            statusUpdate.getMapFields().putAll(_resultSummaryMap);
            accessor.setProperty(keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), originalMessage.getMsgId()), new StatusUpdate(statusUpdate));
        }
    }
}

