/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.Partition;

public class CustomizedStateOutput {
    private final Map<String, Map<String, Map<Partition, Map<String, String>>>> _customizedStateMap = new HashMap<String, Map<String, Map<Partition, Map<String, String>>>>();

    public void setCustomizedState(String stateType, String resourceName, Partition partition, String instanceName, String state) {
        if (!this._customizedStateMap.containsKey(stateType)) {
            this._customizedStateMap.put(stateType, new HashMap());
        }
        if (!this._customizedStateMap.get(stateType).containsKey(resourceName)) {
            this._customizedStateMap.get(stateType).put(resourceName, new HashMap());
        }
        if (!this._customizedStateMap.get(stateType).get(resourceName).containsKey(partition)) {
            this._customizedStateMap.get(stateType).get(resourceName).put(partition, new HashMap());
        }
        this._customizedStateMap.get(stateType).get(resourceName).get(partition).put(instanceName, state);
    }

    public Map<String, Map<Partition, Map<String, String>>> getCustomizedStateMap(String stateType) {
        if (this._customizedStateMap.containsKey(stateType)) {
            return Collections.unmodifiableMap(this._customizedStateMap.get(stateType));
        }
        return Collections.emptyMap();
    }

    public Map<Partition, Map<String, String>> getResourceCustomizedStateMap(String stateType, String resourceName) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName)) {
            return Collections.unmodifiableMap(this.getCustomizedStateMap(stateType).get(resourceName));
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getPartitionCustomizedStateMap(String stateType, String resourceName, Partition partition) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName) && this.getResourceCustomizedStateMap(stateType, resourceName).containsKey(partition)) {
            return Collections.unmodifiableMap(this.getResourceCustomizedStateMap(stateType, resourceName).get(partition));
        }
        return Collections.emptyMap();
    }

    public String getPartitionCustomizedState(String stateType, String resourceName, Partition partition, String instanceName) {
        if (this.getCustomizedStateMap(stateType).containsKey(resourceName) && this.getResourceCustomizedStateMap(stateType, resourceName).containsKey(partition) && this.getPartitionCustomizedStateMap(stateType, resourceName, partition).containsKey(instanceName)) {
            return this.getPartitionCustomizedStateMap(stateType, resourceName, partition).get(instanceName);
        }
        return null;
    }

    public Set<String> getAllStateTypes() {
        return this._customizedStateMap.keySet();
    }
}

