/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.changedetector.ResourceChangeDetector;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.DelayedAutoRebalancer;
import org.apache.helix.controller.rebalancer.StatefulRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.DelayedRebalanceUtil;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithmFactory;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.controller.rebalancer.waged.model.OptimalAssignment;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.WagedRebalancerMetricCollector;
import org.apache.helix.monitoring.metrics.implementation.BaselineDivergenceGauge;
import org.apache.helix.monitoring.metrics.model.CountMetric;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;
import org.apache.helix.util.RebalanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagedRebalancer
implements StatefulRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(WagedRebalancer.class);
    private static final Set<HelixConstants.ChangeType> GLOBAL_REBALANCE_REQUIRED_CHANGE_TYPES = ImmutableSet.of((Object)((Object)HelixConstants.ChangeType.RESOURCE_CONFIG), (Object)((Object)HelixConstants.ChangeType.IDEAL_STATE), (Object)((Object)HelixConstants.ChangeType.CLUSTER_CONFIG), (Object)((Object)HelixConstants.ChangeType.INSTANCE_CONFIG));
    private static final Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> NOT_CONFIGURED_PREFERENCE = ImmutableMap.of((Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.EVENNESS), (Object)-1, (Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.LESS_MOVEMENT), (Object)-1);
    private static final RebalanceAlgorithm DEFAULT_REBALANCE_ALGORITHM = ConstraintBasedAlgorithmFactory.getInstance(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    private final ExecutorService _baselineCalculateExecutor;
    private final ResourceChangeDetector _changeDetector;
    private final HelixManager _manager;
    private final MappingCalculator<ResourceControllerDataProvider> _mappingCalculator;
    private final AssignmentMetadataStore _assignmentMetadataStore;
    private final MetricCollector _metricCollector;
    private final CountMetric _rebalanceFailureCount;
    private final CountMetric _baselineCalcCounter;
    private final LatencyMetric _baselineCalcLatency;
    private final LatencyMetric _writeLatency;
    private final CountMetric _partialRebalanceCounter;
    private final LatencyMetric _partialRebalanceLatency;
    private final LatencyMetric _stateReadLatency;
    private final BaselineDivergenceGauge _baselineDivergenceGauge;
    private boolean _asyncGlobalRebalanceEnabled;
    private RebalanceAlgorithm _rebalanceAlgorithm;
    private Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> _preference = NOT_CONFIGURED_PREFERENCE;

    private static AssignmentMetadataStore constructAssignmentStore(String metadataStoreAddrs, String clusterName) {
        if (metadataStoreAddrs != null && clusterName != null) {
            return new AssignmentMetadataStore(metadataStoreAddrs, clusterName);
        }
        return null;
    }

    public WagedRebalancer(HelixManager helixManager) {
        this(helixManager == null ? null : WagedRebalancer.constructAssignmentStore(helixManager.getMetadataStoreConnectionString(), helixManager.getClusterName()), DEFAULT_REBALANCE_ALGORITHM, new DelayedAutoRebalancer(), helixManager, helixManager == null ? new WagedRebalancerMetricCollector() : new WagedRebalancerMetricCollector(helixManager.getClusterName()), true);
        this._preference = ImmutableMap.copyOf(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    }

    protected WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, Optional<MetricCollector> metricCollectorOptional) {
        this(assignmentMetadataStore, algorithm, new DelayedAutoRebalancer(), null, metricCollectorOptional.orElse(new WagedRebalancerMetricCollector()), false);
    }

    private WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, MappingCalculator mappingCalculator, HelixManager manager, MetricCollector metricCollector, boolean isAsyncGlobalRebalanceEnabled) {
        if (assignmentMetadataStore == null) {
            LOG.warn("Assignment Metadata Store is not configured properly. The rebalancer will not access the assignment store during the rebalance.");
        }
        this._assignmentMetadataStore = assignmentMetadataStore;
        this._rebalanceAlgorithm = algorithm;
        this._mappingCalculator = mappingCalculator;
        if (manager == null) {
            LOG.warn("HelixManager is not provided. The rebalancer is not going to schedule for a future rebalance even when delayed rebalance is enabled.");
        }
        this._manager = manager;
        this._metricCollector = metricCollector;
        this._rebalanceFailureCount = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceFailureCounter.name(), CountMetric.class);
        this._baselineCalcCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.GlobalBaselineCalcCounter.name(), CountMetric.class);
        this._baselineCalcLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.GlobalBaselineCalcLatencyGauge.name(), LatencyMetric.class);
        this._partialRebalanceCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceCounter.name(), CountMetric.class);
        this._partialRebalanceLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceLatencyGauge.name(), LatencyMetric.class);
        this._writeLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateWriteLatencyGauge.name(), LatencyMetric.class);
        this._stateReadLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateReadLatencyGauge.name(), LatencyMetric.class);
        this._baselineDivergenceGauge = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.BaselineDivergenceGauge.name(), BaselineDivergenceGauge.class);
        this._changeDetector = new ResourceChangeDetector(true);
        this._baselineCalculateExecutor = Executors.newSingleThreadExecutor();
        this._asyncGlobalRebalanceEnabled = isAsyncGlobalRebalanceEnabled;
    }

    public void setGlobalRebalanceAsyncMode(boolean isAsyncGlobalRebalanceEnabled) {
        this._asyncGlobalRebalanceEnabled = isAsyncGlobalRebalanceEnabled;
    }

    public synchronized void updateRebalancePreference(Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> newPreference) {
        if (!this._preference.equals(NOT_CONFIGURED_PREFERENCE) && !this._preference.equals(newPreference)) {
            this._rebalanceAlgorithm = ConstraintBasedAlgorithmFactory.getInstance(newPreference);
            this._preference = ImmutableMap.copyOf(newPreference);
        }
    }

    @Override
    public void reset() {
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.reset();
        }
        this._changeDetector.resetSnapshots();
    }

    @Override
    public void close() {
        if (this._baselineCalculateExecutor != null) {
            this._baselineCalculateExecutor.shutdownNow();
        }
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.close();
        }
        this._metricCollector.unregister();
    }

    @Override
    public Map<String, IdealState> computeNewIdealStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) throws HelixRebalanceException {
        Map<String, IdealState> newIdealStates;
        if (resourceMap.isEmpty()) {
            LOG.warn("There is no resource to be rebalanced by {}", (Object)this.getClass().getSimpleName());
            return Collections.emptyMap();
        }
        LOG.info("Start computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        this.validateInput(clusterData, resourceMap);
        try {
            newIdealStates = this.computeBestPossibleStates(clusterData, resourceMap, currentStateOutput, this._rebalanceAlgorithm);
        }
        catch (HelixRebalanceException ex) {
            LOG.error("Failed to calculate the new assignments.", (Throwable)ex);
            this._rebalanceFailureCount.increment(1L);
            HelixRebalanceException.Type failureType = ex.getFailureType();
            if (failureType.equals((Object)HelixRebalanceException.Type.INVALID_REBALANCER_STATUS) || failureType.equals((Object)HelixRebalanceException.Type.UNKNOWN_FAILURE)) {
                throw ex;
            }
            LOG.warn("Returning the last known-good best possible assignment from metadata store due to rebalance failure of type: {}", (Object)failureType);
            Map<String, ResourceAssignment> assignmentRecord = this.getBestPossibleAssignment(this._assignmentMetadataStore, new CurrentStateOutput(), resourceMap.keySet());
            newIdealStates = this.convertResourceAssignment(clusterData, assignmentRecord);
        }
        newIdealStates.values().parallelStream().forEach(idealState -> {
            String resourceName = idealState.getResourceName();
            ResourceAssignment finalAssignment = this._mappingCalculator.computeBestPossiblePartitionState(clusterData, (IdealState)idealState, (Resource)resourceMap.get(resourceName), currentStateOutput);
            idealState.getRecord().getMapFields().clear();
            for (Partition partition : finalAssignment.getMappedPartitions()) {
                Map<String, String> newStateMap = finalAssignment.getReplicaMap(partition);
                idealState.setInstanceStateMap(partition.getPartitionName(), newStateMap == null ? Collections.emptyMap() : newStateMap);
            }
        });
        LOG.info("Finish computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        return newIdealStates;
    }

    private Map<String, IdealState> computeBestPossibleStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Set<String> activeNodes = DelayedRebalanceUtil.getActiveNodes(clusterData.getAllInstances(), clusterData.getEnabledLiveInstances(), clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterData.getClusterConfig());
        this.delayedRebalanceSchedule(clusterData, activeNodes, resourceMap.keySet());
        Map<String, IdealState> newIdealStates = this.convertResourceAssignment(clusterData, this.computeBestPossibleAssignment(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm));
        if (!activeNodes.equals(clusterData.getEnabledLiveInstances())) {
            this.applyRebalanceOverwrite(newIdealStates, clusterData, resourceMap, this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet()), algorithm);
        }
        newIdealStates.entrySet().stream().forEach(idealStateEntry -> this.applyUserDefinedPreferenceList(clusterData.getResourceConfig((String)idealStateEntry.getKey()), (IdealState)idealStateEntry.getValue()));
        return newIdealStates;
    }

    protected Map<String, ResourceAssignment> computeBestPossibleAssignment(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        this.globalRebalance(clusterData, resourceMap, currentStateOutput, algorithm);
        Map<String, ResourceAssignment> newAssignment = this.partialRebalance(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        return newAssignment;
    }

    private Map<String, IdealState> convertResourceAssignment(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> assignments) throws HelixRebalanceException {
        HashMap<String, IdealState> finalIdealStateMap = new HashMap<String, IdealState>();
        for (String resourceName : assignments.keySet()) {
            try {
                IdealState currentIdealState = clusterData.getIdealState(resourceName);
                Map<String, Integer> statePriorityMap = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()).getStatePriorityMap();
                IdealState newIdealState = new IdealState(resourceName);
                newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
                newIdealState.setPreferenceLists(this.getPreferenceLists(assignments.get(resourceName), statePriorityMap));
                finalIdealStateMap.put(resourceName, newIdealState);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to calculate the new IdealState for resource: " + resourceName, HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
        }
        return finalIdealStateMap;
    }

    private void globalRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        this._changeDetector.updateSnapshots(clusterData);
        Map<HelixConstants.ChangeType, Set<String>> clusterChanges = this._changeDetector.getAllChanges();
        if (clusterChanges.keySet().stream().anyMatch(GLOBAL_REBALANCE_REQUIRED_CHANGE_TYPES::contains)) {
            ClusterModel clusterModel;
            Map<String, ResourceAssignment> currentBaseline = this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
            try {
                clusterModel = ClusterModelProvider.generateClusterModelForBaseline(clusterData, resourceMap, clusterData.getAllInstances(), clusterChanges, currentBaseline);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to generate cluster model for global rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
            boolean waitForGlobalRebalance = !this._asyncGlobalRebalanceEnabled;
            String clusterName = clusterData.getClusterName();
            Future<Boolean> result = this._baselineCalculateExecutor.submit(() -> {
                try {
                    this.calculateAndUpdateBaseline(clusterModel, algorithm, !waitForGlobalRebalance, clusterName);
                }
                catch (HelixRebalanceException e) {
                    LOG.error("Failed to calculate baseline assignment!", (Throwable)e);
                    return false;
                }
                return true;
            });
            if (waitForGlobalRebalance) {
                try {
                    if (!result.get().booleanValue()) {
                        throw new HelixRebalanceException("Failed to calculate for the new Baseline.", HelixRebalanceException.Type.FAILED_TO_CALCULATE);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new HelixRebalanceException("Failed to execute new Baseline calculation.", HelixRebalanceException.Type.FAILED_TO_CALCULATE, e);
                }
            }
        }
    }

    private void calculateAndUpdateBaseline(ClusterModel clusterModel, RebalanceAlgorithm algorithm, boolean shouldSchedulePartialRebalance, String clusterName) throws HelixRebalanceException {
        LOG.info("Start calculating the new baseline.");
        this._baselineCalcCounter.increment(1L);
        this._baselineCalcLatency.startMeasuringLatency();
        boolean isBaselineChanged = false;
        Map<String, ResourceAssignment> newBaseline = this.calculateAssignment(clusterModel, algorithm);
        if (this._assignmentMetadataStore != null) {
            try {
                this._writeLatency.startMeasuringLatency();
                isBaselineChanged = this._assignmentMetadataStore.persistBaseline(newBaseline);
                this._writeLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to persist the new baseline assignment.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the baseline assignment.");
        }
        this._baselineCalcLatency.endMeasuringLatency();
        LOG.info("Global baseline calculation completed and has been persisted into metadata store.");
        if (isBaselineChanged && shouldSchedulePartialRebalance) {
            LOG.info("Schedule a new rebalance after the new baseline calculation has finished.");
            RebalanceUtil.scheduleOnDemandPipeline(clusterName, 0L, false);
        }
    }

    private Map<String, ResourceAssignment> partialRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        ClusterModel clusterModel;
        LOG.info("Start calculating the new best possible assignment.");
        this._partialRebalanceCounter.increment(1L);
        this._partialRebalanceLatency.startMeasuringLatency();
        Map<String, ResourceAssignment> currentBaseline = this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        Map<String, ResourceAssignment> currentBestPossibleAssignment = this.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        try {
            clusterModel = ClusterModelProvider.generateClusterModelForPartialRebalance(clusterData, resourceMap, activeNodes, currentBaseline, currentBestPossibleAssignment);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for partial rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, ResourceAssignment> newAssignment = this.calculateAssignment(clusterModel, algorithm);
        HashMap<String, ResourceAssignment> newAssignmentCopy = new HashMap<String, ResourceAssignment>();
        for (Map.Entry<String, ResourceAssignment> entry : newAssignment.entrySet()) {
            newAssignmentCopy.put(entry.getKey(), new ResourceAssignment(entry.getValue().getRecord()));
        }
        this._baselineDivergenceGauge.asyncMeasureAndUpdateValue(clusterData.getAsyncTasksThreadPool(), currentBaseline, newAssignmentCopy);
        if (this._assignmentMetadataStore != null) {
            try {
                this._writeLatency.startMeasuringLatency();
                this._assignmentMetadataStore.persistBestPossibleAssignment(newAssignment);
                this._writeLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to persist the new best possible assignment.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the baseline assignment.");
        }
        this._partialRebalanceLatency.endMeasuringLatency();
        LOG.info("Finish calculating the new best possible assignment.");
        return newAssignment;
    }

    private Map<String, ResourceAssignment> calculateAssignment(ClusterModel clusterModel, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        long startTime = System.currentTimeMillis();
        LOG.info("Start calculating for an assignment with algorithm {}", (Object)algorithm.getClass().getSimpleName());
        OptimalAssignment optimalAssignment = algorithm.calculate(clusterModel);
        Map<String, ResourceAssignment> newAssignment = optimalAssignment.getOptimalResourceAssignment();
        LOG.info("Finish calculating an assignment with algorithm {}. Took: {} ms.", (Object)algorithm.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - startTime));
        return newAssignment;
    }

    private Map<String, List<String>> getPreferenceLists(ResourceAssignment newAssignment, Map<String, Integer> statePriorityMap) {
        HashMap<String, List<String>> preferenceList = new HashMap<String, List<String>>();
        for (Partition partition : newAssignment.getMappedPartitions()) {
            ArrayList<String> nodes = new ArrayList<String>(newAssignment.getReplicaMap(partition).keySet());
            nodes.sort((node1, node2) -> {
                int statePriority2;
                int statePriority1 = (Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node1));
                if (statePriority1 == (statePriority2 = ((Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node2))).intValue())) {
                    return node1.compareTo((String)node2);
                }
                return statePriority1 - statePriority2;
            });
            preferenceList.put(partition.getPartitionName(), nodes);
        }
        return preferenceList;
    }

    private void validateInput(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap) throws HelixRebalanceException {
        Set nonCompatibleResources = resourceMap.entrySet().stream().filter(resourceEntry -> {
            IdealState is = clusterData.getIdealState((String)resourceEntry.getKey());
            return is == null || !is.getRebalanceMode().equals((Object)IdealState.RebalanceMode.FULL_AUTO) || !WagedRebalancer.class.getName().equals(is.getRebalancerClassName());
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!nonCompatibleResources.isEmpty()) {
            throw new HelixRebalanceException(String.format("Input contains invalid resource(s) that cannot be rebalanced by the WAGED rebalancer. %s", nonCompatibleResources.toString()), HelixRebalanceException.Type.INVALID_INPUT);
        }
    }

    private Map<String, ResourceAssignment> getBaselineAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        Map<Object, Object> currentBaseline = Collections.emptyMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBaseline = assignmentMetadataStore.getBaseline();
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current baseline assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        if (currentBaseline.isEmpty()) {
            LOG.warn("The current baseline assignment record is empty. Use the current states instead.");
            currentBaseline = currentStateOutput.getAssignment(resources);
        }
        currentBaseline.keySet().retainAll(resources);
        return currentBaseline;
    }

    protected Map<String, ResourceAssignment> getBestPossibleAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        Map<Object, Object> currentBestAssignment = Collections.emptyMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBestAssignment = assignmentMetadataStore.getBestPossibleAssignment();
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current best possible assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        if (currentBestAssignment.isEmpty()) {
            LOG.warn("The current best possible assignment record is empty. Use the current states instead.");
            currentBestAssignment = currentStateOutput.getAssignment(resources);
        }
        currentBestAssignment.keySet().retainAll(resources);
        return currentBestAssignment;
    }

    private void delayedRebalanceSchedule(ResourceControllerDataProvider clusterData, Set<String> delayedActiveNodes, Set<String> resourceSet) {
        if (this._manager != null) {
            ClusterConfig clusterConfig = clusterData.getClusterConfig();
            boolean delayedRebalanceEnabled = DelayedRebalanceUtil.isDelayRebalanceEnabled(clusterConfig);
            HashSet<String> offlineOrDisabledInstances = new HashSet<String>(delayedActiveNodes);
            offlineOrDisabledInstances.removeAll(clusterData.getEnabledLiveInstances());
            for (String resource : resourceSet) {
                DelayedRebalanceUtil.setRebalanceScheduler(resource, delayedRebalanceEnabled, offlineOrDisabledInstances, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterConfig.getRebalanceDelayTime(), clusterConfig, this._manager);
            }
        } else {
            LOG.warn("Skip scheduling a delayed rebalancer since HelixManager is not specified.");
        }
    }

    private void applyRebalanceOverwrite(Map<String, IdealState> idealStateMap, ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Map<String, ResourceAssignment> baseline, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        ClusterModel clusterModel;
        try {
            clusterModel = ClusterModelProvider.generateClusterModelFromExistingAssignment(clusterData, resourceMap, baseline);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for delayed rebalance overwrite.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, IdealState> activeIdealStates = this.convertResourceAssignment(clusterData, this.calculateAssignment(clusterModel, algorithm));
        for (String resourceName : idealStateMap.keySet()) {
            IdealState newIdealState = idealStateMap.get(resourceName);
            if (!activeIdealStates.containsKey(resourceName)) {
                throw new HelixRebalanceException("Failed to calculate the complete partition assignment with all active nodes. Cannot find the resource assignment for " + resourceName, HelixRebalanceException.Type.FAILED_TO_CALCULATE);
            }
            IdealState newActiveIdealState = activeIdealStates.get(resourceName);
            IdealState currentIdealState = clusterData.getIdealState(resourceName);
            Set<String> enabledLiveInstances = clusterData.getEnabledLiveInstances();
            int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
            int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
            Map<String, List<String>> finalPreferenceLists = DelayedRebalanceUtil.getFinalDelayedMapping(newActiveIdealState.getPreferenceLists(), newIdealState.getPreferenceLists(), enabledLiveInstances, Math.min(minActiveReplica, numReplica));
            newIdealState.setPreferenceLists(finalPreferenceLists);
        }
    }

    private void applyUserDefinedPreferenceList(ResourceConfig resourceConfig, IdealState idealState) {
        Map<String, List<String>> userDefinedPreferenceList;
        if (resourceConfig != null && !(userDefinedPreferenceList = resourceConfig.getPreferenceLists()).isEmpty()) {
            LOG.info("Using user defined preference list for partitions.");
            for (String partition : userDefinedPreferenceList.keySet()) {
                idealState.setPreferenceList(partition, userDefinedPreferenceList.get(partition));
            }
        }
    }

    protected AssignmentMetadataStore getAssignmentMetadataStore() {
        return this._assignmentMetadataStore;
    }

    protected MetricCollector getMetricCollector() {
        return this._metricCollector;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

