/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.Map;
import java.util.Optional;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithmFactory;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ResourceAssignment;

public class ReadOnlyWagedRebalancer
extends WagedRebalancer {
    public ReadOnlyWagedRebalancer(String metadataStoreAddress, String clusterName, Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> preferences) {
        super(new ReadOnlyAssignmentMetadataStore(metadataStoreAddress, clusterName), ConstraintBasedAlgorithmFactory.getInstance(preferences), Optional.empty());
    }

    private static class ReadOnlyAssignmentMetadataStore
    extends AssignmentMetadataStore {
        ReadOnlyAssignmentMetadataStore(String metadataStoreAddress, String clusterName) {
            super(new ZkBucketDataAccessor(metadataStoreAddress), clusterName);
        }

        @Override
        public boolean persistBaseline(Map<String, ResourceAssignment> globalBaseline) {
            if (this.compareAssignments(this._globalBaseline, globalBaseline)) {
                return false;
            }
            this._globalBaseline = globalBaseline;
            return true;
        }

        @Override
        public boolean persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) {
            if (this.compareAssignments(this._bestPossibleAssignment, bestPossibleAssignment)) {
                return false;
            }
            this._bestPossibleAssignment = bestPossibleAssignment;
            return true;
        }
    }
}

