/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManagerProperty;
import org.apache.helix.model.CloudConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelixPropertyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HelixPropertyFactory.class);
    private static final String HELIX_PARTICIPANT_PROPERTY_FILE = "helix-manager.properties";

    public static HelixPropertyFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public HelixManagerProperty getHelixManagerProperty(String zkAddress, String clusterName) {
        CloudConfig cloudConfig;
        ConfigAccessor configAccessor = new ConfigAccessor(zkAddress);
        try {
            cloudConfig = configAccessor.getCloudConfig(clusterName) == null ? HelixPropertyFactory.buildEmptyCloudConfig(clusterName) : configAccessor.getCloudConfig(clusterName);
        }
        catch (HelixException e) {
            cloudConfig = HelixPropertyFactory.buildEmptyCloudConfig(clusterName);
        }
        Properties properties = new Properties();
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(HELIX_PARTICIPANT_PROPERTY_FILE);
            properties.load(stream);
        }
        catch (IOException e) {
            String errMsg = String.format("failed to open Helix participant properties file: %s", HELIX_PARTICIPANT_PROPERTY_FILE);
            throw new IllegalArgumentException(errMsg, e);
        }
        LOG.info("HelixPropertyFactory successfully loaded helix participant properties: {}", (Object)properties);
        return new HelixManagerProperty(properties, cloudConfig);
    }

    public static CloudConfig buildEmptyCloudConfig(String clusterName) {
        return new CloudConfig.Builder().setCloudEnabled(false).build();
    }

    private static class SingletonHelper {
        private static final HelixPropertyFactory INSTANCE = new HelixPropertyFactory();

        private SingletonHelper() {
        }
    }
}

