/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.metric;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;

public class ZkClientPathMonitor
extends DynamicMBeanProvider {
    public static final String MONITOR_PATH = "PATH";
    private final String _sensorName;
    private final String _type;
    private final String _key;
    private final String _instanceName;
    private final PredefinedPath _path;
    private SimpleDynamicMetric<Long> _readCounter;
    private SimpleDynamicMetric<Long> _writeCounter;
    private SimpleDynamicMetric<Long> _readBytesCounter;
    private SimpleDynamicMetric<Long> _writeBytesCounter;
    private SimpleDynamicMetric<Long> _readFailureCounter;
    private SimpleDynamicMetric<Long> _writeFailureCounter;
    private SimpleDynamicMetric<Long> _readTotalLatencyCounter;
    private SimpleDynamicMetric<Long> _writeTotalLatencyCounter;
    private HistogramDynamicMetric _readLatencyGauge;
    private HistogramDynamicMetric _writeLatencyGauge;
    private HistogramDynamicMetric _readBytesGauge;
    private HistogramDynamicMetric _writeBytesGauge;
    private HistogramDynamicMetric _dataPropagationLatencyGauge;
    @Deprecated
    private HistogramDynamicMetric _dataPropagationLatencyGuage;

    public String getSensorName() {
        return this._sensorName;
    }

    public ZkClientPathMonitor(PredefinedPath path, String monitorType, String monitorKey, String monitorInstanceName) {
        this._type = monitorType;
        this._key = monitorKey;
        this._instanceName = monitorInstanceName;
        this._path = path;
        this._sensorName = String.format("%s.%s.%s.%s", MonitorDomainNames.HelixZkClient.name(), monitorType, monitorKey, path.name());
        this._writeTotalLatencyCounter = new SimpleDynamicMetric(PredefinedMetricDomains.WriteTotalLatencyCounter.name(), (Object)0L);
        this._readTotalLatencyCounter = new SimpleDynamicMetric(PredefinedMetricDomains.ReadTotalLatencyCounter.name(), (Object)0L);
        this._writeFailureCounter = new SimpleDynamicMetric(PredefinedMetricDomains.WriteFailureCounter.name(), (Object)0L);
        this._readFailureCounter = new SimpleDynamicMetric(PredefinedMetricDomains.ReadFailureCounter.name(), (Object)0L);
        this._writeBytesCounter = new SimpleDynamicMetric(PredefinedMetricDomains.WriteBytesCounter.name(), (Object)0L);
        this._readBytesCounter = new SimpleDynamicMetric(PredefinedMetricDomains.ReadBytesCounter.name(), (Object)0L);
        this._writeCounter = new SimpleDynamicMetric(PredefinedMetricDomains.WriteCounter.name(), (Object)0L);
        this._readCounter = new SimpleDynamicMetric(PredefinedMetricDomains.ReadCounter.name(), (Object)0L);
        this._readLatencyGauge = new HistogramDynamicMetric(PredefinedMetricDomains.ReadLatencyGauge.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._writeLatencyGauge = new HistogramDynamicMetric(PredefinedMetricDomains.WriteLatencyGauge.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._readBytesGauge = new HistogramDynamicMetric(PredefinedMetricDomains.ReadBytesGauge.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._writeBytesGauge = new HistogramDynamicMetric(PredefinedMetricDomains.WriteBytesGauge.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._dataPropagationLatencyGauge = new HistogramDynamicMetric(PredefinedMetricDomains.DataPropagationLatencyGauge.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._dataPropagationLatencyGuage = new HistogramDynamicMetric(PredefinedMetricDomains.DataPropagationLatencyGuage.name(), new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
    }

    public ZkClientPathMonitor register() throws JMException {
        ArrayList<Object> attributeList = new ArrayList<Object>();
        attributeList.add(this._readCounter);
        attributeList.add(this._writeCounter);
        attributeList.add(this._readBytesCounter);
        attributeList.add(this._writeBytesCounter);
        attributeList.add(this._readFailureCounter);
        attributeList.add(this._writeFailureCounter);
        attributeList.add(this._readTotalLatencyCounter);
        attributeList.add(this._writeTotalLatencyCounter);
        attributeList.add(this._readLatencyGauge);
        attributeList.add(this._writeLatencyGauge);
        attributeList.add(this._readBytesGauge);
        attributeList.add(this._writeBytesGauge);
        attributeList.add(this._dataPropagationLatencyGauge);
        attributeList.add(this._dataPropagationLatencyGuage);
        ObjectName objectName = new ObjectName(String.format("%s,%s=%s", ZkClientMonitor.getObjectName(this._type, this._key, this._instanceName).toString(), MONITOR_PATH, this._path.name()));
        this.doRegister(attributeList, "Helix Zookeeper Client Monitor", objectName);
        return this;
    }

    protected synchronized void record(int bytes, long latencyMilliSec, boolean isFailure, boolean isRead) {
        if (isFailure) {
            this.increaseFailureCounter(isRead);
        } else {
            this.increaseCounter(isRead);
            this.increaseTotalLatency(isRead, latencyMilliSec);
            if (bytes > 0) {
                this.increaseBytesCounter(isRead, bytes);
            }
        }
    }

    public void recordDataPropagationLatency(long latency) {
        this._dataPropagationLatencyGauge.updateValue(Long.valueOf(latency));
        this._dataPropagationLatencyGuage.updateValue(Long.valueOf(latency));
    }

    private void increaseFailureCounter(boolean isRead) {
        if (isRead) {
            this._readFailureCounter.updateValue((Object)((Long)this._readFailureCounter.getValue() + 1L));
        } else {
            this._writeFailureCounter.updateValue((Object)((Long)this._writeFailureCounter.getValue() + 1L));
        }
    }

    private void increaseCounter(boolean isRead) {
        if (isRead) {
            this._readCounter.updateValue((Object)((Long)this._readCounter.getValue() + 1L));
        } else {
            this._writeCounter.updateValue((Object)((Long)this._writeCounter.getValue() + 1L));
        }
    }

    private void increaseBytesCounter(boolean isRead, int bytes) {
        if (isRead) {
            this._readBytesCounter.updateValue((Object)((Long)this._readBytesCounter.getValue() + (long)bytes));
            this._readBytesGauge.updateValue(Long.valueOf(bytes));
        } else {
            this._writeBytesCounter.updateValue((Object)((Long)this._writeBytesCounter.getValue() + (long)bytes));
            this._writeBytesGauge.updateValue(Long.valueOf(bytes));
        }
    }

    private void increaseTotalLatency(boolean isRead, long latencyDelta) {
        if (isRead) {
            this._readTotalLatencyCounter.updateValue((Object)((Long)this._readTotalLatencyCounter.getValue() + latencyDelta));
            this._readLatencyGauge.updateValue(Long.valueOf(latencyDelta));
        } else {
            this._writeTotalLatencyCounter.updateValue((Object)((Long)this._writeTotalLatencyCounter.getValue() + latencyDelta));
            this._writeLatencyGauge.updateValue(Long.valueOf(latencyDelta));
        }
    }

    public static enum PredefinedMetricDomains {
        WriteTotalLatencyCounter,
        ReadTotalLatencyCounter,
        WriteFailureCounter,
        ReadFailureCounter,
        WriteBytesCounter,
        ReadBytesCounter,
        WriteCounter,
        ReadCounter,
        ReadLatencyGauge,
        WriteLatencyGauge,
        ReadBytesGauge,
        WriteBytesGauge,
        DataPropagationLatencyGauge,
        DataPropagationLatencyGuage;

    }

    public static enum PredefinedPath {
        IdealStates(".*/IDEALSTATES/.*"),
        Instances(".*/INSTANCES/.*"),
        Configs(".*/CONFIGS/.*"),
        Controller(".*/CONTROLLER/.*"),
        ExternalView(".*/EXTERNALVIEW/.*"),
        LiveInstances(".*/LIVEINSTANCES/.*"),
        PropertyStore(".*/PROPERTYSTORE/.*"),
        CurrentStates(".*/CURRENTSTATES/.*"),
        Messages(".*/MESSAGES/.*"),
        Root(".*");

        private final String _matchString;

        private PredefinedPath(String matchString) {
            this._matchString = matchString;
        }

        public boolean match(String path) {
            return path.matches(this._matchString);
        }
    }
}

