/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;

public class ClusterLiveNodesVerifier
extends ZkHelixClusterVerifier {
    final Set<String> _expectLiveNodes;

    @Deprecated
    public ClusterLiveNodesVerifier(RealmAwareZkClient zkclient, String clusterName, List<String> expectLiveNodes) {
        super(zkclient, clusterName);
        this._expectLiveNodes = new HashSet<String>(expectLiveNodes);
    }

    private ClusterLiveNodesVerifier(RealmAwareZkClient zkClient, String clusterName, Set<String> expectLiveNodes) {
        super(zkClient, clusterName);
        this._expectLiveNodes = expectLiveNodes == null ? new HashSet<String>() : new HashSet<String>(expectLiveNodes);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.liveInstances(), false, true, true));
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected boolean verifyState() throws Exception {
        HashSet<String> actualLiveNodes = new HashSet<String>(this._accessor.getChildNames(this._keyBuilder.liveInstances()));
        return this._expectLiveNodes.equals(actualLiveNodes);
    }

    public static class Builder
    extends ZkHelixClusterVerifier.Builder<Builder> {
        private final String _clusterName;
        private final Set<String> _expectLiveNodes;

        public Builder(String clusterName, Set<String> expectLiveNodes) {
            this._clusterName = clusterName;
            this._expectLiveNodes = expectLiveNodes;
        }

        public ClusterLiveNodesVerifier build() {
            if (this._clusterName == null || this._clusterName.isEmpty()) {
                throw new IllegalArgumentException("Cluster name is missing!");
            }
            this.validate();
            return new ClusterLiveNodesVerifier(this.createZkClient(RealmAwareZkClient.RealmMode.SINGLE_REALM, this._realmAwareZkConnectionConfig, this._realmAwareZkClientConfig, this._zkAddress), this._clusterName, this._expectLiveNodes);
        }
    }
}

