/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.cloud.constants.CloudProvider;
import org.apache.helix.manager.zk.GenericZkHelixApiBuilder;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.CloudConfig;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.ConstraintItemBuilder;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.FederatedZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSetup {
    private static Logger logger = LoggerFactory.getLogger(ClusterSetup.class);
    public static final String zkServerAddress = "zkSvr";
    public static final String listClusters = "listClusters";
    public static final String listResources = "listResources";
    public static final String listInstances = "listInstances";
    public static final String addCluster = "addCluster";
    public static final String activateCluster = "activateCluster";
    public static final String dropCluster = "dropCluster";
    public static final String dropResource = "dropResource";
    public static final String addInstance = "addNode";
    public static final String addResource = "addResource";
    public static final String addStateModelDef = "addStateModelDef";
    public static final String addIdealState = "addIdealState";
    public static final String swapInstance = "swapInstance";
    public static final String dropInstance = "dropNode";
    public static final String rebalance = "rebalance";
    public static final String expandCluster = "expandCluster";
    public static final String expandResource = "expandResource";
    public static final String mode = "mode";
    public static final String tag = "tag";
    public static final String instanceGroupTag = "instanceGroupTag";
    public static final String bucketSize = "bucketSize";
    public static final String resourceKeyPrefix = "key";
    public static final String maxPartitionsPerNode = "maxPartitionsPerNode";
    public static final String addResourceProperty = "addResourceProperty";
    public static final String removeResourceProperty = "removeResourceProperty";
    public static final String addInstanceTag = "addInstanceTag";
    public static final String removeInstanceTag = "removeInstanceTag";
    public static final String enableResource = "enableResource";
    public static final String listClusterInfo = "listClusterInfo";
    public static final String listInstanceInfo = "listInstanceInfo";
    public static final String listResourceInfo = "listResourceInfo";
    public static final String listPartitionInfo = "listPartitionInfo";
    public static final String listStateModels = "listStateModels";
    public static final String listStateModel = "listStateModel";
    public static final String enableInstance = "enableInstance";
    public static final String enablePartition = "enablePartition";
    public static final String enableCluster = "enableCluster";
    public static final String resetPartition = "resetPartition";
    public static final String resetInstance = "resetInstance";
    public static final String resetResource = "resetResource";
    public static final String help = "help";
    public static final String getConfig = "getConfig";
    public static final String setConfig = "setConfig";
    public static final String removeConfig = "removeConfig";
    public static final String getConstraints = "getConstraints";
    public static final String setConstraint = "setConstraint";
    public static final String removeConstraint = "removeConstraint";
    private static final Logger _logger = LoggerFactory.getLogger(ClusterSetup.class);
    private final RealmAwareZkClient _zkClient;
    private final boolean _usesExternalZkClient;
    private final HelixAdmin _admin;

    @Deprecated
    public ClusterSetup(String zkServerAddress) {
        if (Boolean.parseBoolean(System.getProperty("helix.multiZkEnabled"))) {
            try {
                this._zkClient = new FederatedZkClient(new RealmAwareZkClient.RealmAwareZkConnectionConfig.Builder().build(), new RealmAwareZkClient.RealmAwareZkClientConfig().setZkSerializer(new ZNRecordSerializer()));
            }
            catch (IOException | IllegalStateException | InvalidRoutingDataException e) {
                throw new HelixException("Failed to create ConfigAccessor!", e);
            }
        } else {
            this._zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkServerAddress));
            this._zkClient.setZkSerializer(new ZNRecordSerializer());
        }
        this._admin = new ZKHelixAdmin(this._zkClient);
        this._usesExternalZkClient = false;
    }

    @Deprecated
    public ClusterSetup(RealmAwareZkClient zkClient) {
        this._zkClient = zkClient;
        this._admin = new ZKHelixAdmin(this._zkClient);
        this._usesExternalZkClient = true;
    }

    @Deprecated
    public ClusterSetup(RealmAwareZkClient zkClient, HelixAdmin zkHelixAdmin) {
        this._zkClient = zkClient;
        this._admin = zkHelixAdmin;
        this._usesExternalZkClient = true;
    }

    private ClusterSetup(RealmAwareZkClient zkClient, boolean usesExternalZkClient) {
        this._zkClient = zkClient;
        this._admin = new ZKHelixAdmin(this._zkClient);
        this._usesExternalZkClient = usesExternalZkClient;
    }

    public void close() {
        if (this._zkClient != null && !this._usesExternalZkClient) {
            this._admin.close();
            this._zkClient.close();
        }
    }

    public void addCluster(String clusterName, boolean overwritePrevious, CloudConfig cloudConfig) throws HelixException {
        this._admin.addCluster(clusterName, overwritePrevious);
        for (BuiltInStateModelDefinitions def : BuiltInStateModelDefinitions.values()) {
            this.addStateModelDef(clusterName, def.getStateModelDefinition().getId(), def.getStateModelDefinition(), overwritePrevious);
        }
        if (cloudConfig != null) {
            this._admin.addCloudConfig(clusterName, cloudConfig);
            if (cloudConfig.isCloudEnabled() && cloudConfig.getCloudProvider().equals(CloudProvider.AZURE.name())) {
                ConfigAccessor configAccessor = new ConfigAccessor(this._zkClient);
                ClusterConfig clusterConfig = new ClusterConfig(clusterName);
                clusterConfig.setTopology("/faultDomain/hostname");
                clusterConfig.setTopologyAwareEnabled(true);
                clusterConfig.setFaultZoneType("faultDomain");
                configAccessor.updateClusterConfig(clusterName, clusterConfig);
            }
        }
    }

    public void addCluster(String clusterName, boolean overwritePrevious) {
        this.addCluster(clusterName, overwritePrevious, null);
    }

    public void activateCluster(String clusterName, String grandCluster, boolean enable) {
        if (enable) {
            this._admin.addClusterToGrandCluster(clusterName, grandCluster);
        } else {
            this._admin.dropResource(grandCluster, clusterName);
        }
    }

    public void deleteCluster(String clusterName) {
        this._admin.dropCluster(clusterName);
    }

    public void addInstancesToCluster(String clusterName, String[] instanceInfoArray) {
        for (String instanceInfo : instanceInfoArray) {
            if (instanceInfo.length() <= 0) continue;
            this.addInstanceToCluster(clusterName, instanceInfo);
        }
    }

    public void addInstanceToCluster(String clusterName, String instanceId) {
        InstanceConfig config = InstanceConfig.toInstanceConfig(instanceId);
        this._admin.addInstance(clusterName, config);
    }

    public void addInstanceTag(String clusterName, String instanceName, String tag) {
        this._admin.addInstanceTag(clusterName, instanceName, tag);
    }

    public void dropInstancesFromCluster(String clusterName, String[] instanceInfoArray) {
        for (String instanceInfo : instanceInfoArray) {
            if (instanceInfo.length() <= 0) continue;
            this.dropInstanceFromCluster(clusterName, instanceInfo);
        }
    }

    public void dropInstanceFromCluster(String clusterName, String instanceId) {
        InstanceConfig instanceConfig;
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(keyBuilder.liveInstance(instanceId = (instanceConfig = InstanceConfig.toInstanceConfig(instanceId)).getInstanceName()));
        if (liveInstance != null) {
            throw new HelixException(String.format("Cannot drop instance %s as it is still live. Please stop it first", instanceId));
        }
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceId));
        if (config == null) {
            String error = "Node " + instanceId + " does not exist, cannot drop";
            _logger.warn(error);
            throw new HelixException(error);
        }
        ClusterConfig clusterConfig = (ClusterConfig)accessor.getProperty(keyBuilder.clusterConfig());
        if (config.getInstanceEnabled() && (clusterConfig.getDisabledInstances() == null || !clusterConfig.getDisabledInstances().containsKey(instanceId))) {
            String error = "Node " + instanceId + " is enabled, cannot drop";
            _logger.warn(error);
            throw new HelixException(error);
        }
        this._admin.dropInstance(clusterName, config);
    }

    public void swapInstance(String clusterName, final String oldInstanceName, final String newInstanceName) {
        if (oldInstanceName.equals(newInstanceName)) {
            _logger.info("Old instance has same name as new instance, no need to swap");
            return;
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig newConfig = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(newInstanceName));
        if (newConfig == null) {
            String error = "New instance " + newInstanceName + " does not exist, cannot swap";
            _logger.warn(error);
            throw new HelixException(error);
        }
        try {
            this.dropInstanceFromCluster(clusterName, oldInstanceName);
        }
        catch (HelixException e) {
            if (e.toString().contains("does not exist")) {
                _logger.warn("Instance {} does not exist, continue to swap instance for cluster {}", (Object)oldInstanceName, (Object)clusterName);
            }
            _logger.warn("Failed to drop instance {} from cluster {}", new Object[]{oldInstanceName, clusterName, e});
            throw e;
        }
        List<String> existingIdealStateNames = accessor.getChildNames(accessor.keyBuilder().idealStates());
        for (final String resourceName : existingIdealStateNames) {
            IdealState resourceIdealState = (IdealState)accessor.getProperty(accessor.keyBuilder().idealStates(resourceName));
            if (resourceIdealState.getRebalanceMode().equals((Object)IdealState.RebalanceMode.FULL_AUTO)) {
                _logger.warn("Resource {} is in FULL_AUTO rebalance mode, don't swap", (Object)resourceName);
                continue;
            }
            this.swapInstanceInIdealState(resourceIdealState, oldInstanceName, newInstanceName);
            accessor.updateProperty(accessor.keyBuilder().idealStates(resourceName), new DataUpdater<ZNRecord>(){

                @Override
                public ZNRecord update(ZNRecord znRecord) {
                    if (znRecord == null) {
                        throw new HelixException(String.format("swapInstance DataUpdater: IdealState for resource %s no longer exists!", resourceName));
                    }
                    ClusterSetup.this.swapInstanceInIdealState(new IdealState(znRecord), oldInstanceName, newInstanceName);
                    return znRecord;
                }
            }, resourceIdealState);
            _logger.info("Successfully swapped instance for resource {}", (Object)resourceName);
        }
    }

    void swapInstanceInIdealState(IdealState idealState, String oldInstance, String newInstance) {
        for (String partition : idealState.getRecord().getMapFields().keySet()) {
            Map<String, String> valMap = idealState.getRecord().getMapField(partition);
            if (!valMap.containsKey(oldInstance)) continue;
            valMap.put(newInstance, valMap.get(oldInstance));
            valMap.remove(oldInstance);
        }
        for (String partition : idealState.getRecord().getListFields().keySet()) {
            List<String> valList = idealState.getRecord().getListField(partition);
            for (int i = 0; i < valList.size(); ++i) {
                if (!valList.get(i).equals(oldInstance)) continue;
                valList.remove(i);
                valList.add(i, newInstance);
            }
        }
    }

    public HelixAdmin getClusterManagementTool() {
        return this._admin;
    }

    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition record) {
        this._admin.addStateModelDef(clusterName, stateModelDef, record);
    }

    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition record, boolean overwritePrevious) {
        this._admin.addStateModelDef(clusterName, stateModelDef, record, overwritePrevious);
    }

    public void addResourceToCluster(String clusterName, String resourceName, IdealState idealState) {
        this._admin.addResource(clusterName, resourceName, idealState);
    }

    public void addResourceToCluster(String clusterName, String resourceName, int numPartitions, String stateModelRef) {
        this.addResourceToCluster(clusterName, resourceName, numPartitions, stateModelRef, IdealState.RebalanceMode.SEMI_AUTO.toString());
    }

    public void addResourceToCluster(String clusterName, String resourceName, int numPartitions, String stateModelRef, String rebalancerMode) {
        this._admin.addResource(clusterName, resourceName, numPartitions, stateModelRef, rebalancerMode);
    }

    public void addResourceToCluster(String clusterName, String resourceName, int numPartitions, String stateModelRef, String rebalancerMode, String rebalanceStrategy) {
        this._admin.addResource(clusterName, resourceName, numPartitions, stateModelRef, rebalancerMode, rebalanceStrategy);
    }

    public void addResourceToCluster(String clusterName, String resourceName, int numPartitions, String stateModelRef, String rebalancerMode, int bucketSize) {
        this._admin.addResource(clusterName, resourceName, numPartitions, stateModelRef, rebalancerMode, bucketSize);
    }

    public void addResourceToCluster(String clusterName, String resourceName, int numPartitions, String stateModelRef, String rebalancerMode, int bucketSize, int maxPartitionsPerInstance) {
        this._admin.addResource(clusterName, resourceName, numPartitions, stateModelRef, rebalancerMode, bucketSize, maxPartitionsPerInstance);
    }

    public static String genIdealStateNameWithResourceTag(String resourceName, String resourceTag) {
        return resourceName + "$" + resourceTag;
    }

    public IdealState createIdealStateForResourceGroup(String resourceGroupName, String resourceTag, int numPartition, int replica, String rebalanceMode, String stateModelDefName) {
        String idealStateId = ClusterSetup.genIdealStateNameWithResourceTag(resourceGroupName, resourceTag);
        IdealState idealState = new IdealState(idealStateId);
        idealState.setNumPartitions(numPartition);
        idealState.setStateModelDefRef(stateModelDefName);
        IdealState.RebalanceMode mode = idealState.rebalanceModeFromString(rebalanceMode, IdealState.RebalanceMode.SEMI_AUTO);
        idealState.setRebalanceMode(mode);
        idealState.setReplicas("" + replica);
        idealState.setStateModelFactoryName("DEFAULT");
        idealState.setResourceGroupName(resourceGroupName);
        idealState.setInstanceGroupTag(resourceTag);
        idealState.enableGroupRouting(true);
        return idealState;
    }

    public void enableResource(String clusterName, String resourceName, String resourceTag, boolean enabled) {
        String idealStateId = ClusterSetup.genIdealStateNameWithResourceTag(resourceName, resourceTag);
        this._admin.enableResource(clusterName, idealStateId, enabled);
    }

    public void dropResourceFromCluster(String clusterName, String resourceName) {
        this._admin.dropResource(clusterName, resourceName);
    }

    public void rebalanceStorageCluster(String clusterName, String resourceName, int replica) {
        this.rebalanceStorageCluster(clusterName, resourceName, replica, resourceName);
    }

    public void rebalanceResource(String clusterName, String resourceName, int replica) {
        this.rebalanceStorageCluster(clusterName, resourceName, replica, resourceName);
    }

    public void expandResource(String clusterName, String resourceName) {
        IdealState idealState = this._admin.getResourceIdealState(clusterName, resourceName);
        if (idealState.getRebalanceMode() == IdealState.RebalanceMode.FULL_AUTO || idealState.getRebalanceMode() == IdealState.RebalanceMode.CUSTOMIZED) {
            _logger.info("Skipping idealState " + idealState.getResourceName() + " " + (Object)((Object)idealState.getRebalanceMode()));
            return;
        }
        boolean anyLiveInstance = false;
        for (List<String> list : idealState.getRecord().getListFields().values()) {
            if (!list.contains(IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString())) continue;
            _logger.info("Skipping idealState " + idealState.getResourceName() + " with ANY_LIVEINSTANCE");
            anyLiveInstance = true;
        }
        if (anyLiveInstance) {
            return;
        }
        try {
            int n = Integer.parseInt(idealState.getReplicas());
        }
        catch (Exception e) {
            _logger.error("", (Throwable)e);
            return;
        }
        if (idealState.getRecord().getListFields().size() == 0) {
            _logger.warn("Resource " + resourceName + " not balanced, skip");
            return;
        }
        this.balanceIdealState(clusterName, idealState);
    }

    public void expandCluster(String clusterName) {
        List<String> resources = this._admin.getResourcesInCluster(clusterName);
        for (String resourceName : resources) {
            this.expandResource(clusterName, resourceName);
        }
    }

    public void balanceIdealState(String clusterName, IdealState idealState) {
        List<String> instanceNames = this._admin.getInstancesInCluster(clusterName);
        this.rebalanceResource(clusterName, idealState, instanceNames);
    }

    private void rebalanceResource(String clusterName, IdealState idealState, List<String> instanceNames) {
        this._admin.rebalance(clusterName, idealState, instanceNames);
    }

    public void rebalanceStorageCluster(String clusterName, String resourceName, int replica, String keyPrefix) {
        this._admin.rebalance(clusterName, resourceName, replica, keyPrefix, "");
    }

    public void rebalanceCluster(String clusterName, String resourceName, int replica, String keyPrefix, String group) {
        this._admin.rebalance(clusterName, resourceName, replica, keyPrefix, group);
    }

    public void rebalanceStorageCluster(String clusterName, String resourceName, String group, int replica) {
        this._admin.rebalance(clusterName, resourceName, replica, resourceName, group);
    }

    public void setConfig(HelixConfigScope.ConfigScopeProperty type, String scopeArgsCsv, String keyValuePairs) {
        String[] scopeArgs = scopeArgsCsv.split("[\\s,]");
        HelixConfigScope scope = new HelixConfigScopeBuilder(type, scopeArgs).build();
        Map<String, String> keyValueMap = HelixUtil.parseCsvFormatedKeyValuePairs(keyValuePairs);
        this._admin.setConfig(scope, keyValueMap);
    }

    public void removeConfig(HelixConfigScope.ConfigScopeProperty type, String scopeArgsCsv, String keysCsv) {
        String[] scopeArgs = scopeArgsCsv.split("[\\s,]");
        HelixConfigScope scope = new HelixConfigScopeBuilder(type, scopeArgs).build();
        String[] keys = keysCsv.split("[\\s,]");
        this._admin.removeConfig(scope, Arrays.asList(keys));
    }

    public String getConfig(HelixConfigScope.ConfigScopeProperty type, String scopeArgsCsv, String keysCsv) {
        String[] scopeArgs = scopeArgsCsv.split("[\\s,]");
        HelixConfigScope scope = new HelixConfigScopeBuilder(type, scopeArgs).build();
        String[] keys = keysCsv.split("[\\s,]");
        Map<String, String> keyValueMap = this._admin.getConfig(scope, Arrays.asList(keys));
        ZNRecord record = new ZNRecord(type.toString());
        record.getSimpleFields().putAll(keyValueMap);
        ZNRecordSerializer serializer = new ZNRecordSerializer();
        return new String(serializer.serialize(record));
    }

    public void setConstraint(String clusterName, String constraintType, String constraintId, String constraintAttributesMap) {
        if (clusterName == null || constraintType == null || constraintId == null || constraintAttributesMap == null) {
            throw new IllegalArgumentException("fail to set constraint. missing clusterName|constraintType|constraintId|constraintAttributesMap");
        }
        ClusterConstraints.ConstraintType type = ClusterConstraints.ConstraintType.valueOf(constraintType);
        ConstraintItemBuilder builder = new ConstraintItemBuilder();
        Map<String, String> constraintAttributes = HelixUtil.parseCsvFormatedKeyValuePairs(constraintAttributesMap);
        ConstraintItem constraintItem = builder.addConstraintAttributes(constraintAttributes).build();
        this._admin.setConstraint(clusterName, type, constraintId, constraintItem);
    }

    public void removeConstraint(String clusterName, String constraintType, String constraintId) {
        if (clusterName == null || constraintType == null || constraintId == null) {
            throw new IllegalArgumentException("fail to remove constraint. missing clusterName|constraintType|constraintId");
        }
        ClusterConstraints.ConstraintType type = ClusterConstraints.ConstraintType.valueOf(constraintType);
        this._admin.removeConstraint(clusterName, type, constraintId);
    }

    public String getConstraints(String clusterName, String constraintType) {
        if (clusterName == null || constraintType == null) {
            throw new IllegalArgumentException("fail to get constraint. missing clusterName|constraintType");
        }
        ClusterConstraints.ConstraintType type = ClusterConstraints.ConstraintType.valueOf(constraintType);
        ClusterConstraints constraints = this._admin.getConstraints(clusterName, type);
        return new String(constraints.serialize(new ZNRecordSerializer()));
    }

    public void setupTestCluster(String clusterName) {
        this.addCluster(clusterName, true);
        String[] instanceInfoArray = new String[6];
        for (int i = 0; i < instanceInfoArray.length; ++i) {
            instanceInfoArray[i] = "localhost_" + (8900 + i);
        }
        this.addInstancesToCluster(clusterName, instanceInfoArray);
        this.addResourceToCluster(clusterName, "TestDB", 10, "MasterSlave");
        this.rebalanceStorageCluster(clusterName, "TestDB", 3);
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ClusterSetup.class.getName(), cliOptions);
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServerAddress);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)listClusters);
        OptionBuilder.withDescription((String)"List existing clusters");
        Option listClustersOption = OptionBuilder.create();
        listClustersOption.setArgs(0);
        listClustersOption.setRequired(false);
        OptionBuilder.withLongOpt((String)listResources);
        OptionBuilder.withDescription((String)"List resources hosted in a cluster");
        Option listResourceOption = OptionBuilder.create();
        listResourceOption.setArgs(1);
        listResourceOption.setRequired(false);
        listResourceOption.setArgName("clusterName <-tag TagValue>");
        OptionBuilder.withLongOpt((String)listInstances);
        OptionBuilder.withDescription((String)"List Instances in a cluster");
        Option listInstancesOption = OptionBuilder.create();
        listInstancesOption.setArgs(1);
        listInstancesOption.setRequired(false);
        listInstancesOption.setArgName("clusterName <-tag tagName>");
        OptionBuilder.withLongOpt((String)addCluster);
        OptionBuilder.withDescription((String)"Add a new cluster");
        Option addClusterOption = OptionBuilder.create();
        addClusterOption.setArgs(1);
        addClusterOption.setRequired(false);
        addClusterOption.setArgName("clusterName");
        OptionBuilder.withLongOpt((String)activateCluster);
        OptionBuilder.withDescription((String)"Enable/disable a cluster in distributed controller mode");
        Option activateClusterOption = OptionBuilder.create();
        activateClusterOption.setArgs(3);
        activateClusterOption.setRequired(false);
        activateClusterOption.setArgName("clusterName grandCluster true/false");
        OptionBuilder.withLongOpt((String)dropCluster);
        OptionBuilder.withDescription((String)"Delete a cluster");
        Option deleteClusterOption = OptionBuilder.create();
        deleteClusterOption.setArgs(1);
        deleteClusterOption.setRequired(false);
        deleteClusterOption.setArgName("clusterName");
        OptionBuilder.withLongOpt((String)addInstance);
        OptionBuilder.withDescription((String)"Add a new Instance to a cluster");
        Option addInstanceOption = OptionBuilder.create();
        addInstanceOption.setArgs(2);
        addInstanceOption.setRequired(false);
        addInstanceOption.setArgName("clusterName InstanceId");
        OptionBuilder.withLongOpt((String)addResource);
        OptionBuilder.withDescription((String)"Add a resource to a cluster");
        Option addResourceOption = OptionBuilder.create();
        addResourceOption.setArgs(4);
        addResourceOption.setRequired(false);
        addResourceOption.setArgName("clusterName resourceName partitionNum stateModelRef <-mode modeValue>");
        OptionBuilder.withLongOpt((String)expandResource);
        OptionBuilder.withDescription((String)"Expand resource to additional nodes");
        Option expandResourceOption = OptionBuilder.create();
        expandResourceOption.setArgs(2);
        expandResourceOption.setRequired(false);
        expandResourceOption.setArgName("clusterName resourceName");
        OptionBuilder.withLongOpt((String)expandCluster);
        OptionBuilder.withDescription((String)"Expand a cluster and all the resources");
        Option expandClusterOption = OptionBuilder.create();
        expandClusterOption.setArgs(1);
        expandClusterOption.setRequired(false);
        expandClusterOption.setArgName("clusterName");
        OptionBuilder.withLongOpt((String)mode);
        OptionBuilder.withDescription((String)"Specify resource mode, used with addResourceGroup command");
        Option resourceModeOption = OptionBuilder.create();
        resourceModeOption.setArgs(1);
        resourceModeOption.setRequired(false);
        resourceModeOption.setArgName("IdealState mode");
        OptionBuilder.withLongOpt((String)tag);
        OptionBuilder.withDescription((String)"Specify resource tag, used with listResources command");
        Option resourceTagOption = OptionBuilder.create();
        resourceTagOption.setArgs(1);
        resourceTagOption.setRequired(false);
        resourceTagOption.setArgName(tag);
        OptionBuilder.withLongOpt((String)bucketSize);
        OptionBuilder.withDescription((String)"Specify size of a bucket, used with addResourceGroup command");
        Option resourceBucketSizeOption = OptionBuilder.create();
        resourceBucketSizeOption.setArgs(1);
        resourceBucketSizeOption.setRequired(false);
        resourceBucketSizeOption.setArgName("Size of a bucket for a resource");
        OptionBuilder.withLongOpt((String)maxPartitionsPerNode);
        OptionBuilder.withDescription((String)"Specify max partitions per node, used with addResourceGroup command");
        Option maxPartitionsPerNodeOption = OptionBuilder.create();
        maxPartitionsPerNodeOption.setArgs(1);
        maxPartitionsPerNodeOption.setRequired(false);
        maxPartitionsPerNodeOption.setArgName("Max partitions per node for a resource");
        OptionBuilder.withLongOpt((String)resourceKeyPrefix);
        OptionBuilder.withDescription((String)"Specify resource key prefix, used with rebalance command");
        Option resourceKeyOption = OptionBuilder.create();
        resourceKeyOption.setArgs(1);
        resourceKeyOption.setRequired(false);
        resourceKeyOption.setArgName("Resource key prefix");
        OptionBuilder.withLongOpt((String)instanceGroupTag);
        OptionBuilder.withDescription((String)"Specify instance group tag, used with rebalance command");
        Option instanceGroupTagOption = OptionBuilder.create();
        instanceGroupTagOption.setArgs(1);
        instanceGroupTagOption.setRequired(false);
        instanceGroupTagOption.setArgName("Instance group tag");
        OptionBuilder.withLongOpt((String)addStateModelDef);
        OptionBuilder.withDescription((String)"Add a State model to a cluster");
        Option addStateModelDefOption = OptionBuilder.create();
        addStateModelDefOption.setArgs(2);
        addStateModelDefOption.setRequired(false);
        addStateModelDefOption.setArgName("clusterName <filename>");
        OptionBuilder.withLongOpt((String)addIdealState);
        OptionBuilder.withDescription((String)"Add a State model to a cluster");
        Option addIdealStateOption = OptionBuilder.create();
        addIdealStateOption.setArgs(3);
        addIdealStateOption.setRequired(false);
        addIdealStateOption.setArgName("clusterName resourceName <filename>");
        OptionBuilder.withLongOpt((String)dropInstance);
        OptionBuilder.withDescription((String)"Drop an existing Instance from a cluster");
        Option dropInstanceOption = OptionBuilder.create();
        dropInstanceOption.setArgs(2);
        dropInstanceOption.setRequired(false);
        dropInstanceOption.setArgName("clusterName InstanceId");
        OptionBuilder.withLongOpt((String)swapInstance);
        OptionBuilder.withDescription((String)"Swap an old instance from a cluster with a new instance");
        Option swapInstanceOption = OptionBuilder.create();
        swapInstanceOption.setArgs(3);
        swapInstanceOption.setRequired(false);
        swapInstanceOption.setArgName("clusterName oldInstance newInstance");
        OptionBuilder.withLongOpt((String)dropResource);
        OptionBuilder.withDescription((String)"Drop an existing resource from a cluster");
        Option dropResourceOption = OptionBuilder.create();
        dropResourceOption.setArgs(2);
        dropResourceOption.setRequired(false);
        dropResourceOption.setArgName("clusterName resourceName");
        OptionBuilder.withLongOpt((String)enableResource);
        OptionBuilder.withDescription((String)"Enable/disable a resource");
        OptionBuilder.hasArgs((int)3);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName resourceName true/false <-tag resourceTag>");
        Option enableResourceOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)rebalance);
        OptionBuilder.withDescription((String)"Rebalance a resource in a cluster");
        Option rebalanceOption = OptionBuilder.create();
        rebalanceOption.setArgs(3);
        rebalanceOption.setRequired(false);
        rebalanceOption.setArgName("clusterName resourceName replicas");
        OptionBuilder.withLongOpt((String)listInstanceInfo);
        OptionBuilder.withDescription((String)"Query info of a Instance in a cluster");
        Option instanceInfoOption = OptionBuilder.create();
        instanceInfoOption.setArgs(2);
        instanceInfoOption.setRequired(false);
        instanceInfoOption.setArgName("clusterName InstanceName");
        OptionBuilder.withLongOpt((String)listClusterInfo);
        OptionBuilder.withDescription((String)"Query info of a cluster");
        Option clusterInfoOption = OptionBuilder.create();
        clusterInfoOption.setArgs(1);
        clusterInfoOption.setRequired(false);
        clusterInfoOption.setArgName("clusterName");
        OptionBuilder.withLongOpt((String)listResourceInfo);
        OptionBuilder.withDescription((String)"Query info of a resource");
        Option resourceInfoOption = OptionBuilder.create();
        resourceInfoOption.setArgs(2);
        resourceInfoOption.setRequired(false);
        resourceInfoOption.setArgName("clusterName resourceName");
        OptionBuilder.withLongOpt((String)addResourceProperty);
        OptionBuilder.withDescription((String)"Add a resource property");
        Option addResourcePropertyOption = OptionBuilder.create();
        addResourcePropertyOption.setArgs(4);
        addResourcePropertyOption.setRequired(false);
        addResourcePropertyOption.setArgName("clusterName resourceName propertyName propertyValue");
        OptionBuilder.withLongOpt((String)removeResourceProperty);
        OptionBuilder.withDescription((String)"Remove a resource property");
        Option removeResourcePropertyOption = OptionBuilder.create();
        removeResourcePropertyOption.setArgs(3);
        removeResourcePropertyOption.setRequired(false);
        removeResourcePropertyOption.setArgName("clusterName resourceName propertyName");
        OptionBuilder.withLongOpt((String)listPartitionInfo);
        OptionBuilder.withDescription((String)"Query info of a partition");
        Option partitionInfoOption = OptionBuilder.create();
        partitionInfoOption.setArgs(3);
        partitionInfoOption.setRequired(false);
        partitionInfoOption.setArgName("clusterName resourceName partitionName");
        OptionBuilder.withLongOpt((String)enableInstance);
        OptionBuilder.withDescription((String)"Enable/disable an instance");
        Option enableInstanceOption = OptionBuilder.create();
        enableInstanceOption.setArgs(3);
        enableInstanceOption.setRequired(false);
        enableInstanceOption.setArgName("clusterName instanceName true/false");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)enablePartition);
        OptionBuilder.withDescription((String)"Enable/disable partitions");
        Option enablePartitionOption = OptionBuilder.create();
        enablePartitionOption.setRequired(false);
        enablePartitionOption.setArgName("true/false clusterName instanceName resourceName partitionName1...");
        OptionBuilder.withLongOpt((String)enableCluster);
        OptionBuilder.withDescription((String)"pause/resume the controller of a cluster");
        Option enableClusterOption = OptionBuilder.create();
        enableClusterOption.setArgs(2);
        enableClusterOption.setRequired(false);
        enableClusterOption.setArgName("clusterName true/false");
        OptionBuilder.withLongOpt((String)resetPartition);
        OptionBuilder.withDescription((String)"Reset a partition in error state");
        Option resetPartitionOption = OptionBuilder.create();
        resetPartitionOption.setArgs(4);
        resetPartitionOption.setRequired(false);
        resetPartitionOption.setArgName("clusterName instanceName resourceName partitionName");
        OptionBuilder.withLongOpt((String)resetInstance);
        OptionBuilder.withDescription((String)"Reset all partitions in error state for an instance");
        Option resetInstanceOption = OptionBuilder.create();
        resetInstanceOption.setArgs(2);
        resetInstanceOption.setRequired(false);
        resetInstanceOption.setArgName("clusterName instanceName");
        OptionBuilder.withLongOpt((String)resetResource);
        OptionBuilder.withDescription((String)"Reset all partitions in error state for a resource");
        Option resetResourceOption = OptionBuilder.create();
        resetResourceOption.setArgs(2);
        resetResourceOption.setRequired(false);
        resetResourceOption.setArgName("clusterName resourceName");
        OptionBuilder.withLongOpt((String)listStateModels);
        OptionBuilder.withDescription((String)"Query info of state models in a cluster");
        Option listStateModelsOption = OptionBuilder.create();
        listStateModelsOption.setArgs(1);
        listStateModelsOption.setRequired(false);
        listStateModelsOption.setArgName("clusterName");
        OptionBuilder.withLongOpt((String)listStateModel);
        OptionBuilder.withDescription((String)"Query info of a state model in a cluster");
        Option listStateModelOption = OptionBuilder.create();
        listStateModelOption.setArgs(2);
        listStateModelOption.setRequired(false);
        listStateModelOption.setArgName("clusterName stateModelName");
        OptionBuilder.withLongOpt((String)addInstanceTag);
        OptionBuilder.withDescription((String)"Add a tag to instance");
        Option addInstanceTagOption = OptionBuilder.create();
        addInstanceTagOption.setArgs(3);
        addInstanceTagOption.setRequired(false);
        addInstanceTagOption.setArgName("clusterName instanceName tag");
        OptionBuilder.withLongOpt((String)removeInstanceTag);
        OptionBuilder.withDescription((String)"Remove tag from instance");
        Option removeInstanceTagOption = OptionBuilder.create();
        removeInstanceTagOption.setArgs(3);
        removeInstanceTagOption.setRequired(false);
        removeInstanceTagOption.setArgName("clusterName instanceName tag");
        OptionBuilder.hasArgs((int)3);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"ConfigScope(e.g. RESOURCE) ConfigScopeArgs(e.g. myCluster,testDB) KeyValueMap(e.g. k1=v1,k2=v2)");
        OptionBuilder.withLongOpt((String)setConfig);
        OptionBuilder.withDescription((String)"Set configs");
        Option setConfOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)3);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"ConfigScope(e.g. RESOURCE) ConfigScopeArgs(e.g. myCluster,testDB) Keys(e.g. k1,k2)");
        OptionBuilder.withLongOpt((String)getConfig);
        OptionBuilder.withDescription((String)"Get configs");
        Option getConfOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)3);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"ConfigScope(e.g. RESOURCE) ConfigScopeArgs(e.g. myCluster,testDB) Keys(e.g. k1,k2)");
        OptionBuilder.withLongOpt((String)removeConfig);
        OptionBuilder.withDescription((String)"Remove configs");
        Option removeConfOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)4);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName ConstraintType(e.g. MESSAGE_CONSTRAINT) ConstraintId KeyValueMap(e.g. k1=v1,k2=v2)");
        OptionBuilder.withLongOpt((String)setConstraint);
        OptionBuilder.withDescription((String)"Set a constraint associated with a give id. create if not exist");
        Option setConstraintOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName ConstraintType(e.g. MESSAGE_CONSTRAINT)");
        OptionBuilder.withLongOpt((String)getConstraints);
        OptionBuilder.withDescription((String)"Get constraints associated with given type");
        Option getConstraintsOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)3);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName ConstraintType(e.g. MESSAGE_CONSTRAINT) ConstraintId");
        OptionBuilder.withLongOpt((String)removeConstraint);
        OptionBuilder.withDescription((String)"Remove a constraint associated with given id");
        Option removeConstraintOption = OptionBuilder.create();
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        group.addOption(rebalanceOption);
        group.addOption(addResourceOption);
        group.addOption(resourceModeOption);
        group.addOption(resourceTagOption);
        group.addOption(resourceBucketSizeOption);
        group.addOption(maxPartitionsPerNodeOption);
        group.addOption(expandResourceOption);
        group.addOption(expandClusterOption);
        group.addOption(resourceKeyOption);
        group.addOption(addClusterOption);
        group.addOption(activateClusterOption);
        group.addOption(deleteClusterOption);
        group.addOption(addInstanceOption);
        group.addOption(listInstancesOption);
        group.addOption(listResourceOption);
        group.addOption(listClustersOption);
        group.addOption(addIdealStateOption);
        group.addOption(rebalanceOption);
        group.addOption(dropInstanceOption);
        group.addOption(swapInstanceOption);
        group.addOption(dropResourceOption);
        group.addOption(enableResourceOption);
        group.addOption(instanceInfoOption);
        group.addOption(clusterInfoOption);
        group.addOption(resourceInfoOption);
        group.addOption(partitionInfoOption);
        group.addOption(enableInstanceOption);
        group.addOption(enablePartitionOption);
        group.addOption(enableClusterOption);
        group.addOption(resetPartitionOption);
        group.addOption(resetInstanceOption);
        group.addOption(resetResourceOption);
        group.addOption(addStateModelDefOption);
        group.addOption(listStateModelsOption);
        group.addOption(listStateModelOption);
        group.addOption(addResourcePropertyOption);
        group.addOption(removeResourcePropertyOption);
        group.addOption(setConfOption);
        group.addOption(getConfOption);
        group.addOption(removeConfOption);
        group.addOption(setConstraintOption);
        group.addOption(getConstraintsOption);
        group.addOption(removeConstraintOption);
        group.addOption(addInstanceTagOption);
        group.addOption(removeInstanceTagOption);
        group.addOption(instanceGroupTagOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOptionGroup(group);
        return options;
    }

    private static byte[] readFile(String filePath) throws IOException {
        File file = new File(filePath);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        int numRead = 0;
        for (int read = 0; read < bytes.length && (numRead = dis.read(bytes, read, bytes.length - read)) >= 0; read += numRead) {
        }
        return bytes;
    }

    public static int processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = ClusterSetup.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            ClusterSetup.printUsage(cliOptions);
            System.exit(1);
        }
        ClusterSetup setupTool = new ClusterSetup(cmd.getOptionValue(zkServerAddress));
        if (cmd.hasOption(addCluster)) {
            String clusterName = cmd.getOptionValue(addCluster);
            setupTool.addCluster(clusterName, false);
            return 0;
        }
        if (cmd.hasOption(activateCluster)) {
            String clusterName = cmd.getOptionValues(activateCluster)[0];
            String grandCluster = cmd.getOptionValues(activateCluster)[1];
            boolean enable = Boolean.parseBoolean(cmd.getOptionValues(activateCluster)[2]);
            setupTool.activateCluster(clusterName, grandCluster, enable);
            return 0;
        }
        if (cmd.hasOption(dropCluster)) {
            String clusterName = cmd.getOptionValue(dropCluster);
            setupTool.deleteCluster(clusterName);
            return 0;
        }
        if (cmd.hasOption(addInstance)) {
            String clusterName = cmd.getOptionValues(addInstance)[0];
            String instanceAddressInfo = cmd.getOptionValues(addInstance)[1];
            String[] instanceAddresses = instanceAddressInfo.split(";");
            setupTool.addInstancesToCluster(clusterName, instanceAddresses);
            return 0;
        }
        if (cmd.hasOption(addResource)) {
            String clusterName = cmd.getOptionValues(addResource)[0];
            String resourceName = cmd.getOptionValues(addResource)[1];
            int partitions = Integer.parseInt(cmd.getOptionValues(addResource)[2]);
            String stateModelRef = cmd.getOptionValues(addResource)[3];
            String modeValue = IdealState.RebalanceMode.SEMI_AUTO.toString();
            if (cmd.hasOption(mode)) {
                modeValue = cmd.getOptionValues(mode)[0];
            }
            int bucketSizeVal = 0;
            if (cmd.hasOption(bucketSize)) {
                bucketSizeVal = Integer.parseInt(cmd.getOptionValues(bucketSize)[0]);
            }
            int maxPartitionsPerNodeVal = -1;
            if (cmd.hasOption(maxPartitionsPerNode)) {
                maxPartitionsPerNodeVal = Integer.parseInt(cmd.getOptionValues(maxPartitionsPerNode)[0]);
            }
            setupTool.addResourceToCluster(clusterName, resourceName, partitions, stateModelRef, modeValue, bucketSizeVal, maxPartitionsPerNodeVal);
            return 0;
        }
        if (cmd.hasOption(rebalance)) {
            String clusterName = cmd.getOptionValues(rebalance)[0];
            String resourceName = cmd.getOptionValues(rebalance)[1];
            int replicas = Integer.parseInt(cmd.getOptionValues(rebalance)[2]);
            String keyPrefixVal = "";
            String instanceGroupTagVal = "";
            if (cmd.hasOption(resourceKeyPrefix)) {
                keyPrefixVal = cmd.getOptionValue(resourceKeyPrefix);
            }
            if (cmd.hasOption(instanceGroupTag)) {
                instanceGroupTagVal = cmd.getOptionValue(instanceGroupTag);
            }
            setupTool.rebalanceCluster(clusterName, resourceName, replicas, keyPrefixVal, instanceGroupTagVal);
            return 0;
        }
        if (cmd.hasOption(expandCluster)) {
            String clusterName = cmd.getOptionValues(expandCluster)[0];
            setupTool.expandCluster(clusterName);
            return 0;
        }
        if (cmd.hasOption(expandResource)) {
            String clusterName = cmd.getOptionValues(expandResource)[0];
            String resourceName = cmd.getOptionValues(expandResource)[1];
            setupTool.expandResource(clusterName, resourceName);
            return 0;
        }
        if (cmd.hasOption(dropInstance)) {
            String clusterName = cmd.getOptionValues(dropInstance)[0];
            String instanceAddressInfo = cmd.getOptionValues(dropInstance)[1];
            String[] instanceAddresses = instanceAddressInfo.split(";");
            setupTool.dropInstancesFromCluster(clusterName, instanceAddresses);
            return 0;
        }
        if (cmd.hasOption(listClusters)) {
            List<String> clusters = setupTool.getClusterManagementTool().getClusters();
            System.out.println("Existing clusters:");
            for (String cluster : clusters) {
                System.out.println(cluster);
            }
            return 0;
        }
        if (cmd.hasOption(listResources)) {
            String clusterName = cmd.getOptionValue(listResources);
            List<String> resourceNames = null;
            if (cmd.hasOption(tag)) {
                String tagValue = cmd.getOptionValues(tag)[0];
                resourceNames = setupTool.getClusterManagementTool().getResourcesInClusterWithTag(clusterName, tagValue);
                System.out.println("Existing resources in cluster " + clusterName + " with tag " + (String)tagValue + " :");
            } else {
                resourceNames = setupTool.getClusterManagementTool().getResourcesInCluster(clusterName);
                System.out.println("Existing resources in cluster " + clusterName + ":");
            }
            for (String resourceName : resourceNames) {
                System.out.println(resourceName);
            }
            return 0;
        }
        if (cmd.hasOption(listClusterInfo)) {
            String clusterName = cmd.getOptionValue(listClusterInfo);
            List<String> resourceNames = setupTool.getClusterManagementTool().getResourcesInCluster(clusterName);
            List<String> instances = setupTool.getClusterManagementTool().getInstancesInCluster(clusterName);
            System.out.println("Existing resources in cluster " + clusterName + ":");
            for (String resourceName : resourceNames) {
                System.out.println(resourceName);
            }
            System.out.println("Instances in cluster " + clusterName + ":");
            for (String InstanceName : instances) {
                System.out.println(InstanceName);
            }
            return 0;
        }
        if (cmd.hasOption(listInstances)) {
            List<String> instances;
            String clusterName = cmd.getOptionValue(listInstances);
            if (cmd.hasOption(tag)) {
                String instanceTag = cmd.getOptionValues(tag)[0];
                instances = setupTool.getClusterManagementTool().getInstancesInClusterWithTag(clusterName, instanceTag);
            } else {
                instances = setupTool.getClusterManagementTool().getInstancesInCluster(clusterName);
            }
            System.out.println("Instances in cluster " + clusterName + ":");
            for (String instanceName : instances) {
                System.out.println(instanceName);
            }
            return 0;
        }
        if (cmd.hasOption(listInstanceInfo)) {
            String clusterName = cmd.getOptionValues(listInstanceInfo)[0];
            String instanceName = cmd.getOptionValues(listInstanceInfo)[1];
            InstanceConfig config = setupTool.getClusterManagementTool().getInstanceConfig(clusterName, instanceName);
            String result = new String(config.serialize(new ZNRecordSerializer()));
            System.out.println("InstanceConfig: " + result);
            return 0;
        }
        if (cmd.hasOption(listResourceInfo)) {
            String clusterName = cmd.getOptionValues(listResourceInfo)[0];
            String resourceName = cmd.getOptionValues(listResourceInfo)[1];
            IdealState idealState = setupTool.getClusterManagementTool().getResourceIdealState(clusterName, resourceName);
            ExternalView externalView = setupTool.getClusterManagementTool().getResourceExternalView(clusterName, resourceName);
            if (idealState != null) {
                System.out.println("IdealState for " + resourceName + ":");
                System.out.println(new String(idealState.serialize(new ZNRecordSerializer())));
            } else {
                System.out.println("No idealState for " + resourceName);
            }
            System.out.println();
            if (externalView != null) {
                System.out.println("ExternalView for " + resourceName + ":");
                System.out.println(new String(externalView.serialize(new ZNRecordSerializer())));
            } else {
                System.out.println("No externalView for " + resourceName);
            }
            return 0;
        }
        if (cmd.hasOption(listPartitionInfo)) {
            ZNRecord partInfo;
            String clusterName = cmd.getOptionValues(listPartitionInfo)[0];
            String resourceName = cmd.getOptionValues(listPartitionInfo)[1];
            String partitionName = cmd.getOptionValues(listPartitionInfo)[2];
            IdealState idealState = setupTool.getClusterManagementTool().getResourceIdealState(clusterName, resourceName);
            ExternalView externalView = setupTool.getClusterManagementTool().getResourceExternalView(clusterName, resourceName);
            if (idealState != null) {
                partInfo = new ZNRecord(resourceName + "/" + partitionName);
                ZNRecord idealStateRec = idealState.getRecord();
                partInfo.setSimpleFields(idealStateRec.getSimpleFields());
                if (idealStateRec.getMapField(partitionName) != null) {
                    partInfo.setMapField(partitionName, idealStateRec.getMapField(partitionName));
                }
                if (idealStateRec.getListField(partitionName) != null) {
                    partInfo.setListField(partitionName, idealStateRec.getListField(partitionName));
                }
                System.out.println("IdealState for " + resourceName + "/" + partitionName + ":");
                System.out.println(new String(new ZNRecordSerializer().serialize(partInfo)));
            } else {
                System.out.println("No idealState for " + resourceName + "/" + partitionName);
            }
            System.out.println();
            if (externalView != null) {
                partInfo = new ZNRecord(resourceName + "/" + partitionName);
                ZNRecord extViewRec = externalView.getRecord();
                partInfo.setSimpleFields(extViewRec.getSimpleFields());
                if (extViewRec.getMapField(partitionName) != null) {
                    partInfo.setMapField(partitionName, extViewRec.getMapField(partitionName));
                }
                if (extViewRec.getListField(partitionName) != null) {
                    partInfo.setListField(partitionName, extViewRec.getListField(partitionName));
                }
                System.out.println("ExternalView for " + resourceName + "/" + partitionName + ":");
                System.out.println(new String(new ZNRecordSerializer().serialize(partInfo)));
            } else {
                System.out.println("No externalView for " + resourceName + "/" + partitionName);
            }
            return 0;
        }
        if (cmd.hasOption(enableInstance)) {
            String clusterName = cmd.getOptionValues(enableInstance)[0];
            String instanceName = cmd.getOptionValues(enableInstance)[1];
            if (instanceName.contains(":")) {
                instanceName = instanceName.replaceAll(":", "_");
            }
            boolean enabled = Boolean.parseBoolean(cmd.getOptionValues(enableInstance)[2].toLowerCase());
            setupTool.getClusterManagementTool().enableInstance(clusterName, instanceName, enabled);
            return 0;
        }
        if (cmd.hasOption(enableResource)) {
            String clusterName = cmd.getOptionValues(enableResource)[0];
            String resourceName = cmd.getOptionValues(enableResource)[1];
            boolean enabled = Boolean.parseBoolean(cmd.getOptionValues(enableResource)[2].toLowerCase());
            if (cmd.hasOption(tag)) {
                String resourceTag = cmd.getOptionValues(tag)[0];
                setupTool.enableResource(clusterName, resourceName, resourceTag, enabled);
            } else {
                setupTool.getClusterManagementTool().enableResource(clusterName, resourceName, enabled);
            }
        } else {
            if (cmd.hasOption(enablePartition)) {
                String[] args = cmd.getOptionValues(enablePartition);
                boolean enabled = Boolean.parseBoolean(args[0].toLowerCase());
                String clusterName = args[1];
                String instanceName = args[2];
                String resourceName = args[3];
                List<String> partitionNames = Arrays.asList(Arrays.copyOfRange(args, 4, args.length));
                setupTool.getClusterManagementTool().enablePartition(enabled, clusterName, instanceName, resourceName, partitionNames);
                return 0;
            }
            if (cmd.hasOption(resetPartition)) {
                String[] args = cmd.getOptionValues(resetPartition);
                String clusterName = args[0];
                String instanceName = args[1];
                String resourceName = args[2];
                List<String> partitionNames = Arrays.asList(Arrays.copyOfRange(args, 3, args.length));
                setupTool.getClusterManagementTool().resetPartition(clusterName, instanceName, resourceName, partitionNames);
                return 0;
            }
            if (cmd.hasOption(resetInstance)) {
                String[] args = cmd.getOptionValues(resetInstance);
                String clusterName = args[0];
                List<String> instanceNames = Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
                setupTool.getClusterManagementTool().resetInstance(clusterName, instanceNames);
                return 0;
            }
            if (cmd.hasOption(resetResource)) {
                String[] args = cmd.getOptionValues(resetResource);
                String clusterName = args[0];
                List<String> resourceNames = Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
                setupTool.getClusterManagementTool().resetResource(clusterName, resourceNames);
                return 0;
            }
            if (cmd.hasOption(enableCluster)) {
                String[] params = cmd.getOptionValues(enableCluster);
                String clusterName = params[0];
                boolean enabled = Boolean.parseBoolean(params[1].toLowerCase());
                setupTool.getClusterManagementTool().enableCluster(clusterName, enabled);
                return 0;
            }
            if (cmd.hasOption(listStateModels)) {
                String clusterName = cmd.getOptionValues(listStateModels)[0];
                List<String> stateModels = setupTool.getClusterManagementTool().getStateModelDefs(clusterName);
                System.out.println("Existing state models:");
                for (String stateModel : stateModels) {
                    System.out.println(stateModel);
                }
                return 0;
            }
            if (cmd.hasOption(listStateModel)) {
                String clusterName = cmd.getOptionValues(listStateModel)[0];
                String stateModel = cmd.getOptionValues(listStateModel)[1];
                StateModelDefinition stateModelDef = setupTool.getClusterManagementTool().getStateModelDef(clusterName, stateModel);
                String result = new String(new ZNRecordSerializer().serialize(stateModelDef.getRecord()));
                System.out.println("StateModelDefinition: " + result);
                return 0;
            }
            if (cmd.hasOption(addStateModelDef)) {
                String clusterName = cmd.getOptionValues(addStateModelDef)[0];
                String stateModelFile = cmd.getOptionValues(addStateModelDef)[1];
                ZNRecord stateModelRecord = (ZNRecord)new ZNRecordSerializer().deserialize(ClusterSetup.readFile(stateModelFile));
                if (stateModelRecord.getId() == null || stateModelRecord.getId().length() == 0) {
                    throw new IllegalArgumentException("ZNRecord for state model definition must have an id");
                }
                setupTool.getClusterManagementTool().addStateModelDef(clusterName, stateModelRecord.getId(), new StateModelDefinition(stateModelRecord));
                return 0;
            }
            if (cmd.hasOption(addIdealState)) {
                String clusterName = cmd.getOptionValues(addIdealState)[0];
                String resourceName = cmd.getOptionValues(addIdealState)[1];
                String idealStateFile = cmd.getOptionValues(addIdealState)[2];
                setupTool.addIdealState(clusterName, resourceName, idealStateFile);
                return 0;
            }
            if (cmd.hasOption(dropResource)) {
                String clusterName = cmd.getOptionValues(dropResource)[0];
                String resourceName = cmd.getOptionValues(dropResource)[1];
                setupTool.getClusterManagementTool().dropResource(clusterName, resourceName);
            } else if (cmd.hasOption(swapInstance)) {
                String clusterName = cmd.getOptionValues(swapInstance)[0];
                String oldInstanceName = cmd.getOptionValues(swapInstance)[1];
                String newInstanceName = cmd.getOptionValues(swapInstance)[2];
                setupTool.swapInstance(clusterName, oldInstanceName, newInstanceName);
            } else if (cmd.hasOption(setConfig)) {
                String[] values = cmd.getOptionValues(setConfig);
                HelixConfigScope.ConfigScopeProperty type = HelixConfigScope.ConfigScopeProperty.valueOf(values[0]);
                String scopeArgs = values[1];
                String keyValueMap = values[2];
                setupTool.setConfig(type, scopeArgs, keyValueMap);
            } else if (cmd.hasOption(getConfig)) {
                String[] values = cmd.getOptionValues(getConfig);
                HelixConfigScope.ConfigScopeProperty type = HelixConfigScope.ConfigScopeProperty.valueOf(values[0]);
                String scopeArgs = values[1];
                String keys = values[2];
                setupTool.getConfig(type, scopeArgs, keys);
            } else if (cmd.hasOption(removeConfig)) {
                String[] values = cmd.getOptionValues(removeConfig);
                HelixConfigScope.ConfigScopeProperty type = HelixConfigScope.ConfigScopeProperty.valueOf(values[0]);
                String scoepArgs = values[1];
                String keys = values[2];
                setupTool.removeConfig(type, scoepArgs, keys);
            } else if (cmd.hasOption(setConstraint)) {
                String[] values = cmd.getOptionValues(setConstraint);
                String clusterName = values[0];
                String constraintType = values[1];
                String constraintId = values[2];
                String constraintAttributesMap = values[3];
                setupTool.setConstraint(clusterName, constraintType, constraintId, constraintAttributesMap);
            } else if (cmd.hasOption(getConstraints)) {
                String[] values = cmd.getOptionValues(getConstraints);
                String clusterName = values[0];
                String constraintType = values[1];
                setupTool.getConstraints(clusterName, constraintType);
            } else if (cmd.hasOption(removeConstraint)) {
                String[] values = cmd.getOptionValues(removeConstraint);
                String clusterName = values[0];
                String constraintType = values[1];
                String constraintId = values[2];
                setupTool.removeConstraint(clusterName, constraintType, constraintId);
            } else if (cmd.hasOption(addInstanceTag)) {
                String clusterName = cmd.getOptionValues(addInstanceTag)[0];
                String instanceName = cmd.getOptionValues(addInstanceTag)[1];
                String tag = cmd.getOptionValues(addInstanceTag)[2];
                setupTool.getClusterManagementTool().addInstanceTag(clusterName, instanceName, tag);
            } else if (cmd.hasOption(removeInstanceTag)) {
                String clusterName = cmd.getOptionValues(removeInstanceTag)[0];
                String instanceName = cmd.getOptionValues(removeInstanceTag)[1];
                String tag = cmd.getOptionValues(removeInstanceTag)[2];
                setupTool.getClusterManagementTool().removeInstanceTag(clusterName, instanceName, tag);
            } else {
                if (cmd.hasOption(help)) {
                    ClusterSetup.printUsage(cliOptions);
                    return 0;
                }
                if (cmd.hasOption(addResourceProperty)) {
                    String clusterName = cmd.getOptionValues(addResourceProperty)[0];
                    String resourceName = cmd.getOptionValues(addResourceProperty)[1];
                    String propertyKey = cmd.getOptionValues(addResourceProperty)[2];
                    String propertyVal = cmd.getOptionValues(addResourceProperty)[3];
                    setupTool.addResourceProperty(clusterName, resourceName, propertyKey, propertyVal);
                    return 0;
                }
                if (cmd.hasOption(removeResourceProperty)) {
                    String clusterName = cmd.getOptionValues(removeResourceProperty)[0];
                    String resourceName = cmd.getOptionValues(removeResourceProperty)[1];
                    String propertyKey = cmd.getOptionValues(removeResourceProperty)[2];
                    setupTool.removeResourceProperty(clusterName, resourceName, propertyKey);
                    return 0;
                }
            }
        }
        return 0;
    }

    public void addIdealState(String clusterName, String resourceName, String idealStateFile) throws IOException {
        ZNRecord idealStateRecord = (ZNRecord)new ZNRecordSerializer().deserialize(ClusterSetup.readFile(idealStateFile));
        if (idealStateRecord.getId() == null || !idealStateRecord.getId().equals(resourceName)) {
            throw new IllegalArgumentException("ideal state must have same id as resource name");
        }
        this._admin.setResourceIdealState(clusterName, resourceName, new IdealState(idealStateRecord));
    }

    public void addResourceProperty(String clusterName, String resourceName, String propertyKey, String propertyVal) {
        IdealState idealState = this._admin.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Resource: " + resourceName + " has NOT been added yet");
        }
        idealState.getRecord().setSimpleField(propertyKey, propertyVal);
        this._admin.setResourceIdealState(clusterName, resourceName, idealState);
    }

    public void removeResourceProperty(String clusterName, String resourceName, String propertyKey) {
        IdealState idealState = this._admin.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Resource: " + resourceName + " has NOT been added yet");
        }
        idealState.getRecord().getSimpleFields().remove(propertyKey);
        this._admin.setResourceIdealState(clusterName, resourceName, idealState);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && args[0].equals("setup-test-cluster")) {
            System.out.println("By default setting up TestCluster with 6 instances, 10 partitions, Each partition will have 3 replicas");
            new ClusterSetup("localhost:2181").setupTestCluster("TestCluster");
            System.exit(0);
        }
        int ret = ClusterSetup.processCommandLineArgs(args);
        System.exit(ret);
    }

    public static class Builder
    extends GenericZkHelixApiBuilder<Builder> {
        public ClusterSetup build() {
            this.validate();
            return new ClusterSetup(this.createZkClient(this._realmMode, this._realmAwareZkConnectionConfig, this._realmAwareZkClientConfig, this._zkAddress), false);
        }
    }
}

