/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.task.TaskState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowContext
extends HelixProperty {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowContext.class);
    public static final int NOT_STARTED = -1;
    public static final int UNFINISHED = -1;

    public WorkflowContext(ZNRecord record) {
        super(record);
    }

    public void setWorkflowState(TaskState s) {
        String workflowState = this._record.getSimpleField(WorkflowContextProperties.STATE.name());
        if (workflowState == null) {
            this._record.setSimpleField(WorkflowContextProperties.STATE.name(), s.name());
        } else if (!workflowState.equals(TaskState.FAILED.name()) && !workflowState.equals(TaskState.COMPLETED.name())) {
            this._record.setSimpleField(WorkflowContextProperties.STATE.name(), s.name());
        }
    }

    public TaskState getWorkflowState() {
        String state = this._record.getSimpleField(WorkflowContextProperties.STATE.name());
        if (state == null) {
            return TaskState.NOT_STARTED;
        }
        return TaskState.valueOf(state);
    }

    public void setJobState(String job, TaskState s) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states == null) {
            states = new TreeMap<String, String>();
            this._record.setMapField(WorkflowContextProperties.JOB_STATES.name(), states);
        }
        states.put(job, s.name());
    }

    protected void removeJobStates(Set<String> jobs) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states != null) {
            states.keySet().removeAll(jobs);
            this._record.setMapField(WorkflowContextProperties.JOB_STATES.name(), states);
        }
    }

    public TaskState getJobState(String job) {
        Map<String, String> states = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (states == null) {
            return null;
        }
        String s = states.get(job);
        if (s == null) {
            return null;
        }
        return TaskState.valueOf(s);
    }

    protected void setJobStartTime(String job, long time) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes == null) {
            startTimes = new HashMap<String, String>();
            this._record.setMapField(WorkflowContextProperties.StartTime.name(), startTimes);
        }
        startTimes.put(job, String.valueOf(time));
    }

    protected void removeJobStartTime(Set<String> jobs) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes != null) {
            startTimes.keySet().removeAll(jobs);
            this._record.setMapField(WorkflowContextProperties.StartTime.name(), startTimes);
        }
    }

    public long getJobStartTime(String job) {
        Map<String, String> startTimes = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimes == null || !startTimes.containsKey(job)) {
            return -1L;
        }
        String t = startTimes.get(job);
        if (t == null) {
            return -1L;
        }
        try {
            long ret = Long.valueOf(t);
            return ret;
        }
        catch (NumberFormatException e) {
            LOG.warn("Number error " + t + " for job start time of " + job);
            return -1L;
        }
    }

    public Map<String, Long> getJobStartTimes() {
        HashMap<String, Long> startTimes = new HashMap<String, Long>();
        Map<String, String> startTimesMap = this._record.getMapField(WorkflowContextProperties.StartTime.name());
        if (startTimesMap != null) {
            for (Map.Entry<String, String> time : startTimesMap.entrySet()) {
                startTimes.put(time.getKey(), Long.valueOf(time.getValue()));
            }
        }
        return startTimes;
    }

    public Map<String, TaskState> getJobStates() {
        HashMap<String, TaskState> jobStates = new HashMap<String, TaskState>();
        Map<String, String> stateFieldMap = this._record.getMapField(WorkflowContextProperties.JOB_STATES.name());
        if (stateFieldMap != null) {
            for (Map.Entry<String, String> state : stateFieldMap.entrySet()) {
                jobStates.put(state.getKey(), TaskState.valueOf(state.getValue()));
            }
        }
        return jobStates;
    }

    public void setStartTime(long t) {
        this._record.setSimpleField(WorkflowContextProperties.START_TIME.name(), String.valueOf(t));
    }

    public long getStartTime() {
        String tStr = this._record.getSimpleField(WorkflowContextProperties.START_TIME.name());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setFinishTime(long t) {
        this._record.setSimpleField(WorkflowContextProperties.FINISH_TIME.name(), String.valueOf(t));
    }

    public long getFinishTime() {
        String tStr = this._record.getSimpleField(WorkflowContextProperties.FINISH_TIME.name());
        if (tStr == null) {
            return -1L;
        }
        return Long.parseLong(tStr);
    }

    public void setLastScheduledSingleWorkflow(String workflow) {
        this._record.setSimpleField(WorkflowContextProperties.LAST_SCHEDULED_WORKFLOW.name(), workflow);
        List<String> workflows = this.getScheduledWorkflows();
        if (workflows == null) {
            workflows = new ArrayList<String>();
            this._record.setListField(WorkflowContextProperties.SCHEDULED_WORKFLOWS.name(), workflows);
        }
        workflows.add(workflow);
    }

    public String getLastScheduledSingleWorkflow() {
        return this._record.getSimpleField(WorkflowContextProperties.LAST_SCHEDULED_WORKFLOW.name());
    }

    protected void setLastJobPurgeTime(long epochTime) {
        this._record.setSimpleField(WorkflowContextProperties.LAST_PURGE_TIME.name(), String.valueOf(epochTime));
    }

    public long getLastJobPurgeTime() {
        return this._record.getLongField(WorkflowContextProperties.LAST_PURGE_TIME.name(), -1L);
    }

    public List<String> getScheduledWorkflows() {
        return this._record.getListField(WorkflowContextProperties.SCHEDULED_WORKFLOWS.name());
    }

    public void setName(String name) {
        this._record.setSimpleField(WorkflowContextProperties.NAME.name(), name);
    }

    public String getName() {
        return this._record.getSimpleField(WorkflowContextProperties.NAME.name());
    }

    protected static enum WorkflowContextProperties {
        STATE,
        START_TIME,
        FINISH_TIME,
        JOB_STATES,
        LAST_SCHEDULED_WORKFLOW,
        SCHEDULED_WORKFLOWS,
        LAST_PURGE_TIME,
        StartTime,
        NAME;

    }
}

