/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.api.config.HelixConfigProperty;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.api.config.StateTransitionTimeoutConfig;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class ClusterConfig
extends HelixProperty {
    private static final int DEFAULT_MAX_CONCURRENT_TASK_PER_INSTANCE = 40;
    @Deprecated
    private static final int DEFAULT_ERROR_PARTITION_THRESHOLD_FOR_LOAD_BALANCE = 0;
    private static final int DEFAULT_ERROR_OR_RECOVERY_PARTITION_THRESHOLD_FOR_LOAD_BALANCE = -1;
    private static final String IDEAL_STATE_RULE_PREFIX = "IdealStateRule!";
    public static final String TASK_QUOTA_RATIO_NOT_SET = "-1";
    public static final Map<GlobalRebalancePreferenceKey, Integer> DEFAULT_GLOBAL_REBALANCE_PREFERENCE = ImmutableMap.builder().put((Object)GlobalRebalancePreferenceKey.EVENNESS, (Object)1).put((Object)GlobalRebalancePreferenceKey.LESS_MOVEMENT, (Object)1).build();
    private static final int MAX_REBALANCE_PREFERENCE = 10;
    private static final int MIN_REBALANCE_PREFERENCE = 0;
    public static final boolean DEFAULT_GLOBAL_REBALANCE_ASYNC_MODE_ENABLED = true;

    public ClusterConfig(String cluster) {
        super(cluster);
    }

    public ClusterConfig(ZNRecord record) {
        super(record);
    }

    public void setTaskQuotaRatio(String quotaType, int quotaRatio) {
        if (this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()) == null) {
            this._record.setMapField(ClusterConfigProperty.QUOTA_TYPES.name(), new HashMap<String, String>());
        }
        this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).put(quotaType, Integer.toString(quotaRatio));
    }

    public void setTaskQuotaRatio(String quotaType, String quotaRatio) {
        if (this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()) == null) {
            this._record.setMapField(ClusterConfigProperty.QUOTA_TYPES.name(), new HashMap<String, String>());
        }
        this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).put(quotaType, quotaRatio);
    }

    public void removeTaskQuotaRatio(String quotaType) {
        if (this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()) != null) {
            this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).remove(quotaType);
        }
    }

    public String getTaskQuotaRatio(String quotaType) {
        if (this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()) == null || this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).get(quotaType) == null) {
            return TASK_QUOTA_RATIO_NOT_SET;
        }
        return this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).get(quotaType);
    }

    public Map<String, String> getTaskQuotaRatioMap() {
        return this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name());
    }

    public void resetTaskQuotaRatioMap() {
        if (this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()) != null) {
            this._record.getMapField(ClusterConfigProperty.QUOTA_TYPES.name()).clear();
        }
    }

    public Boolean isPersistBestPossibleAssignment() {
        return this._record.getBooleanField(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString(), false);
    }

    public void setPersistBestPossibleAssignment(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString(), enable);
        }
    }

    public Boolean isPersistIntermediateAssignment() {
        return this._record.getBooleanField(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString(), false);
    }

    public void setPersistIntermediateAssignment(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString(), enable);
        }
    }

    public Boolean isPipelineTriggersDisabled() {
        return this._record.getBooleanField(ClusterConfigProperty.HELIX_DISABLE_PIPELINE_TRIGGERS.toString(), false);
    }

    public void setTopologyAwareEnabled(boolean enabled) {
        this._record.setBooleanField(ClusterConfigProperty.TOPOLOGY_AWARE_ENABLED.name(), enabled);
    }

    public boolean isTopologyAwareEnabled() {
        return this._record.getBooleanField(ClusterConfigProperty.TOPOLOGY_AWARE_ENABLED.name(), false);
    }

    public void setTopology(String topology) {
        this._record.setSimpleField(ClusterConfigProperty.TOPOLOGY.name(), topology);
    }

    public String getTopology() {
        return this._record.getSimpleField(ClusterConfigProperty.TOPOLOGY.name());
    }

    public void setFaultZoneType(String faultZoneType) {
        this._record.setSimpleField(ClusterConfigProperty.FAULT_ZONE_TYPE.name(), faultZoneType);
    }

    public String getFaultZoneType() {
        return this._record.getSimpleField(ClusterConfigProperty.FAULT_ZONE_TYPE.name());
    }

    public void setRebalanceDelayTime(long milliseconds) {
        this._record.setLongField(ClusterConfigProperty.DELAY_REBALANCE_TIME.name(), milliseconds);
    }

    public long getRebalanceDelayTime() {
        return this._record.getLongField(ClusterConfigProperty.DELAY_REBALANCE_TIME.name(), -1L);
    }

    public void setDelayRebalaceEnabled(boolean enabled) {
        this._record.setBooleanField(ClusterConfigProperty.DELAY_REBALANCE_ENABLED.name(), enabled);
    }

    public boolean isDelayRebalaceEnabled() {
        boolean disabled = this._record.getBooleanField(ClusterConfigProperty.DELAY_REBALANCE_DISABLED.name(), false);
        boolean enabled = this._record.getBooleanField(ClusterConfigProperty.DELAY_REBALANCE_ENABLED.name(), true);
        if (disabled) {
            return false;
        }
        return enabled;
    }

    public void stateTransitionCancelEnabled(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name(), enable);
        }
    }

    public void setMaxPartitionsPerInstance(int maxPartitionsPerInstance) {
        this._record.setIntField(ClusterConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), maxPartitionsPerInstance);
    }

    public int getMaxPartitionsPerInstance() {
        return this._record.getIntField(ClusterConfigProperty.MAX_PARTITIONS_PER_INSTANCE.name(), -1);
    }

    public void setMaxOfflineInstancesAllowed(int maxOfflineInstancesAllowed) {
        this._record.setIntField(ClusterConfigProperty.MAX_OFFLINE_INSTANCES_ALLOWED.name(), maxOfflineInstancesAllowed);
    }

    public int getMaxOfflineInstancesAllowed() {
        return this._record.getIntField(ClusterConfigProperty.MAX_OFFLINE_INSTANCES_ALLOWED.name(), -1);
    }

    public void setNumOfflineInstancesForAutoExit(int maintenanceRecoveryThreshold) throws HelixException {
        int maxOfflineInstancesAllowed = this.getMaxOfflineInstancesAllowed();
        if (maxOfflineInstancesAllowed >= 0 && maintenanceRecoveryThreshold > maxOfflineInstancesAllowed) {
            throw new HelixException("Maintenance recovery threshold must be less than equal to maximum offline instances allowed!");
        }
        this._record.setIntField(ClusterConfigProperty.NUM_OFFLINE_INSTANCES_FOR_AUTO_EXIT.name(), maintenanceRecoveryThreshold);
    }

    public int getNumOfflineInstancesForAutoExit() {
        return this._record.getIntField(ClusterConfigProperty.NUM_OFFLINE_INSTANCES_FOR_AUTO_EXIT.name(), -1);
    }

    public void setResourcePriorityField(String priorityField) {
        this._record.setSimpleField(ClusterConfigProperty.RESOURCE_PRIORITY_FIELD.name(), priorityField);
    }

    public String getResourcePriorityField() {
        return this._record.getSimpleField(ClusterConfigProperty.RESOURCE_PRIORITY_FIELD.name());
    }

    public void setRebalanceTimePeriod(long milliseconds) {
        this._record.setLongField(ClusterConfigProperty.REBALANCE_TIMER_PERIOD.name(), milliseconds);
    }

    public long getRebalanceTimePeriod() {
        return this._record.getLongField(ClusterConfigProperty.REBALANCE_TIMER_PERIOD.name(), -1L);
    }

    public boolean isStateTransitionCancelEnabled() {
        return this._record.getBooleanField(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name(), false);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClusterConfig) {
            ClusterConfig that = (ClusterConfig)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public List<StateTransitionThrottleConfig> getStateTransitionThrottleConfigs() {
        List<String> configs = this._record.getListField(ClusterConfigProperty.STATE_TRANSITION_THROTTLE_CONFIGS.name());
        if (configs == null || configs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StateTransitionThrottleConfig> throttleConfigs = new ArrayList<StateTransitionThrottleConfig>();
        for (String configstr : configs) {
            StateTransitionThrottleConfig throttleConfig = StateTransitionThrottleConfig.fromJSON(configstr);
            if (throttleConfig == null) continue;
            throttleConfigs.add(throttleConfig);
        }
        return throttleConfigs;
    }

    public void setStateTransitionThrottleConfigs(List<StateTransitionThrottleConfig> throttleConfigs) {
        ArrayList<String> configStrs = new ArrayList<String>();
        for (StateTransitionThrottleConfig throttleConfig : throttleConfigs) {
            String configStr = throttleConfig.toJSON();
            if (configStr == null) continue;
            configStrs.add(configStr);
        }
        if (!configStrs.isEmpty()) {
            this._record.setListField(ClusterConfigProperty.STATE_TRANSITION_THROTTLE_CONFIGS.name(), configStrs);
        }
    }

    public void setMissTopStateDurationThreshold(long durationThreshold) {
        this._record.setLongField(ClusterConfigProperty.MISS_TOP_STATE_DURATION_THRESHOLD.name(), durationThreshold);
    }

    public long getMissTopStateDurationThreshold() {
        return this._record.getLongField(ClusterConfigProperty.MISS_TOP_STATE_DURATION_THRESHOLD.name(), Long.MAX_VALUE);
    }

    public void setStateTransitionTimeoutConfig(StateTransitionTimeoutConfig stateTransitionTimeoutConfig) {
        this._record.setMapField(StateTransitionTimeoutConfig.StateTransitionTimeoutProperty.TIMEOUT.name(), stateTransitionTimeoutConfig.getTimeoutMap());
    }

    public StateTransitionTimeoutConfig getStateTransitionTimeoutConfig() {
        return StateTransitionTimeoutConfig.fromRecord(this._record);
    }

    public void enableTargetExternalView(boolean enabled) {
        this._record.setBooleanField(ClusterConfigProperty.TARGET_EXTERNALVIEW_ENABLED.name(), enabled);
    }

    public boolean isTargetExternalViewEnabled() {
        return this._record.getBooleanField(ClusterConfigProperty.TARGET_EXTERNALVIEW_ENABLED.name(), false);
    }

    public int getMaxConcurrentTaskPerInstance() {
        return this._record.getIntField(ClusterConfigProperty.MAX_CONCURRENT_TASK_PER_INSTANCE.name(), 40);
    }

    public void setMaxConcurrentTaskPerInstance(int maxConcurrentTaskPerInstance) {
        this._record.setIntField(ClusterConfigProperty.MAX_CONCURRENT_TASK_PER_INSTANCE.name(), maxConcurrentTaskPerInstance);
    }

    public int getErrorPartitionThresholdForLoadBalance() {
        return this._record.getIntField(ClusterConfigProperty.ERROR_PARTITION_THRESHOLD_FOR_LOAD_BALANCE.name(), 0);
    }

    public void setErrorPartitionThresholdForLoadBalance(int errorPartitionThreshold) {
        this._record.setIntField(ClusterConfigProperty.ERROR_PARTITION_THRESHOLD_FOR_LOAD_BALANCE.name(), errorPartitionThreshold);
    }

    public int getErrorOrRecoveryPartitionThresholdForLoadBalance() {
        return this._record.getIntField(ClusterConfigProperty.ERROR_OR_RECOVERY_PARTITION_THRESHOLD_FOR_LOAD_BALANCE.name(), -1);
    }

    public void setErrorOrRecoveryPartitionThresholdForLoadBalance(int recoveryPartitionThreshold) {
        this._record.setIntField(ClusterConfigProperty.ERROR_OR_RECOVERY_PARTITION_THRESHOLD_FOR_LOAD_BALANCE.name(), recoveryPartitionThreshold);
    }

    public void setDisabledInstances(Map<String, String> disabledInstances) {
        this._record.setMapField(ClusterConfigProperty.DISABLED_INSTANCES.name(), disabledInstances);
    }

    public Map<String, String> getDisabledInstances() {
        return this._record.getMapField(ClusterConfigProperty.DISABLED_INSTANCES.name());
    }

    public boolean isP2PMessageEnabled() {
        return this._record.getBooleanField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name(), false);
    }

    public void enableP2PMessage(boolean enabled) {
        this._record.setBooleanField(HelixConfigProperty.P2P_MESSAGE_ENABLED.name(), enabled);
    }

    public void setInstanceCapacityKeys(List<String> capacityKeys) {
        if (capacityKeys == null || capacityKeys.isEmpty()) {
            throw new IllegalArgumentException("The input instance capacity key list is empty.");
        }
        this._record.setListField(ClusterConfigProperty.INSTANCE_CAPACITY_KEYS.name(), capacityKeys);
    }

    public List<String> getInstanceCapacityKeys() {
        List<String> capacityKeys = this._record.getListField(ClusterConfigProperty.INSTANCE_CAPACITY_KEYS.name());
        if (capacityKeys == null) {
            return Collections.emptyList();
        }
        return capacityKeys;
    }

    public Map<String, Integer> getDefaultInstanceCapacityMap() {
        return this.getDefaultCapacityMap(ClusterConfigProperty.DEFAULT_INSTANCE_CAPACITY_MAP);
    }

    public void setDefaultInstanceCapacityMap(Map<String, Integer> capacityDataMap) throws IllegalArgumentException {
        this.setDefaultCapacityMap(ClusterConfigProperty.DEFAULT_INSTANCE_CAPACITY_MAP, capacityDataMap);
    }

    public Map<String, Integer> getDefaultPartitionWeightMap() {
        return this.getDefaultCapacityMap(ClusterConfigProperty.DEFAULT_PARTITION_WEIGHT_MAP);
    }

    public void setDefaultPartitionWeightMap(Map<String, Integer> weightDataMap) throws IllegalArgumentException {
        this.setDefaultCapacityMap(ClusterConfigProperty.DEFAULT_PARTITION_WEIGHT_MAP, weightDataMap);
    }

    private Map<String, Integer> getDefaultCapacityMap(ClusterConfigProperty capacityPropertyType) {
        Map<String, String> capacityData = this._record.getMapField(capacityPropertyType.name());
        if (capacityData != null) {
            return capacityData.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> Integer.parseInt((String)entry.getValue())));
        }
        return Collections.emptyMap();
    }

    private void setDefaultCapacityMap(ClusterConfigProperty capacityPropertyType, Map<String, Integer> capacityDataMap) throws IllegalArgumentException {
        if (capacityDataMap == null) {
            throw new IllegalArgumentException("Default capacity data is null");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        capacityDataMap.entrySet().stream().forEach(entry -> {
            if ((Integer)entry.getValue() < 0) {
                throw new IllegalArgumentException(String.format("Default capacity data contains a negative value: %s = %d", entry.getKey(), entry.getValue()));
            }
            data.put((String)entry.getKey(), Integer.toString((Integer)entry.getValue()));
        });
        this._record.setMapField(capacityPropertyType.name(), data);
    }

    public void setGlobalRebalancePreference(Map<GlobalRebalancePreferenceKey, Integer> preference) {
        HashMap<String, String> preferenceMap = new HashMap<String, String>();
        preference.entrySet().stream().forEach(entry -> {
            if ((Integer)entry.getValue() > 10 || (Integer)entry.getValue() < 0) {
                throw new IllegalArgumentException(String.format("Invalid global rebalance preference configuration. Key %s, Value %d.", ((GlobalRebalancePreferenceKey)((Object)((Object)entry.getKey()))).name(), entry.getValue()));
            }
            preferenceMap.put(((GlobalRebalancePreferenceKey)((Object)((Object)entry.getKey()))).name(), Integer.toString((Integer)entry.getValue()));
        });
        this._record.setMapField(ClusterConfigProperty.REBALANCE_PREFERENCE.name(), preferenceMap);
    }

    public Map<GlobalRebalancePreferenceKey, Integer> getGlobalRebalancePreference() {
        Map<String, String> preferenceStrMap = this._record.getMapField(ClusterConfigProperty.REBALANCE_PREFERENCE.name());
        if (preferenceStrMap != null && !preferenceStrMap.isEmpty()) {
            HashMap<GlobalRebalancePreferenceKey, Integer> preference = new HashMap<GlobalRebalancePreferenceKey, Integer>();
            for (GlobalRebalancePreferenceKey key : GlobalRebalancePreferenceKey.values()) {
                if (!preferenceStrMap.containsKey(key.name())) {
                    return DEFAULT_GLOBAL_REBALANCE_PREFERENCE;
                }
                preference.put(key, Integer.parseInt(preferenceStrMap.get(key.name())));
            }
            return preference;
        }
        return DEFAULT_GLOBAL_REBALANCE_PREFERENCE;
    }

    public void setGlobalRebalanceAsyncMode(boolean isAsync) {
        this._record.setBooleanField(ClusterConfigProperty.GLOBAL_REBALANCE_ASYNC_MODE.name(), isAsync);
    }

    public boolean isGlobalRebalanceAsyncModeEnabled() {
        return this._record.getBooleanField(ClusterConfigProperty.GLOBAL_REBALANCE_ASYNC_MODE.name(), true);
    }

    public void setAbnormalStateResolverMap(Map<String, String> resolverMap) {
        if (resolverMap.values().stream().anyMatch(className -> className == null || className.isEmpty())) {
            throw new IllegalArgumentException("Invalid Abnormal State Resolver Map definition. Class name cannot be empty.");
        }
        this._record.setMapField(ClusterConfigProperty.ABNORMAL_STATES_RESOLVER_MAP.name(), resolverMap);
    }

    public Map<String, String> getAbnormalStateResolverMap() {
        Map<String, String> resolverMap = this._record.getMapField(ClusterConfigProperty.ABNORMAL_STATES_RESOLVER_MAP.name());
        return resolverMap == null ? Collections.EMPTY_MAP : resolverMap;
    }

    public Map<String, Map<String, String>> getIdealStateRules() {
        HashMap<String, Map<String, String>> idealStateRuleMap = new HashMap<String, Map<String, String>>();
        for (String simpleKey : this.getRecord().getSimpleFields().keySet()) {
            if (!simpleKey.startsWith(IDEAL_STATE_RULE_PREFIX)) continue;
            String simpleValue = this.getRecord().getSimpleField(simpleKey);
            String[] rules = simpleValue.split("(?<!\\\\),");
            HashMap singleRule = Maps.newHashMap();
            for (String rule : rules) {
                String[] keyValue = rule.split("(?<!\\\\)=");
                if (keyValue.length < 2) continue;
                singleRule.put(keyValue[0], keyValue[1]);
            }
            idealStateRuleMap.put(simpleKey, singleRule);
        }
        return idealStateRuleMap;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getClusterName() {
        return this._record.getId();
    }

    public static enum GlobalRebalancePreferenceKey {
        EVENNESS,
        LESS_MOVEMENT;

    }

    public static enum ClusterConfigProperty {
        HELIX_DISABLE_PIPELINE_TRIGGERS,
        PERSIST_BEST_POSSIBLE_ASSIGNMENT,
        PERSIST_INTERMEDIATE_ASSIGNMENT,
        TOPOLOGY,
        FAULT_ZONE_TYPE,
        TOPOLOGY_AWARE_ENABLED,
        DELAY_REBALANCE_DISABLED,
        DELAY_REBALANCE_ENABLED,
        DELAY_REBALANCE_TIME,
        STATE_TRANSITION_THROTTLE_CONFIGS,
        STATE_TRANSITION_CANCELLATION_ENABLED,
        MISS_TOP_STATE_DURATION_THRESHOLD,
        RESOURCE_PRIORITY_FIELD,
        REBALANCE_TIMER_PERIOD,
        MAX_CONCURRENT_TASK_PER_INSTANCE,
        MAX_PARTITIONS_PER_INSTANCE,
        MAX_OFFLINE_INSTANCES_ALLOWED,
        NUM_OFFLINE_INSTANCES_FOR_AUTO_EXIT,
        TARGET_EXTERNALVIEW_ENABLED,
        ERROR_PARTITION_THRESHOLD_FOR_LOAD_BALANCE,
        ERROR_OR_RECOVERY_PARTITION_THRESHOLD_FOR_LOAD_BALANCE,
        DISABLED_INSTANCES,
        QUOTA_TYPES,
        INSTANCE_CAPACITY_KEYS,
        DEFAULT_INSTANCE_CAPACITY_MAP,
        DEFAULT_PARTITION_WEIGHT_MAP,
        REBALANCE_PREFERENCE,
        GLOBAL_REBALANCE_ASYNC_MODE,
        ABNORMAL_STATES_RESOLVER_MAP;

    }
}

