/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.helix.HelixException;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultControllerMessageHandlerFactory
implements MultiTypeMessageHandlerFactory {
    private static Logger _logger = LoggerFactory.getLogger(DefaultControllerMessageHandlerFactory.class);

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        String type = message.getMsgType();
        if (!type.equals(this.getMessageType())) {
            throw new HelixException("Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType());
        }
        return new DefaultControllerMessageHandler(message, context);
    }

    @Override
    public String getMessageType() {
        return Message.MessageType.CONTROLLER_MSG.name();
    }

    @Override
    public List<String> getMessageTypes() {
        return ImmutableList.of((Object)Message.MessageType.CONTROLLER_MSG.name());
    }

    @Override
    public void reset() {
    }

    public static class DefaultControllerMessageHandler
    extends MessageHandler {
        public DefaultControllerMessageHandler(Message message, NotificationContext context) {
            super(message, context);
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            String type = this._message.getMsgType();
            HelixTaskResult result = new HelixTaskResult();
            if (!type.equals(Message.MessageType.CONTROLLER_MSG.name())) {
                throw new HelixException("Unexpected msg type for message " + this._message.getMsgId() + " type:" + this._message.getMsgType());
            }
            result.getTaskResultMap().put("ControllerResult", "msg " + this._message.getMsgId() + " from " + this._message.getMsgSrc() + " processed");
            result.setSuccess(true);
            return result;
        }

        @Override
        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            _logger.error("Message handling pipeline get an exception. MsgId:" + this._message.getMsgId(), (Throwable)e);
        }
    }
}

