/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.api.exceptions.HelixMetaDataAccessException;
import org.apache.helix.api.listeners.BatchMode;
import org.apache.helix.api.listeners.ClusterConfigChangeListener;
import org.apache.helix.api.listeners.ConfigChangeListener;
import org.apache.helix.api.listeners.ControllerChangeListener;
import org.apache.helix.api.listeners.CurrentStateChangeListener;
import org.apache.helix.api.listeners.CustomizedStateChangeListener;
import org.apache.helix.api.listeners.CustomizedStateConfigChangeListener;
import org.apache.helix.api.listeners.CustomizedStateRootChangeListener;
import org.apache.helix.api.listeners.CustomizedViewChangeListener;
import org.apache.helix.api.listeners.CustomizedViewRootChangeListener;
import org.apache.helix.api.listeners.ExternalViewChangeListener;
import org.apache.helix.api.listeners.IdealStateChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.MessageListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.api.listeners.ResourceConfigChangeListener;
import org.apache.helix.api.listeners.ScopedConfigChangeListener;
import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.manager.zk.ZKExceptionHandler;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.model.CustomizedStateConfig;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.mbeans.HelixCallbackMonitor;
import org.apache.helix.zookeeper.api.client.ChildrenSubscribeResult;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreFetch(enabled=false)
public class CallbackHandler
implements IZkChildListener,
IZkDataListener {
    private static Logger logger = LoggerFactory.getLogger(CallbackHandler.class);
    private static Map<NotificationContext.Type, List<NotificationContext.Type>> nextNotificationType = new HashMap<NotificationContext.Type, List<NotificationContext.Type>>();
    private static DedupEventProcessor SubscribeChangeEventProcessor;
    private final String _path;
    private final Object _listener;
    private final Set<Watcher.Event.EventType> _eventTypes;
    private final HelixDataAccessor _accessor;
    private final HelixConstants.ChangeType _changeType;
    private final RealmAwareZkClient _zkClient;
    private final AtomicLong _lastNotificationTimeStamp;
    private final HelixManager _manager;
    private final PropertyKey _propertyKey;
    private boolean _batchModeEnabled = false;
    private boolean _preFetchEnabled = true;
    private HelixCallbackMonitor _monitor;
    private CallbackProcessor _batchCallbackProcessor;
    private boolean _watchChild = true;
    private boolean _ready = false;
    private List<NotificationContext.Type> _expectTypes = nextNotificationType.get((Object)NotificationContext.Type.FINALIZE);

    public CallbackHandler(HelixManager manager, RealmAwareZkClient client, PropertyKey propertyKey, Object listener, Watcher.Event.EventType[] eventTypes, HelixConstants.ChangeType changeType) {
        this(manager, client, propertyKey, listener, eventTypes, changeType, null);
    }

    public CallbackHandler(HelixManager manager, RealmAwareZkClient client, PropertyKey propertyKey, Object listener, Watcher.Event.EventType[] eventTypes, HelixConstants.ChangeType changeType, HelixCallbackMonitor monitor) {
        if (listener == null) {
            throw new HelixException("listener could not be null");
        }
        if (monitor != null && !monitor.getChangeType().equals((Object)changeType)) {
            throw new HelixException("The specified callback monitor is for different change type: " + monitor.getChangeType().name());
        }
        this._manager = manager;
        this._accessor = manager.getHelixDataAccessor();
        this._zkClient = client;
        this._propertyKey = propertyKey;
        this._path = propertyKey.getPath();
        this._listener = listener;
        this._eventTypes = new HashSet<Watcher.Event.EventType>(Arrays.asList(eventTypes));
        this._changeType = changeType;
        this._lastNotificationTimeStamp = new AtomicLong(System.nanoTime());
        this._monitor = monitor;
        this._watchChild = this._changeType != HelixConstants.ChangeType.MESSAGE && this._changeType != HelixConstants.ChangeType.MESSAGES_CONTROLLER && this._changeType != HelixConstants.ChangeType.CONTROLLER;
        this.parseListenerProperties();
        this.init();
    }

    private void parseListenerProperties() {
        BatchMode batchMode = this._listener.getClass().getAnnotation(BatchMode.class);
        PreFetch preFetch = this._listener.getClass().getAnnotation(PreFetch.class);
        String asyncBatchModeEnabled = System.getProperty("helix.callbackhandler.isAsyncBatchModeEnabled");
        if (asyncBatchModeEnabled == null) {
            asyncBatchModeEnabled = System.getProperty("isAsyncBatchModeEnabled");
        }
        if (asyncBatchModeEnabled != null) {
            this._batchModeEnabled = Boolean.parseBoolean(asyncBatchModeEnabled);
            logger.info("isAsyncBatchModeEnabled by default: {}", (Object)this._batchModeEnabled);
        }
        if (batchMode != null) {
            this._batchModeEnabled = batchMode.enabled();
        }
        if (preFetch != null) {
            this._preFetchEnabled = preFetch.enabled();
        }
        Class listenerClass = null;
        switch (this._changeType) {
            case IDEAL_STATE: {
                listenerClass = IdealStateChangeListener.class;
                break;
            }
            case INSTANCE_CONFIG: {
                if (this._listener instanceof ConfigChangeListener) {
                    listenerClass = ConfigChangeListener.class;
                    break;
                }
                if (!(this._listener instanceof InstanceConfigChangeListener)) break;
                listenerClass = InstanceConfigChangeListener.class;
                break;
            }
            case CLUSTER_CONFIG: {
                listenerClass = ClusterConfigChangeListener.class;
                break;
            }
            case RESOURCE_CONFIG: {
                listenerClass = ResourceConfigChangeListener.class;
                break;
            }
            case CUSTOMIZED_STATE_CONFIG: {
                listenerClass = CustomizedStateConfigChangeListener.class;
                break;
            }
            case CONFIG: {
                listenerClass = ConfigChangeListener.class;
                break;
            }
            case LIVE_INSTANCE: {
                listenerClass = LiveInstanceChangeListener.class;
                break;
            }
            case CURRENT_STATE: {
                listenerClass = CurrentStateChangeListener.class;
                break;
            }
            case CUSTOMIZED_STATE_ROOT: {
                listenerClass = CustomizedStateRootChangeListener.class;
                break;
            }
            case CUSTOMIZED_STATE: {
                listenerClass = CustomizedStateChangeListener.class;
                break;
            }
            case MESSAGE: 
            case MESSAGES_CONTROLLER: {
                listenerClass = MessageListener.class;
                break;
            }
            case EXTERNAL_VIEW: 
            case TARGET_EXTERNAL_VIEW: {
                listenerClass = ExternalViewChangeListener.class;
                break;
            }
            case CUSTOMIZED_VIEW: {
                listenerClass = CustomizedViewChangeListener.class;
                break;
            }
            case CUSTOMIZED_VIEW_ROOT: {
                listenerClass = CustomizedViewRootChangeListener.class;
                break;
            }
            case CONTROLLER: {
                listenerClass = ControllerChangeListener.class;
            }
        }
        Method callbackMethod = listenerClass.getMethods()[0];
        try {
            Method method = this._listener.getClass().getMethod(callbackMethod.getName(), callbackMethod.getParameterTypes());
            BatchMode batchModeInMethod = method.getAnnotation(BatchMode.class);
            PreFetch preFetchInMethod = method.getAnnotation(PreFetch.class);
            if (batchModeInMethod != null) {
                this._batchModeEnabled = batchModeInMethod.enabled();
            }
            if (preFetchInMethod != null) {
                this._preFetchEnabled = preFetchInMethod.enabled();
            }
        }
        catch (NoSuchMethodException e) {
            logger.warn("No method {} defined in listener {}", (Object)callbackMethod.getName(), (Object)this._listener.getClass().getCanonicalName());
        }
    }

    public Object getListener() {
        return this._listener;
    }

    public String getPath() {
        return this._path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueTask(NotificationContext changeContext) throws Exception {
        if (this._batchModeEnabled && changeContext.getType() == NotificationContext.Type.CALLBACK) {
            logger.debug("Enqueuing callback");
            if (!this.isReady()) {
                logger.info("CallbackHandler is not ready, ignore change callback from path: {}, for listener: {}", (Object)this._path, this._listener);
            } else {
                CallbackHandler callbackHandler = this;
                synchronized (callbackHandler) {
                    if (this._batchCallbackProcessor == null) {
                        throw new HelixException("Failed to process callback in batch mode. Batch Callback Processor does not exist.");
                    }
                    this._batchCallbackProcessor.queueEvent(changeContext.getType(), changeContext);
                }
            }
        } else {
            this.invoke(changeContext);
        }
        if (this._monitor != null) {
            this._monitor.increaseCallbackUnbatchedCounters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(NotificationContext changeContext) throws Exception {
        NotificationContext.Type type = changeContext.getType();
        long start = System.currentTimeMillis();
        HelixManager helixManager = this._manager;
        synchronized (helixManager) {
            MessageListener messageListener;
            Object listener;
            if (logger.isInfoEnabled()) {
                logger.info("{} START:INVOKE {} listener: {} type: {}", new Object[]{Thread.currentThread().getId(), this._path, this._listener, type});
            }
            if (!this._expectTypes.contains((Object)type)) {
                logger.warn("Callback handler received event in wrong order. Listener: {}, path: {}, expected types: {}, but was {}", new Object[]{this._listener, this._path, this._expectTypes, type});
                return;
            }
            this._expectTypes = nextNotificationType.get((Object)type);
            if (type == NotificationContext.Type.INIT || type == NotificationContext.Type.FINALIZE) {
                this.subscribeForChanges(changeContext.getType(), this._path, this._watchChild);
            } else {
                this.subscribeForChangesAsyn(changeContext.getType(), this._path, this._watchChild);
            }
            if (this._changeType == HelixConstants.ChangeType.IDEAL_STATE) {
                IdealStateChangeListener idealStateChangeListener = (IdealStateChangeListener)this._listener;
                List<IdealState> idealStates = this.preFetch(this._propertyKey);
                idealStateChangeListener.onIdealStateChange(idealStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.INSTANCE_CONFIG) {
                if (this._listener instanceof ConfigChangeListener) {
                    ConfigChangeListener configChangeListener = (ConfigChangeListener)this._listener;
                    List<InstanceConfig> configs = this.preFetch(this._propertyKey);
                    configChangeListener.onConfigChange(configs, changeContext);
                } else if (this._listener instanceof InstanceConfigChangeListener) {
                    listener = (InstanceConfigChangeListener)this._listener;
                    List<InstanceConfig> configs = this.preFetch(this._propertyKey);
                    listener.onInstanceConfigChange(configs, changeContext);
                }
            } else if (this._changeType == HelixConstants.ChangeType.RESOURCE_CONFIG) {
                listener = (ResourceConfigChangeListener)this._listener;
                List<ResourceConfig> configs = this.preFetch(this._propertyKey);
                listener.onResourceConfigChange(configs, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_STATE_CONFIG) {
                listener = (CustomizedStateConfigChangeListener)this._listener;
                CustomizedStateConfig config = null;
                if (this._preFetchEnabled) {
                    config = (CustomizedStateConfig)this._accessor.getProperty(this._propertyKey);
                }
                listener.onCustomizedStateConfigChange(config, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CLUSTER_CONFIG) {
                listener = (ClusterConfigChangeListener)this._listener;
                ClusterConfig config = null;
                if (this._preFetchEnabled) {
                    config = (ClusterConfig)this._accessor.getProperty(this._propertyKey);
                }
                listener.onClusterConfigChange(config, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CONFIG) {
                listener = (ScopedConfigChangeListener)this._listener;
                List<HelixProperty> configs = this.preFetch(this._propertyKey);
                listener.onConfigChange(configs, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.LIVE_INSTANCE) {
                LiveInstanceChangeListener liveInstanceChangeListener = (LiveInstanceChangeListener)this._listener;
                List<LiveInstance> liveInstances = this.preFetch(this._propertyKey);
                liveInstanceChangeListener.onLiveInstanceChange(liveInstances, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CURRENT_STATE) {
                CurrentStateChangeListener currentStateChangeListener = (CurrentStateChangeListener)this._listener;
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<CurrentState> currentStates = this.preFetch(this._propertyKey);
                currentStateChangeListener.onStateChange(instanceName, currentStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_STATE_ROOT) {
                CustomizedStateRootChangeListener customizedStateRootChangeListener = (CustomizedStateRootChangeListener)this._listener;
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<String> customizedStateTypes = new ArrayList<String>();
                if (this._preFetchEnabled) {
                    customizedStateTypes = this._accessor.getChildNames(this._accessor.keyBuilder().customizedStatesRoot(instanceName));
                }
                customizedStateRootChangeListener.onCustomizedStateRootChange(instanceName, customizedStateTypes, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_STATE) {
                CustomizedStateChangeListener customizedStateChangeListener = (CustomizedStateChangeListener)this._listener;
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<CustomizedState> customizedStates = this.preFetch(this._propertyKey);
                customizedStateChangeListener.onCustomizedStateChange(instanceName, customizedStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGE) {
                messageListener = (MessageListener)this._listener;
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<Message> messages = this.preFetch(this._propertyKey);
                messageListener.onMessage(instanceName, messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGES_CONTROLLER) {
                messageListener = (MessageListener)this._listener;
                List<Message> messages = this.preFetch(this._propertyKey);
                messageListener.onMessage(this._manager.getInstanceName(), messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.EXTERNAL_VIEW || this._changeType == HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW) {
                ExternalViewChangeListener externalViewListener = (ExternalViewChangeListener)this._listener;
                List<ExternalView> externalViewList = this.preFetch(this._propertyKey);
                externalViewListener.onExternalViewChange(externalViewList, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_VIEW_ROOT) {
                CustomizedViewRootChangeListener customizedViewRootChangeListener = (CustomizedViewRootChangeListener)this._listener;
                List<String> customizedViewTypes = new ArrayList<String>();
                if (this._preFetchEnabled) {
                    customizedViewTypes = this._accessor.getChildNames(this._accessor.keyBuilder().customizedViews());
                }
                customizedViewRootChangeListener.onCustomizedViewRootChange(customizedViewTypes, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_VIEW) {
                CustomizedViewChangeListener customizedViewListener = (CustomizedViewChangeListener)this._listener;
                List<CustomizedView> customizedViewListList = this.preFetch(this._propertyKey);
                customizedViewListener.onCustomizedViewChange(customizedViewListList, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CONTROLLER) {
                ControllerChangeListener controllerChangelistener = (ControllerChangeListener)this._listener;
                controllerChangelistener.onControllerChange(changeContext);
            } else {
                logger.warn("Unknown change type: {}", (Object)this._changeType);
            }
            long end = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info("{} END:INVOKE {} listener: {} type: {} Took: {}ms", new Object[]{Thread.currentThread().getId(), this._path, this._listener, type, end - start});
            }
            if (this._monitor != null) {
                this._monitor.increaseCallbackCounters(end - start);
            }
        }
    }

    private <T extends HelixProperty> List<T> preFetch(PropertyKey key) {
        if (this._preFetchEnabled) {
            return this._accessor.getChildValues(key, true);
        }
        return Collections.emptyList();
    }

    private void subscribeChildChange(String path, NotificationContext.Type callbackType) {
        if (callbackType == NotificationContext.Type.INIT || callbackType == NotificationContext.Type.CALLBACK) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} subscribes child-change. path: {} , listener: {}", new Object[]{this._manager.getInstanceName(), path, this._listener});
            }
            ChildrenSubscribeResult childrenSubscribeResult = this._zkClient.subscribeChildChanges(path, this, callbackType != NotificationContext.Type.INIT);
            logger.debug("CallbackHandler {} subscribe data path {} result {}", new Object[]{this, path, childrenSubscribeResult.isInstalled()});
            if (!childrenSubscribeResult.isInstalled()) {
                logger.info("CallbackHandler {} subscribe data path {} failed!", (Object)this, (Object)path);
            }
        } else if (callbackType == NotificationContext.Type.FINALIZE) {
            logger.info("{} unsubscribe child-change. path: {}, listener: {}", new Object[]{this._manager.getInstanceName(), path, this._listener});
            this._zkClient.unsubscribeChildChanges(path, this);
        }
    }

    private void subscribeDataChange(String path, NotificationContext.Type callbackType) {
        if (callbackType == NotificationContext.Type.INIT || callbackType == NotificationContext.Type.CALLBACK) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} subscribe data-change. path: {}, listener: {}", new Object[]{this._manager.getInstanceName(), path, this._listener});
            }
            boolean subStatus = this._zkClient.subscribeDataChanges(path, this, callbackType != NotificationContext.Type.INIT);
            logger.debug("CallbackHandler {} subscribe data path {} result {}", new Object[]{this, path, subStatus});
            if (!subStatus) {
                logger.info("CallbackHandler {} subscribe data path {} failed!", (Object)this, (Object)path);
            }
        } else if (callbackType == NotificationContext.Type.FINALIZE) {
            logger.info("{} unsubscribe data-change. path: {}, listener: {}", new Object[]{this._manager.getInstanceName(), path, this._listener});
            this._zkClient.unsubscribeDataChanges(path, this);
        }
    }

    private void subscribeForChangesAsyn(NotificationContext.Type callbackType, String path, boolean watchChild) {
        SubscribeChangeEvent subscribeEvent = new SubscribeChangeEvent(this, callbackType, path, watchChild, this._listener);
        SubscribeChangeEventProcessor.queueEvent(subscribeEvent.handler, subscribeEvent);
    }

    private void subscribeForChanges(NotificationContext.Type callbackType, String path, boolean watchChild) {
        logger.info("Subscribing changes listener to path: {}, type: {}, listener: {}", new Object[]{path, callbackType, this._listener});
        long start = System.currentTimeMillis();
        if (this._eventTypes.contains(Watcher.Event.EventType.NodeDataChanged) || this._eventTypes.contains(Watcher.Event.EventType.NodeCreated) || this._eventTypes.contains(Watcher.Event.EventType.NodeDeleted)) {
            logger.info("Subscribing data change listener to path: {}", (Object)path);
            this.subscribeDataChange(path, callbackType);
        }
        if (this._eventTypes.contains(Watcher.Event.EventType.NodeChildrenChanged)) {
            logger.info("Subscribing child change listener to path: {}", (Object)path);
            this.subscribeChildChange(path, callbackType);
            if (watchChild) {
                logger.info("Subscribing data change listener to all children for path: {}", (Object)path);
                try {
                    switch (this._changeType) {
                        case IDEAL_STATE: 
                        case CURRENT_STATE: 
                        case CUSTOMIZED_STATE: 
                        case EXTERNAL_VIEW: 
                        case TARGET_EXTERNAL_VIEW: 
                        case CUSTOMIZED_VIEW: {
                            ZkBaseDataAccessor baseAccessor = new ZkBaseDataAccessor(this._zkClient);
                            List records = baseAccessor.getChildren(path, null, 0, 0, 0);
                            for (ZNRecord record : records) {
                                HelixProperty property = new HelixProperty(record);
                                String childPath = path + "/" + record.getId();
                                int bucketSize = property.getBucketSize();
                                if (bucketSize > 0) {
                                    this.subscribeChildChange(childPath, callbackType);
                                    this.subscribeDataChange(childPath, callbackType);
                                    List<String> bucketizedChildNames = this._zkClient.getChildren(childPath);
                                    if (bucketizedChildNames == null) continue;
                                    for (String bucketizedChildName : bucketizedChildNames) {
                                        String bucketizedChildPath = childPath + "/" + bucketizedChildName;
                                        this.subscribeDataChange(bucketizedChildPath, callbackType);
                                    }
                                    continue;
                                }
                                this.subscribeDataChange(childPath, callbackType);
                            }
                            break;
                        }
                        default: {
                            List<String> childNames = this._zkClient.getChildren(path);
                            if (childNames != null) {
                                for (String childName : childNames) {
                                    String childPath = path + "/" + childName;
                                    this.subscribeDataChange(childPath, callbackType);
                                }
                            }
                        }
                    }
                }
                catch (HelixMetaDataAccessException | ZkNoNodeException e) {
                    if (this._changeType == HelixConstants.ChangeType.CUSTOMIZED_STATE_ROOT) {
                        logger.warn("Failed to subscribe child/data change on path: {}, listener: {}. Instance does not support Customized State!", (Object)path, this._listener);
                    }
                    logger.warn("Failed to subscribe child/data change. path: {}, listener: {}", new Object[]{path, this._listener, e});
                }
            }
        }
        long end = System.currentTimeMillis();
        logger.info("Subscribing to path: {} took: {}", (Object)path, (Object)(end - start));
    }

    public Watcher.Event.EventType[] getEventTypes() {
        return (Watcher.Event.EventType[])this._eventTypes.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        logger.info("initializing CallbackHandler: {}, content: {} ", (Object)this.toString(), (Object)this.getContent());
        if (this._batchModeEnabled) {
            CallbackHandler callbackHandler = this;
            synchronized (callbackHandler) {
                if (this._batchCallbackProcessor != null) {
                    this._batchCallbackProcessor.resetEventQueue();
                } else {
                    this._batchCallbackProcessor = new CallbackProcessor(this);
                    this._batchCallbackProcessor.start();
                }
            }
        }
        this.updateNotificationTime(System.nanoTime());
        try {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.INIT);
            changeContext.setChangeType(this._changeType);
            this._ready = true;
            this.invoke(changeContext);
        }
        catch (Exception e) {
            String msg = "Exception while invoking init callback for listener:" + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    @Override
    public void handleDataChange(String dataPath, Object data) {
        if (logger.isDebugEnabled()) {
            logger.debug("Data change callback: paths changed: {}", (Object)dataPath);
        }
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                changeContext.setType(NotificationContext.Type.CALLBACK);
                changeContext.setPathChanged(dataPath);
                changeContext.setChangeType(this._changeType);
                this.enqueueTask(changeContext);
            }
        }
        catch (Exception e) {
            String msg = "exception in handling data-change. path: " + dataPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    @Override
    public void handleDataDeleted(String dataPath) {
        if (logger.isDebugEnabled()) {
            logger.debug("Data change callback: path deleted: {}", (Object)dataPath);
        }
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                logger.info("{} unsubscribe data-change. path: {}, listener: {}", new Object[]{this._manager.getInstanceName(), dataPath, this._listener});
                this._zkClient.unsubscribeDataChanges(dataPath, this);
                logger.info("{} unsubscribe child-change. path: {}, listener: {}", new Object[]{this._manager.getInstanceName(), dataPath, this._listener});
                this._zkClient.unsubscribeChildChanges(dataPath, this);
            }
        }
        catch (Exception e) {
            String msg = "exception in handling data-delete-change. path: " + dataPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    @Override
    public void handleChildChange(String parentPath, List<String> currentChilds) {
        if (logger.isDebugEnabled()) {
            logger.debug("Data change callback: child changed, path: {} , current child count: {}", (Object)parentPath, (Object)(currentChilds == null ? 0 : currentChilds.size()));
        }
        try {
            this.updateNotificationTime(System.nanoTime());
            if (parentPath != null && parentPath.startsWith(this._path)) {
                if (currentChilds == null && parentPath.equals(this._path)) {
                    this._manager.removeListener(this._propertyKey, this._listener);
                } else {
                    if (!this.isReady()) {
                        logger.info("Callbackhandler {} with path {} is in reset state. Stop subscription to ZK client to avoid leaking", (Object)this, (Object)parentPath);
                        return;
                    }
                    NotificationContext changeContext = new NotificationContext(this._manager);
                    changeContext.setType(NotificationContext.Type.CALLBACK);
                    changeContext.setPathChanged(parentPath);
                    changeContext.setChangeType(this._changeType);
                    this.subscribeForChanges(changeContext.getType(), this._path, this._watchChild);
                    this.enqueueTask(changeContext);
                }
            }
        }
        catch (Exception e) {
            String msg = "exception in handling child-change. instance: " + this._manager.getInstanceName() + ", parentPath: " + parentPath + ", listener: " + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    @Deprecated
    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(boolean isShutdown) {
        logger.info("Resetting CallbackHandler: {}. Is resetting for shutdown: {}.", (Object)this.toString(), (Object)isShutdown);
        try {
            this._ready = false;
            CallbackHandler callbackHandler = this;
            synchronized (callbackHandler) {
                if (this._batchCallbackProcessor != null) {
                    if (isShutdown) {
                        this._batchCallbackProcessor.shutdown();
                        this._batchCallbackProcessor = null;
                    } else {
                        this._batchCallbackProcessor.resetEventQueue();
                    }
                }
            }
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.FINALIZE);
            changeContext.setChangeType(this._changeType);
            this.invoke(changeContext);
        }
        catch (Exception e) {
            String msg = "Exception while resetting the listener:" + this._listener;
            ZKExceptionHandler.getInstance().handle(msg, e);
        }
    }

    private void updateNotificationTime(long nanoTime) {
        boolean b;
        long l = this._lastNotificationTimeStamp.get();
        while (nanoTime > l && !(b = this._lastNotificationTimeStamp.compareAndSet(l, nanoTime))) {
            l = this._lastNotificationTimeStamp.get();
        }
    }

    public boolean isReady() {
        return this._ready;
    }

    public String getContent() {
        return "CallbackHandler{_watchChild=" + this._watchChild + ", _preFetchEnabled=" + this._preFetchEnabled + ", _batchModeEnabled=" + this._batchModeEnabled + ", _path='" + this._path + '\'' + ", _listener=" + this._listener + ", _changeType=" + (Object)((Object)this._changeType) + ", _manager=" + this._manager + ", _zkClient=" + this._zkClient + '}';
    }

    static {
        nextNotificationType.put(NotificationContext.Type.INIT, Arrays.asList(NotificationContext.Type.CALLBACK, NotificationContext.Type.FINALIZE));
        nextNotificationType.put(NotificationContext.Type.CALLBACK, Arrays.asList(NotificationContext.Type.CALLBACK, NotificationContext.Type.FINALIZE));
        nextNotificationType.put(NotificationContext.Type.FINALIZE, Arrays.asList(NotificationContext.Type.INIT));
        SubscribeChangeEventProcessor = new DedupEventProcessor<CallbackHandler, SubscribeChangeEvent>("Singleton", "CallbackHandler-AsycSubscribe"){

            @Override
            protected void handleEvent(SubscribeChangeEvent event) {
                logger.info("Resubscribe change listener to path: {}, for listener: {}, watchChild: {}", new Object[]{event.path, event.listener, event.watchChild});
                try {
                    if (event.handler.isReady()) {
                        event.handler.subscribeForChanges(event.callbackType, event.path, event.watchChild);
                    } else {
                        logger.info("CallbackHandler is not ready, stop subscribing changes listener to path: {} for listener: {} watchChild: {}", new Object[]{event.path, event.listener, event.listener});
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to resubscribe change to path: {} for listener: {}", new Object[]{event.path, event.listener, e});
                }
            }
        };
        SubscribeChangeEventProcessor.start();
    }

    class CallbackProcessor
    extends DedupEventProcessor<NotificationContext.Type, NotificationContext> {
        private CallbackHandler _handler;

        public CallbackProcessor(CallbackHandler handler) {
            super(CallbackHandler.this._manager.getClusterName(), "CallbackProcessor@" + Integer.toHexString(handler.hashCode()));
            this._handler = handler;
        }

        @Override
        protected void handleEvent(NotificationContext event) {
            try {
                this._handler.invoke(event);
            }
            catch (Exception e) {
                logger.warn("Exception in callback processing thread. Skipping callback", (Throwable)e);
            }
        }
    }

    class SubscribeChangeEvent {
        final CallbackHandler handler;
        final String path;
        final NotificationContext.Type callbackType;
        final Object listener;
        final boolean watchChild;

        SubscribeChangeEvent(CallbackHandler handler, NotificationContext.Type callbackType, String path, boolean watchChild, Object listener) {
            this.handler = handler;
            this.path = path;
            this.callbackType = callbackType;
            this.listener = listener;
            this.watchChild = watchChild;
        }
    }
}

