/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.customizedstate;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedStateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomizedStateProvider.class);
    private final HelixManager _helixManager;
    private final HelixDataAccessor _helixDataAccessor;
    private String _instanceName;

    public CustomizedStateProvider(HelixManager helixManager, String instanceName) {
        this._helixManager = helixManager;
        this._instanceName = instanceName;
        this._helixDataAccessor = this._helixManager.getHelixDataAccessor();
    }

    public void updateCustomizedState(String customizedStateName, String resourceName, String partitionName, String customizedState) {
        HashMap<String, String> customizedStateMap = new HashMap<String, String>();
        customizedStateMap.put(CustomizedState.CustomizedStateProperty.CURRENT_STATE.name(), customizedState);
        this.updateCustomizedState(customizedStateName, resourceName, partitionName, customizedStateMap);
    }

    public void updateCustomizedState(String customizedStateName, String resourceName, String partitionName, Map<String, String> customizedStateMap) {
        PropertyKey.Builder keyBuilder = this._helixDataAccessor.keyBuilder();
        PropertyKey propertyKey = keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName);
        ZNRecord record = new ZNRecord(resourceName);
        record.setMapField(partitionName, customizedStateMap);
        if (!this._helixDataAccessor.updateProperty(propertyKey, new CustomizedState(record))) {
            throw new HelixException(String.format("Failed to persist customized state %s to zk for instance %s, resource %s", customizedStateName, this._instanceName, record.getId()));
        }
    }

    public CustomizedState getCustomizedState(String customizedStateName, String resourceName) {
        HelixDataAccessor accessor = this._helixManager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (CustomizedState)accessor.getProperty(keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName));
    }

    public Map<String, String> getPerPartitionCustomizedState(String customizedStateName, String resourceName, String partitionName) {
        PropertyKey.Builder keyBuilder = this._helixDataAccessor.keyBuilder();
        Map<String, Map<String, String>> mapView = ((HelixProperty)this._helixDataAccessor.getProperty(keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName))).getRecord().getMapFields();
        return mapView.get(partitionName);
    }

    public void deletePerPartitionCustomizedState(String customizedStateName, String resourceName, final String partitionName) {
        PropertyKey.Builder keyBuilder = this._helixDataAccessor.keyBuilder();
        PropertyKey propertyKey = keyBuilder.customizedState(this._instanceName, customizedStateName, resourceName);
        CustomizedState existingState = this.getCustomizedState(customizedStateName, resourceName);
        this._helixDataAccessor.updateProperty(propertyKey, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord current) {
                current.getMapFields().remove(partitionName);
                return current;
            }
        }, existingState);
    }
}

