/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CustomizedStateOutput;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedStateComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(CustomizedStateComputationStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        Set<String> aggregationEnabledTypes = cache.getAggregationEnabledCustomizedStateTypes();
        if (cache == null || resourceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        CustomizedStateOutput customizedStateOutput = new CustomizedStateOutput();
        for (LiveInstance instance : liveInstances.values()) {
            String instanceName = instance.getInstanceName();
            for (String customizedStateType : aggregationEnabledTypes) {
                Map<String, CustomizedState> customizedStateMap = cache.getCustomizedState(instanceName, customizedStateType);
                this.updateCustomizedStates(instanceName, customizedStateType, customizedStateMap, customizedStateOutput, resourceMap);
            }
        }
        event.addAttribute(AttributeName.CUSTOMIZED_STATE.name(), customizedStateOutput);
    }

    private void updateCustomizedStates(String instanceName, String customizedStateType, Map<String, CustomizedState> customizedStates, CustomizedStateOutput customizedStateOutput, Map<String, Resource> resourceMap) {
        for (CustomizedState customizedState : customizedStates.values()) {
            String resourceName = customizedState.getResourceName();
            Resource resource = resourceMap.get(resourceName);
            if (resource == null) continue;
            Map<String, String> partitionStateMap = customizedState.getPartitionStateMap(CustomizedState.CustomizedStateProperty.CURRENT_STATE);
            for (String partitionName : partitionStateMap.keySet()) {
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                customizedStateOutput.setCustomizedState(customizedStateType, resourceName, partition, instanceName, customizedState.getState(partitionName));
            }
        }
    }
}

