/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Collections;
import java.util.Map;
import org.apache.helix.controller.rebalancer.waged.constraints.SoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;

class PartitionMovementConstraint
extends SoftConstraint {
    private static final double MAX_SCORE = 1.0;
    private static final double MIN_SCORE = 0.0;
    private static final double STATE_TRANSITION_COST_FACTOR = 0.5;
    private static final double MOVEMENT_COST_FACTOR = 0.25;

    PartitionMovementConstraint() {
        super(1.0, 0.0);
    }

    @Override
    protected double getAssignmentScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        Map<String, String> bestPossibleAssignment = this.getStateMap(replica, clusterContext.getBestPossibleAssignment());
        Map<String, String> baselineAssignment = this.getStateMap(replica, clusterContext.getBaselineAssignment());
        String nodeName = node.getInstanceName();
        String state = replica.getReplicaState();
        if (bestPossibleAssignment.isEmpty()) {
            return this.calculateAssignmentScore(nodeName, state, baselineAssignment);
        }
        double score = this.calculateAssignmentScore(nodeName, state, bestPossibleAssignment);
        if (score == 0.0 && baselineAssignment.containsKey(nodeName)) {
            score = 0.25;
        }
        return score;
    }

    private Map<String, String> getStateMap(AssignableReplica replica, Map<String, ResourceAssignment> assignment) {
        String resourceName = replica.getResourceName();
        String partitionName = replica.getPartitionName();
        if (assignment == null || !assignment.containsKey(resourceName)) {
            return Collections.emptyMap();
        }
        return assignment.get(resourceName).getReplicaMap(new Partition(partitionName));
    }

    private double calculateAssignmentScore(String nodeName, String state, Map<String, String> instanceToStateMap) {
        if (instanceToStateMap.containsKey(nodeName)) {
            return state.equals(instanceToStateMap.get(nodeName)) ? 1.0 : 0.5;
        }
        return 0.0;
    }

    @Override
    protected SoftConstraint.NormalizeFunction getNormalizeFunction() {
        return score -> score;
    }
}

