/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.ResourceConfig;

public class WagedValidationUtil {
    public static Map<String, Integer> validateAndGetInstanceCapacity(ClusterConfig clusterConfig, InstanceConfig instanceConfig) {
        HashMap<String, Integer> instanceCapacity = new HashMap<String, Integer>(clusterConfig.getDefaultInstanceCapacityMap());
        instanceCapacity.putAll(instanceConfig.getInstanceCapacityMap());
        List<String> requiredCapacityKeys = clusterConfig.getInstanceCapacityKeys();
        if (!instanceCapacity.keySet().containsAll(requiredCapacityKeys)) {
            throw new HelixException(String.format("The required capacity keys: %s are not fully configured in the instance: %s, capacity map: %s.", requiredCapacityKeys.toString(), instanceConfig.getInstanceName(), ((Object)instanceCapacity).toString()));
        }
        return instanceCapacity;
    }

    public static Map<String, Integer> validateAndGetPartitionCapacity(String partitionName, ResourceConfig resourceConfig, Map<String, Map<String, Integer>> capacityMap, ClusterConfig clusterConfig) {
        HashMap<String, Integer> partitionCapacity = new HashMap<String, Integer>(clusterConfig.getDefaultPartitionWeightMap());
        partitionCapacity.putAll(capacityMap.getOrDefault(partitionName, capacityMap.getOrDefault("DEFAULT", new HashMap())));
        List<String> requiredCapacityKeys = clusterConfig.getInstanceCapacityKeys();
        if (!partitionCapacity.keySet().containsAll(requiredCapacityKeys)) {
            throw new HelixException(String.format("The required capacity keys: %s are not fully configured in the resource: %s, partition: %s, weight map: %s.", requiredCapacityKeys.toString(), resourceConfig.getResourceName(), partitionName, ((Object)partitionCapacity).toString()));
        }
        return partitionCapacity;
    }
}

