/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector.trimmer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.changedetector.trimmer.HelixPropertyTrimmer;
import org.apache.helix.model.IdealState;

public class IdealStateTrimmer
extends HelixPropertyTrimmer<IdealState> {
    private static final IdealStateTrimmer IDEAL_STATE_TRIMMER = new IdealStateTrimmer();
    private static final Map<HelixPropertyTrimmer.FieldType, Set<String>> STATIC_TOPOLOGY_RELATED_FIELD_MAP = ImmutableMap.of((Object)((Object)HelixPropertyTrimmer.FieldType.SIMPLE_FIELD), (Object)ImmutableSet.of((Object)IdealState.IdealStateProperty.NUM_PARTITIONS.name(), (Object)IdealState.IdealStateProperty.STATE_MODEL_DEF_REF.name(), (Object)IdealState.IdealStateProperty.STATE_MODEL_FACTORY_NAME.name(), (Object)IdealState.IdealStateProperty.REPLICAS.name(), (Object)IdealState.IdealStateProperty.MIN_ACTIVE_REPLICAS.name(), (Object)IdealState.IdealStateProperty.IDEAL_STATE_MODE.name(), (Object[])new String[]{IdealState.IdealStateProperty.REBALANCE_MODE.name(), IdealState.IdealStateProperty.REBALANCER_CLASS_NAME.name(), IdealState.IdealStateProperty.REBALANCE_STRATEGY.name(), IdealState.IdealStateProperty.MAX_PARTITIONS_PER_INSTANCE.name(), IdealState.IdealStateProperty.INSTANCE_GROUP_TAG.name(), IdealState.IdealStateProperty.RESOURCE_GROUP_NAME.name(), IdealState.IdealStateProperty.RESOURCE_TYPE.name()}));

    private IdealStateTrimmer() {
    }

    @Override
    protected Map<HelixPropertyTrimmer.FieldType, Set<String>> getNonTrimmableFields(IdealState idealState) {
        HashMap<HelixPropertyTrimmer.FieldType, Set<String>> nonTrimmableFields = new HashMap<HelixPropertyTrimmer.FieldType, Set<String>>(STATIC_TOPOLOGY_RELATED_FIELD_MAP);
        switch (idealState.getRebalanceMode()) {
            case CUSTOMIZED: {
                nonTrimmableFields.put(HelixPropertyTrimmer.FieldType.MAP_FIELD, idealState.getRecord().getMapFields().keySet());
                nonTrimmableFields.put(HelixPropertyTrimmer.FieldType.LIST_FIELD, idealState.getRecord().getListFields().keySet());
                break;
            }
            case SEMI_AUTO: {
                nonTrimmableFields.put(HelixPropertyTrimmer.FieldType.LIST_FIELD, idealState.getRecord().getListFields().keySet());
                break;
            }
        }
        return nonTrimmableFields;
    }

    @Override
    public IdealState trimProperty(IdealState property) {
        return new IdealState(this.doTrim(property));
    }

    public static IdealStateTrimmer getInstance() {
        return IDEAL_STATE_TRIMMER;
    }
}

