/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.changedetector.trimmer;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public abstract class HelixPropertyTrimmer<T extends HelixProperty> {
    protected abstract Map<FieldType, Set<String>> getNonTrimmableFields(T var1);

    public abstract T trimProperty(T var1);

    protected ZNRecord doTrim(T originalProperty) {
        ZNRecord trimmedZNRecord = new ZNRecord(((HelixProperty)originalProperty).getId());
        for (Map.Entry<FieldType, Set<String>> fieldEntry : this.getNonTrimmableFields(originalProperty).entrySet()) {
            FieldType fieldType = fieldEntry.getKey();
            Set<String> fieldKeySet = fieldEntry.getValue();
            if (null == fieldKeySet || fieldKeySet.isEmpty()) continue;
            switch (fieldType) {
                case SIMPLE_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        String value = originalProperty.getRecord().getSimpleField((String)fieldKey);
                        if (null != value) {
                            trimmedZNRecord.setSimpleField((String)fieldKey, value);
                        }
                    });
                }
                case LIST_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        List<String> values = originalProperty.getRecord().getListField((String)fieldKey);
                        if (null != values) {
                            trimmedZNRecord.setListField((String)fieldKey, values);
                        }
                    });
                }
                case MAP_FIELD: {
                    fieldKeySet.stream().forEach(fieldKey -> {
                        Map<String, String> valueMap = originalProperty.getRecord().getMapField((String)fieldKey);
                        if (null != valueMap) {
                            trimmedZNRecord.setMapField((String)fieldKey, valueMap);
                        }
                    });
                }
            }
        }
        return trimmedZNRecord;
    }

    static enum FieldType {
        SIMPLE_FIELD,
        LIST_FIELD,
        MAP_FIELD;

    }
}

