/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.Properties;
import org.apache.helix.HelixCloudProperty;
import org.apache.helix.model.CloudConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixManagerProperty {
    private static final Logger LOG = LoggerFactory.getLogger((String)HelixManagerProperty.class.getName());
    private String _version;
    private long _healthReportLatency;
    private HelixCloudProperty _helixCloudProperty;

    public HelixManagerProperty(Properties helixManagerProperties, CloudConfig cloudConfig) {
        this._helixCloudProperty = new HelixCloudProperty(cloudConfig);
        this.setVersion(helixManagerProperties.getProperty("clustermanager.version"));
        this.setHealthReportLatency(helixManagerProperties.getProperty("helixmanager.participantHealthReport.reportLatency"));
    }

    public HelixCloudProperty getHelixCloudProperty() {
        return this._helixCloudProperty;
    }

    public String getVersion() {
        return this._version;
    }

    public long getHealthReportLatency() {
        return this._healthReportLatency;
    }

    public void setHelixCloudProperty(HelixCloudProperty helixCloudProperty) {
        this._helixCloudProperty = helixCloudProperty;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setHealthReportLatency(String latency) {
        this._healthReportLatency = Long.valueOf(latency);
    }
}

