/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.helix.HelixException;
import org.apache.helix.cloud.constants.CloudProvider;
import org.apache.helix.model.CloudConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixCloudProperty {
    private static final Logger LOG = LoggerFactory.getLogger((String)HelixCloudProperty.class.getName());
    private static final String AZURE_CLOUD_PROPERTY_FILE = "azure-cloud.properties";
    private static final String CLOUD_INFO_SOURCE = "cloud_info_source";
    private static final String CLOUD_INFO_PROCESSFOR_NAME = "cloud_info_processor_name";
    private static final String CLOUD_MAX_RETRY = "cloud_max_retry";
    private static final String CONNECTION_TIMEOUT_MS = "connection_timeout_ms";
    private static final String REQUEST_TIMEOUT_MS = "request_timeout_ms";
    private boolean _isCloudEnabled;
    private String _cloudId;
    private String _cloudProvider;
    private List<String> _cloudInfoSources;
    private String _cloudInfoProcessorName;
    private int _cloudMaxRetry;
    private long _cloudConnectionTimeout;
    private long _cloudRequestTimeout;
    private Properties _customizedCloudProperties = new Properties();

    public HelixCloudProperty(CloudConfig cloudConfig) {
        this.setCloudEndabled(cloudConfig.isCloudEnabled());
        if (cloudConfig.isCloudEnabled()) {
            this.setCloudId(cloudConfig.getCloudID());
            this.setCloudProvider(cloudConfig.getCloudProvider());
            switch (CloudProvider.valueOf(cloudConfig.getCloudProvider())) {
                case AZURE: {
                    Properties azureProperties = new Properties();
                    try {
                        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(AZURE_CLOUD_PROPERTY_FILE);
                        azureProperties.load(stream);
                    }
                    catch (IOException e) {
                        String errMsg = "failed to open Helix Azure cloud properties file: azure-cloud.properties";
                        throw new IllegalArgumentException(errMsg, e);
                    }
                    LOG.info("Successfully loaded Helix Azure cloud properties: {}", (Object)azureProperties);
                    this.setCloudInfoSources(Collections.singletonList(azureProperties.getProperty(CLOUD_INFO_SOURCE)));
                    this.setCloudInfoProcessorName(azureProperties.getProperty(CLOUD_INFO_PROCESSFOR_NAME));
                    this.setCloudMaxRetry(Integer.valueOf(azureProperties.getProperty(CLOUD_MAX_RETRY)));
                    this.setCloudConnectionTimeout(Long.valueOf(azureProperties.getProperty(CONNECTION_TIMEOUT_MS)));
                    this.setCloudRequestTimeout(Long.valueOf(azureProperties.getProperty(REQUEST_TIMEOUT_MS)));
                    break;
                }
                case CUSTOMIZED: {
                    this.setCloudInfoSources(cloudConfig.getCloudInfoSources());
                    this.setCloudInfoProcessorName(cloudConfig.getCloudInfoProcessorName());
                    break;
                }
                default: {
                    throw new HelixException(String.format("Unsupported cloud provider: %s", cloudConfig.getCloudProvider()));
                }
            }
        }
    }

    public boolean getCloudEnabled() {
        return this._isCloudEnabled;
    }

    public String getCloudId() {
        return this._cloudId;
    }

    public String getCloudProvider() {
        return this._cloudProvider;
    }

    public List<String> getCloudInfoSources() {
        return this._cloudInfoSources;
    }

    public String getCloudInfoProcessorName() {
        return this._cloudInfoProcessorName;
    }

    public int getCloudMaxRetry() {
        return this._cloudMaxRetry;
    }

    public long getCloudConnectionTimeout() {
        return this._cloudConnectionTimeout;
    }

    public long getCloudRequestTimeout() {
        return this._cloudRequestTimeout;
    }

    public Properties getCustomizedCloudProperties() {
        return this._customizedCloudProperties;
    }

    public void setCloudEndabled(boolean isCloudEnabled) {
        this._isCloudEnabled = isCloudEnabled;
    }

    public void setCloudId(String cloudId) {
        this._cloudId = cloudId;
    }

    public void setCloudProvider(String cloudProvider) {
        this._cloudProvider = cloudProvider;
    }

    public void setCloudInfoSources(List<String> sources) {
        this._cloudInfoSources = sources;
    }

    public void setCloudInfoProcessorName(String cloudInfoProcessorName) {
        this._cloudInfoProcessorName = cloudInfoProcessorName;
    }

    public void setCloudMaxRetry(int cloudMaxRetry) {
        this._cloudMaxRetry = cloudMaxRetry;
    }

    public void setCloudConnectionTimeout(long cloudConnectionTimeout) {
        this._cloudConnectionTimeout = cloudConnectionTimeout;
    }

    public void setCloudRequestTimeout(long cloudRequestTimeout) {
        this._cloudRequestTimeout = cloudRequestTimeout;
    }

    public void setCustomizedCloudProperties(Properties customizedCloudProperties) {
        this._customizedCloudProperties.putAll((Map<?, ?>)customizedCloudProperties);
    }
}

