/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalanceUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)RebalanceUtil.class.getName());

    public static Map<String, Object> buildInternalIdealState(IdealState state) {
        HashMap<String, Integer> partitionIndex = new HashMap<String, Integer>();
        HashMap<String, String> reversePartitionIndex = new HashMap<String, String>();
        boolean indexInPartitionName = true;
        for (String partitionId : state.getPartitionSet()) {
            int lastPos = partitionId.lastIndexOf("_");
            if (lastPos < 0) {
                indexInPartitionName = false;
                break;
            }
            try {
                String idStr = partitionId.substring(lastPos + 1);
                int partition = Integer.parseInt(idStr);
                partitionIndex.put(partitionId, partition);
                reversePartitionIndex.put(state.getResourceName() + "_" + partition, partitionId);
            }
            catch (Exception e) {
                indexInPartitionName = false;
                partitionIndex.clear();
                reversePartitionIndex.clear();
                break;
            }
        }
        if (!indexInPartitionName) {
            ArrayList<String> partitions = new ArrayList<String>();
            partitions.addAll(state.getPartitionSet());
            Collections.sort(partitions);
            for (int i = 0; i < partitions.size(); ++i) {
                partitionIndex.put((String)partitions.get(i), i);
                reversePartitionIndex.put(state.getResourceName() + "_" + i, (String)partitions.get(i));
            }
        }
        TreeMap nodeMasterAssignmentMap = new TreeMap();
        TreeMap combinedNodeSlaveAssignmentMap = new TreeMap();
        for (String partition : state.getPartitionSet()) {
            List<String> instances = state.getRecord().getListField(partition);
            String master = instances.get(0);
            if (!nodeMasterAssignmentMap.containsKey(master)) {
                nodeMasterAssignmentMap.put(master, new ArrayList());
            }
            if (!combinedNodeSlaveAssignmentMap.containsKey(master)) {
                combinedNodeSlaveAssignmentMap.put(master, new TreeMap());
            }
            ((List)nodeMasterAssignmentMap.get(master)).add(partitionIndex.get(partition));
            for (int i = 1; i < instances.size(); ++i) {
                String instance = instances.get(i);
                Map slaveMap = (Map)combinedNodeSlaveAssignmentMap.get(master);
                if (!slaveMap.containsKey(instance)) {
                    slaveMap.put(instance, new ArrayList());
                }
                ((List)slaveMap.get(instance)).add(partitionIndex.get(partition));
            }
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("MasterAssignmentMap", nodeMasterAssignmentMap);
        result.put("SlaveAssignmentMap", combinedNodeSlaveAssignmentMap);
        result.put("replicas", Integer.parseInt(state.getReplicas()));
        result.put("partitions", new Integer(state.getRecord().getListFields().size()));
        result.put("reversePartitionIndex", reversePartitionIndex);
        return result;
    }

    public static String[] parseStates(String clusterName, StateModelDefinition stateModDef) {
        String[] result = new String[2];
        String masterStateValue = null;
        String slaveStateValue = null;
        List<String> statePriorityList = stateModDef.getStatesPriorityList();
        for (String state : statePriorityList) {
            String count = stateModDef.getNumInstancesPerState(state);
            if (count.equals("1")) {
                if (masterStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                masterStateValue = state;
                continue;
            }
            if (count.equalsIgnoreCase("R")) {
                if (slaveStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                slaveStateValue = state;
                continue;
            }
            if (!count.equalsIgnoreCase("N")) continue;
            if (masterStateValue != null || slaveStateValue != null) {
                throw new HelixException("Invalid or unsupported state model definition");
            }
            masterStateValue = slaveStateValue = state;
        }
        if (masterStateValue == null && slaveStateValue == null) {
            throw new HelixException("Invalid or unsupported state model definition");
        }
        if (masterStateValue == null) {
            masterStateValue = slaveStateValue;
        }
        result[0] = masterStateValue;
        result[1] = slaveStateValue;
        return result;
    }

    public static void scheduleOnDemandPipeline(String clusterName, long delay) {
        RebalanceUtil.scheduleOnDemandPipeline(clusterName, delay, true);
    }

    public static void scheduleOnDemandPipeline(String clusterName, long delay, boolean shouldRefreshCache) {
        if (clusterName == null) {
            LOG.error("Failed to issue a pipeline run. ClusterName is null.");
            return;
        }
        if (delay < 0L) {
            LOG.error("Failed to issue a pipeline run. Delay is invalid.");
            return;
        }
        GenericHelixController controller = GenericHelixController.getController(clusterName);
        if (controller != null) {
            controller.scheduleOnDemandRebalance(delay, shouldRefreshCache);
        } else {
            LOG.error("Failed to issue a pipeline. Controller for cluster {} does not exist.", (Object)clusterName);
        }
    }

    public static void runStage(ClusterEvent event, Stage stage) throws Exception {
        StageContext context = new StageContext();
        stage.init(context);
        stage.preProcess();
        stage.process(event);
        stage.postProcess();
    }
}

