/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.PropertyKey;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.tools.ClusterExternalViewVerifier;
import org.apache.helix.tools.ClusterVerifiers.BestPossibleExternalViewVerifier;
import org.apache.helix.tools.ClusterVerifiers.ClusterLiveNodesVerifier;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.factory.DedicatedZkClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestUtil {
    private static Logger LOG = LoggerFactory.getLogger(IntegrationTestUtil.class);
    public static final long DEFAULT_TIMEOUT = 30000L;
    public static final String help = "help";
    public static final String zkSvr = "zkSvr";
    public static final String timeout = "timeout";
    public static final String verifyExternalView = "verifyExternalView";
    public static final String verifyLiveNodes = "verifyLiveNodes";
    public static final String readZNode = "readZNode";
    public static final String readLeader = "readLeader";
    public static final String verifyClusterState = "verifyClusterState";
    final HelixZkClient _zkclient;
    final ZNRecordSerializer _serializer;
    final long _timeoutValue;

    public IntegrationTestUtil(HelixZkClient zkclient, long timeoutValue) {
        this._zkclient = zkclient;
        this._timeoutValue = timeoutValue;
        this._serializer = new ZNRecordSerializer();
    }

    public void verifyExternalView(String[] args) {
        if (args == null || args.length == 0) {
            System.err.println("Illegal arguments for verifyExternalView");
            return;
        }
        String clusterName = args[0];
        ArrayList<String> liveNodes = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            liveNodes.add(args[i]);
        }
        ClusterExternalViewVerifier verifier = new ClusterExternalViewVerifier(this._zkclient, clusterName, liveNodes);
        boolean success = verifier.verifyByPolling(this._timeoutValue);
        System.out.println(success ? "Successful" : "Failed");
        if (!success) {
            System.exit(1);
        }
    }

    public void verifyClusterState(String[] args) {
        if (args == null || args.length == 0) {
            System.err.println("Illegal arguments for verifyExternalView");
            return;
        }
        String clusterName = args[0];
        BestPossibleExternalViewVerifier clusterVerifier = new BestPossibleExternalViewVerifier.Builder(clusterName).setZkClient(this._zkclient).build();
        boolean success = ((ZkHelixClusterVerifier)clusterVerifier).verify(this._timeoutValue);
        System.out.println(success ? "Successful" : "Failed");
        if (!success) {
            System.exit(1);
        }
    }

    public void verifyLiveNodes(String[] args) {
        if (args == null || args.length == 0) {
            System.err.println("Illegal arguments for verifyLiveNodes");
            return;
        }
        String clusterName = args[0];
        ArrayList<String> liveNodes = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            liveNodes.add(args[i]);
        }
        ClusterLiveNodesVerifier verifier = new ClusterLiveNodesVerifier((RealmAwareZkClient)this._zkclient, clusterName, liveNodes);
        boolean success = verifier.verify(this._timeoutValue);
        System.out.println(success ? "Successful" : "Failed");
        if (!success) {
            System.exit(1);
        }
    }

    public void readZNode(String path) {
        ZNRecord record = (ZNRecord)this._zkclient.readData(path, true);
        if (record == null) {
            System.out.println("null");
        } else {
            System.out.println(new String(this._serializer.serialize(record)));
        }
    }

    static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options information");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"zookeeperAddress");
        OptionBuilder.withLongOpt((String)zkSvr);
        OptionBuilder.withDescription((String)"Provide zookeeper-address");
        Option zkSvrOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)timeout);
        OptionBuilder.withLongOpt((String)timeout);
        OptionBuilder.withDescription((String)"Provide timeout (in ms)");
        Option timeoutOption = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName node1 node2..");
        OptionBuilder.withLongOpt((String)verifyExternalView);
        OptionBuilder.withDescription((String)"Verify external-view");
        Option verifyExternalViewOption = OptionBuilder.create();
        OptionBuilder.hasArgs();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName");
        OptionBuilder.withLongOpt((String)verifyClusterState);
        OptionBuilder.withDescription((String)"Verify Bestpossible ClusterState");
        Option verifyClusterStateOption = OptionBuilder.create();
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName node1, node2..");
        OptionBuilder.withLongOpt((String)verifyLiveNodes);
        OptionBuilder.withDescription((String)"Verify live-nodes");
        Option verifyLiveNodesOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"zkPath");
        OptionBuilder.withLongOpt((String)readZNode);
        OptionBuilder.withDescription((String)"Read znode");
        Option readZNodeOption = OptionBuilder.create();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)"clusterName");
        OptionBuilder.withLongOpt((String)readLeader);
        OptionBuilder.withDescription((String)"Read cluster controller");
        Option readLeaderOption = OptionBuilder.create();
        OptionGroup optGroup = new OptionGroup();
        optGroup.setRequired(true);
        optGroup.addOption(verifyExternalViewOption);
        optGroup.addOption(verifyClusterStateOption);
        optGroup.addOption(verifyLiveNodesOption);
        optGroup.addOption(readZNodeOption);
        optGroup.addOption(readLeaderOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkSvrOption);
        options.addOption(timeoutOption);
        options.addOptionGroup(optGroup);
        return options;
    }

    static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ClusterExternalViewVerifier.class.getName(), cliOptions);
    }

    static void processCommandLineArgs(String[] cliArgs) {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = IntegrationTestUtil.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("failed to parse command-line args: " + Arrays.asList(cliArgs) + ", exception: " + pe.toString());
            IntegrationTestUtil.printUsage(cliOptions);
            System.exit(1);
        }
        HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
        clientConfig.setZkSerializer(new ZNRecordSerializer());
        HelixZkClient zkClient = DedicatedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(cmd.getOptionValue(zkSvr)), clientConfig);
        long timeoutValue = 30000L;
        if (cmd.hasOption(timeout)) {
            String timeoutStr = cmd.getOptionValue(timeout);
            try {
                timeoutValue = Long.valueOf(timeoutStr);
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid timeout value " + timeoutStr + ". Using default value: " + timeoutValue);
            }
        }
        IntegrationTestUtil util = new IntegrationTestUtil(zkClient, timeoutValue);
        if (cmd != null) {
            if (cmd.hasOption(verifyExternalView)) {
                String[] args = cmd.getOptionValues(verifyExternalView);
                util.verifyExternalView(args);
            } else if (cmd.hasOption(verifyClusterState)) {
                String[] args = cmd.getOptionValues(verifyClusterState);
                util.verifyClusterState(args);
            } else if (cmd.hasOption(verifyLiveNodes)) {
                String[] args = cmd.getOptionValues(verifyLiveNodes);
                util.verifyLiveNodes(args);
            } else if (cmd.hasOption(readZNode)) {
                String path = cmd.getOptionValue(readZNode);
                util.readZNode(path);
            } else if (cmd.hasOption(readLeader)) {
                String clusterName = cmd.getOptionValue(readLeader);
                PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
                util.readZNode(keyBuilder.controllerLeader().getPath());
            } else {
                IntegrationTestUtil.printUsage(cliOptions);
            }
        }
    }

    public static void main(String[] args) {
        IntegrationTestUtil.processCommandLineArgs(args);
    }
}

