/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.store.HelixPropertyStore;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.UserContentStore;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.util.RebalanceUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TaskUtil.class);
    public static final String CONTEXT_NODE = "Context";
    public static final String USER_CONTENT_NODE = "UserContent";
    public static final String WORKFLOW_CONTEXT_KW = "WorkflowContext";
    public static final String TASK_CONTEXT_KW = "TaskContext";

    protected static JobConfig getJobConfig(HelixDataAccessor accessor, String job) {
        HelixProperty jobResourceConfig = TaskUtil.getResourceConfig(accessor, job);
        if (jobResourceConfig == null) {
            return null;
        }
        return new JobConfig(jobResourceConfig);
    }

    protected static JobConfig getJobConfig(HelixManager manager, String job) {
        return TaskUtil.getJobConfig(manager.getHelixDataAccessor(), job);
    }

    protected static boolean createJobConfig(HelixDataAccessor accessor, String job, JobConfig jobConfig) {
        return TaskUtil.createResourceConfig(accessor, job, jobConfig);
    }

    protected static boolean removeJobConfig(HelixDataAccessor accessor, String job) {
        return TaskUtil.removeWorkflowJobConfig(accessor, job);
    }

    protected static WorkflowConfig getWorkflowConfig(HelixDataAccessor accessor, String workflow) {
        HelixProperty workflowCfg = TaskUtil.getResourceConfig(accessor, workflow);
        if (workflowCfg == null) {
            return null;
        }
        return new WorkflowConfig(workflowCfg);
    }

    protected static WorkflowConfig getWorkflowConfig(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowConfig(manager.getHelixDataAccessor(), workflow);
    }

    protected static boolean createWorkflowConfig(HelixDataAccessor accessor, String workflow, WorkflowConfig workflowConfig) {
        return TaskUtil.createResourceConfig(accessor, workflow, workflowConfig);
    }

    protected static boolean setWorkflowConfig(HelixDataAccessor accessor, String workflow, WorkflowConfig workflowConfig) {
        return TaskUtil.setResourceConfig(accessor, workflow, workflowConfig);
    }

    protected static boolean removeWorkflowConfig(HelixDataAccessor accessor, String workflow) {
        return TaskUtil.removeWorkflowJobConfig(accessor, workflow);
    }

    protected static HelixConfigScope getResourceConfigScope(String clusterName, String resource) {
        return new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(clusterName).forResource(resource).build();
    }

    protected static JobContext getJobContext(HelixPropertyStore<ZNRecord> propertyStore, String jobResource) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new JobContext(r) : null;
    }

    protected static JobContext getJobContext(HelixManager manager, String jobResource) {
        return TaskUtil.getJobContext(manager.getHelixPropertyStore(), jobResource);
    }

    protected static void setJobContext(HelixManager manager, String jobResource, JobContext ctx) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)jobResource, new Object[]{CONTEXT_NODE}), ctx.getRecord(), AccessOption.PERSISTENT);
    }

    protected static boolean removeJobContext(HelixManager manager, String jobResource) {
        return TaskUtil.removeJobContext(manager.getHelixPropertyStore(), jobResource);
    }

    protected static boolean removeJobContext(HelixPropertyStore<ZNRecord> propertyStore, String job) {
        return TaskUtil.removeWorkflowJobContext(propertyStore, job);
    }

    protected static WorkflowContext getWorkflowContext(HelixPropertyStore<ZNRecord> propertyStore, String workflow) {
        ZNRecord r = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[]{CONTEXT_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new WorkflowContext(r) : null;
    }

    protected static WorkflowContext getWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.getWorkflowContext(manager.getHelixPropertyStore(), workflow);
    }

    protected static void setWorkflowContext(HelixManager manager, String workflow, WorkflowContext workflowContext) {
        manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[]{CONTEXT_NODE}), workflowContext.getRecord(), AccessOption.PERSISTENT);
    }

    protected static boolean removeWorkflowContext(HelixManager manager, String workflow) {
        return TaskUtil.removeWorkflowContext(manager.getHelixPropertyStore(), workflow);
    }

    protected static boolean removeWorkflowContext(HelixPropertyStore<ZNRecord> propertyStore, String workflow) {
        return TaskUtil.removeWorkflowJobContext(propertyStore, workflow);
    }

    protected static void createUserContent(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource, ZNRecord record) {
        propertyStore.create(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE}), record, AccessOption.PERSISTENT);
    }

    protected static String getWorkflowJobUserContent(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource, String key) {
        Map<String, String> userContentMap = TaskUtil.getWorkflowJobUserContentMap(propertyStore, workflowJobResource);
        return userContentMap != null ? userContentMap.get(key) : null;
    }

    protected static Map<String, String> getWorkflowJobUserContentMap(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource) {
        ZNRecord record = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE}), null, AccessOption.PERSISTENT);
        return record != null ? record.getSimpleFields() : null;
    }

    protected static void addWorkflowJobUserContent(HelixManager manager, String workflowJobResource, String key, String value) {
        TaskUtil.addOrUpdateWorkflowJobUserContentMap(manager.getHelixPropertyStore(), workflowJobResource, Collections.singletonMap(key, value));
    }

    static void addOrUpdateWorkflowJobUserContentMap(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource, final Map<String, String> contentToAddOrUpdate) {
        if (workflowJobResource == null) {
            throw new IllegalArgumentException("workflowJobResource must be not null when adding workflow / job user content");
        }
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[]{USER_CONTENT_NODE});
        if (!propertyStore.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord znRecord) {
                if (znRecord == null) {
                    znRecord = new ZNRecord(new ZNRecord(TaskUtil.USER_CONTENT_NODE));
                }
                znRecord.getSimpleFields().putAll(contentToAddOrUpdate);
                return znRecord;
            }
        }, AccessOption.PERSISTENT)) {
            LOG.error("Failed to update the UserContentStore for {}", (Object)workflowJobResource);
        }
    }

    protected static String getTaskUserContent(HelixPropertyStore<ZNRecord> propertyStore, String job, String task, String key) {
        Map<String, String> userContentStore = TaskUtil.getTaskUserContentMap(propertyStore, job, task);
        return userContentStore != null ? userContentStore.get(key) : null;
    }

    protected static Map<String, String> getTaskUserContentMap(HelixPropertyStore<ZNRecord> propertyStore, String namespacedJobName, String taskPartitionId) {
        ZNRecord record = (ZNRecord)propertyStore.get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)namespacedJobName, new Object[]{USER_CONTENT_NODE}), null, AccessOption.PERSISTENT);
        return record != null ? record.getMapField(taskPartitionId) : null;
    }

    protected static void addTaskUserContent(HelixManager manager, String job, String task, String key, String value) {
        TaskUtil.addOrUpdateTaskUserContentMap(manager.getHelixPropertyStore(), job, task, Collections.singletonMap(key, value));
    }

    static void addOrUpdateTaskUserContentMap(HelixPropertyStore<ZNRecord> propertyStore, String job, final String task, final Map<String, String> contentToAddOrUpdate) {
        if (job == null || task == null) {
            throw new IllegalArgumentException("job and task must be not null when adding task user content");
        }
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)job, new Object[]{USER_CONTENT_NODE});
        if (!propertyStore.update(path, new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord znRecord) {
                if (znRecord == null) {
                    znRecord = new ZNRecord(new ZNRecord(TaskUtil.USER_CONTENT_NODE));
                }
                if (znRecord.getMapField(task) == null) {
                    znRecord.setMapField(task, new HashMap<String, String>());
                }
                znRecord.getMapField(task).putAll(contentToAddOrUpdate);
                return znRecord;
            }
        }, AccessOption.PERSISTENT)) {
            LOG.error("Failed to update the task UserContentStore for task {} in job {}", (Object)task, (Object)job);
        }
    }

    protected static String getUserContent(HelixPropertyStore propertyStore, String key, UserContentStore.Scope scope, String workflowName, String jobName, String taskName) {
        switch (scope) {
            case WORKFLOW: {
                return TaskUtil.getWorkflowJobUserContent(propertyStore, workflowName, key);
            }
            case JOB: {
                return TaskUtil.getWorkflowJobUserContent(propertyStore, jobName, key);
            }
            case TASK: {
                return TaskUtil.getTaskUserContent(propertyStore, jobName, taskName, key);
            }
        }
        throw new HelixException("Invalid scope : " + scope.name());
    }

    public static String getNamespacedJobName(String singleJobWorkflow) {
        return TaskUtil.getNamespacedJobName(singleJobWorkflow, singleJobWorkflow);
    }

    public static String getNamespacedJobName(String workflow, String jobName) {
        return workflow + "_" + jobName;
    }

    public static String getNamespacedTaskName(String namespacedJobName, String taskPartitionId) {
        return String.format("%s_%s", namespacedJobName, taskPartitionId);
    }

    public static String getDenamespacedJobName(String workflow, String jobName) {
        if (jobName.contains(workflow)) {
            return jobName.substring(jobName.indexOf(workflow) + workflow.length() + 1);
        }
        return jobName;
    }

    @Deprecated
    public static String serializeJobCommandConfigMap(Map<String, String> commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String serializedMap = mapper.writeValueAsString(commandConfig);
            return serializedMap;
        }
        catch (IOException e) {
            LOG.error("Error serializing " + commandConfig, (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static Map<String, String> deserializeJobCommandConfigMap(String commandConfig) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map commandConfigMap = (Map)mapper.readValue(commandConfig, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            return commandConfigMap;
        }
        catch (IOException e) {
            LOG.error("Error deserializing " + commandConfig, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static int getPartitionId(String pName) {
        int index = pName.lastIndexOf("_");
        if (index == -1) {
            throw new HelixException(String.format("Invalid partition name %s", pName));
        }
        return Integer.valueOf(pName.substring(index + 1));
    }

    @Deprecated
    public static String getWorkflowContextKey(String workflow) {
        return Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[0]);
    }

    @Deprecated
    public static PropertyKey getWorkflowConfigKey(HelixDataAccessor accessor, String workflow) {
        return accessor.keyBuilder().resourceConfig(workflow);
    }

    protected static boolean cleanupJobIdealStateExtView(HelixDataAccessor accessor, String job) {
        return TaskUtil.cleanupIdealStateExtView(accessor, job);
    }

    protected static boolean cleanupWorkflowIdealStateExtView(HelixDataAccessor accessor, String workflow) {
        return TaskUtil.cleanupIdealStateExtView(accessor, workflow);
    }

    private static boolean cleanupIdealStateExtView(HelixDataAccessor accessor, String workflowJobResource) {
        PropertyKey evKey;
        boolean success = true;
        PropertyKey isKey = accessor.keyBuilder().idealStates(workflowJobResource);
        if (accessor.getPropertyStat(isKey) != null && !accessor.removeProperty(isKey)) {
            LOG.warn(String.format("Error occurred while trying to remove IdealState for %s. Failed to remove node %s.", workflowJobResource, isKey));
            success = false;
        }
        if (accessor.getPropertyStat(evKey = accessor.keyBuilder().externalView(workflowJobResource)) != null && !accessor.removeProperty(evKey)) {
            LOG.warn(String.format("Error occurred while trying to remove ExternalView of resource %s. Failed to remove node %s.", workflowJobResource, evKey));
            success = false;
        }
        return success;
    }

    protected static boolean removeWorkflow(HelixDataAccessor accessor, HelixPropertyStore<ZNRecord> propertyStore, String workflow, Set<String> jobs) {
        for (String job : jobs) {
            if (TaskUtil.removeJob(accessor, propertyStore, job)) continue;
            return false;
        }
        if (!TaskUtil.removeWorkflowConfig(accessor, workflow)) {
            LOG.warn(String.format("Error occurred while trying to remove workflow config for %s.", workflow));
            return false;
        }
        if (!TaskUtil.cleanupWorkflowIdealStateExtView(accessor, workflow)) {
            LOG.warn(String.format("Error occurred while trying to remove workflow idealstate/externalview for %s.", workflow));
            return false;
        }
        if (!TaskUtil.removeWorkflowContext(propertyStore, workflow)) {
            LOG.warn(String.format("Error occurred while trying to remove workflow context for %s.", workflow));
            return false;
        }
        return true;
    }

    protected static boolean removeJobsFromWorkflow(HelixDataAccessor dataAccessor, HelixPropertyStore<ZNRecord> propertyStore, String workflow, Set<String> jobs, boolean maintainDependency) {
        boolean success = true;
        if (!TaskUtil.removeJobsFromDag(dataAccessor, workflow, jobs, maintainDependency)) {
            LOG.warn("Error occurred while trying to remove jobs + " + jobs + " from the workflow " + workflow);
            success = false;
        }
        if (!TaskUtil.removeJobsState(propertyStore, workflow, jobs)) {
            LOG.warn("Error occurred while trying to remove jobs states from workflow + " + workflow + " jobs " + jobs);
            success = false;
        }
        for (String job : jobs) {
            if (TaskUtil.removeJob(dataAccessor, propertyStore, job)) continue;
            success = false;
        }
        return success;
    }

    protected static Set<String> getExpiredJobs(HelixDataAccessor dataAccessor, HelixPropertyStore<ZNRecord> propertyStore, WorkflowConfig workflowConfig, WorkflowContext workflowContext) {
        HashSet<String> expiredJobs = new HashSet<String>();
        if (workflowContext != null) {
            Map<String, TaskState> jobStates = workflowContext.getJobStates();
            for (String job : workflowConfig.getJobDag().getAllNodes()) {
                JobConfig jobConfig = TaskUtil.getJobConfig(dataAccessor, job);
                JobContext jobContext = TaskUtil.getJobContext(propertyStore, job);
                if (jobConfig == null) {
                    LOG.error(String.format("Job %s exists in JobDAG but JobConfig is missing! Job might have been deleted manually from the JobQueue: %s, or left in the DAG due to a failed clean-up attempt from last purge.", job, workflowConfig.getWorkflowId()));
                    expiredJobs.add(job);
                    continue;
                }
                long expiry = jobConfig.getExpiry();
                if (jobContext == null || jobStates.get(job) != TaskState.COMPLETED || jobContext.getFinishTime() == -1L || System.currentTimeMillis() < jobContext.getFinishTime() + expiry) continue;
                expiredJobs.add(job);
            }
        }
        return expiredJobs;
    }

    protected static boolean removeJob(HelixDataAccessor accessor, HelixPropertyStore<ZNRecord> propertyStore, String job) {
        if (!TaskUtil.removeJobConfig(accessor, job)) {
            LOG.warn(String.format("Error occurred while trying to remove job config for %s.", job));
            return false;
        }
        if (!TaskUtil.cleanupJobIdealStateExtView(accessor, job)) {
            LOG.warn(String.format("Error occurred while trying to remove job idealstate/externalview for %s.", job));
            return false;
        }
        if (!TaskUtil.removeJobContext(propertyStore, job)) {
            LOG.warn(String.format("Error occurred while trying to remove job context for %s.", job));
            return false;
        }
        return true;
    }

    protected static boolean removeJobsFromDag(HelixDataAccessor accessor, final String workflow, final Set<String> jobsToRemove, final boolean maintainDependency) {
        DataUpdater<ZNRecord> dagRemover = new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    JobDag jobDag = JobDag.fromJson(currentData.getSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name()));
                    if (jobDag == null) {
                        LOG.warn("Could not update DAG for workflow: " + workflow + " JobDag is null.");
                        return null;
                    }
                    for (String job : jobsToRemove) {
                        jobDag.removeNode(job, maintainDependency);
                    }
                    try {
                        currentData.setSimpleField(WorkflowConfig.WorkflowConfigProperty.Dag.name(), jobDag.toJson());
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return currentData;
            }
        };
        String configPath = accessor.keyBuilder().resourceConfig(workflow).getPath();
        if (!accessor.getBaseDataAccessor().update(configPath, dagRemover, AccessOption.PERSISTENT)) {
            LOG.warn("Failed to remove jobs " + jobsToRemove + " from DAG of workflow " + workflow);
            return false;
        }
        return true;
    }

    protected static boolean removeJobsState(HelixPropertyStore<ZNRecord> propertyStore, String workflow, final Set<String> jobs) {
        String contextPath = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflow, new Object[]{CONTEXT_NODE});
        if (!propertyStore.exists(contextPath, 0)) {
            return true;
        }
        DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

            @Override
            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    WorkflowContext workflowContext = new WorkflowContext(currentData);
                    workflowContext.removeJobStates(jobs);
                    workflowContext.removeJobStartTime(jobs);
                    currentData = workflowContext.getRecord();
                }
                return currentData;
            }
        };
        if (!propertyStore.update(contextPath, updater, AccessOption.PERSISTENT)) {
            LOG.warn("Fail to remove job state for jobs " + jobs + " from workflow " + workflow);
            return false;
        }
        return true;
    }

    private static boolean removeWorkflowJobContext(HelixPropertyStore<ZNRecord> propertyStore, String workflowJobResource) {
        String path = Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)workflowJobResource, new Object[0]);
        if (propertyStore.exists(path, AccessOption.PERSISTENT) && !propertyStore.remove(path, AccessOption.PERSISTENT)) {
            LOG.warn(String.format("Error occurred while trying to remove workflow/jobcontext for %s. Failed to remove node %s.", workflowJobResource, path));
            return false;
        }
        return true;
    }

    private static boolean removeWorkflowJobConfig(HelixDataAccessor accessor, String workflowJobResource) {
        PropertyKey cfgKey = accessor.keyBuilder().resourceConfig(workflowJobResource);
        if (accessor.getPropertyStat(cfgKey) != null && !accessor.removeProperty(cfgKey)) {
            LOG.warn(String.format("Error occurred while trying to remove config for %s. Failed to remove node %s.", workflowJobResource, cfgKey));
            return false;
        }
        return true;
    }

    private static boolean createResourceConfig(HelixDataAccessor accessor, String resource, ResourceConfig resourceConfig) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.getBaseDataAccessor().create(keyBuilder.resourceConfig(resource).getPath(), resourceConfig.getRecord(), AccessOption.PERSISTENT);
    }

    private static boolean setResourceConfig(HelixDataAccessor accessor, String resource, ResourceConfig resourceConfig) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.setProperty(keyBuilder.resourceConfig(resource), resourceConfig);
    }

    private static HelixProperty getResourceConfig(HelixDataAccessor accessor, String resource) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return accessor.getProperty(keyBuilder.resourceConfig(resource));
    }

    public static Set<Integer> getNonReadyPartitions(JobContext ctx, long now) {
        HashSet nonReadyPartitions = Sets.newHashSet();
        for (int p : ctx.getPartitionSet()) {
            long toStart = ctx.getNextRetryTime(p);
            if (now >= toStart) continue;
            nonReadyPartitions.add(p);
        }
        return nonReadyPartitions;
    }

    public static boolean isGenericTaskJob(JobConfig jobConfig) {
        return jobConfig.getTargetResource() == null || jobConfig.getTargetResource().equals("");
    }

    public static boolean checkJobStopped(JobContext jobContext) {
        for (int partition : jobContext.getPartitionSet()) {
            TaskPartitionState taskState = jobContext.getPartitionState(partition);
            if (taskState != TaskPartitionState.RUNNING) continue;
            return false;
        }
        return true;
    }

    public static int getInCompleteJobCount(WorkflowConfig workflowCfg, WorkflowContext workflowCtx) {
        int inCompleteCount = 0;
        for (String jobName : workflowCfg.getJobDag().getAllNodes()) {
            TaskState jobState = workflowCtx.getJobState(jobName);
            if (jobState != TaskState.IN_PROGRESS && jobState != TaskState.STOPPED && jobState != TaskState.STOPPING) continue;
            ++inCompleteCount;
        }
        return inCompleteCount;
    }

    public static boolean isJobStarted(String job, WorkflowContext workflowContext) {
        TaskState jobState = workflowContext.getJobState(job);
        return jobState != null && jobState != TaskState.NOT_STARTED;
    }

    public static void purgeExpiredJobs(String workflow, WorkflowConfig workflowConfig, WorkflowContext workflowContext, HelixManager manager, RebalanceScheduler rebalanceScheduler) {
        if (workflowContext == null) {
            LOG.warn(String.format("Workflow %s context does not exist!", workflow));
            return;
        }
        long purgeInterval = workflowConfig.getJobPurgeInterval();
        long currentTime = System.currentTimeMillis();
        HashSet expiredJobs = Sets.newHashSet();
        if (purgeInterval > 0L && workflowContext.getLastJobPurgeTime() + purgeInterval <= currentTime) {
            expiredJobs.addAll(TaskUtil.getExpiredJobs(manager.getHelixDataAccessor(), manager.getHelixPropertyStore(), workflowConfig, workflowContext));
            if (expiredJobs.isEmpty()) {
                LOG.info("No job to purge for the queue " + workflow);
            } else {
                LOG.info("Purge jobs " + expiredJobs + " from queue " + workflow);
                HashSet<String> failedJobRemovals = new HashSet<String>();
                for (String job : expiredJobs) {
                    if (!TaskUtil.removeJob(manager.getHelixDataAccessor(), manager.getHelixPropertyStore(), job)) {
                        failedJobRemovals.add(job);
                        LOG.warn("Failed to clean up expired and completed jobs from workflow " + workflow);
                    }
                    rebalanceScheduler.removeScheduledRebalance(job);
                }
                expiredJobs.removeAll(failedJobRemovals);
                if (!TaskUtil.removeJobsFromDag(manager.getHelixDataAccessor(), workflow, expiredJobs, true)) {
                    LOG.warn("Error occurred while trying to remove jobs + " + expiredJobs + " from the workflow " + workflow);
                }
                if (expiredJobs.size() > 0) {
                    HelixDataAccessor accessor = manager.getHelixDataAccessor();
                    List<String> resourceConfigs = accessor.getChildNames(accessor.keyBuilder().resourceConfigs());
                    if (resourceConfigs.size() > 0) {
                        RebalanceUtil.scheduleOnDemandPipeline(manager.getClusterName(), 0L);
                    } else {
                        LOG.warn("No resource config to trigger rebalance for clean up contexts for" + expiredJobs);
                    }
                }
            }
        }
        TaskUtil.setNextJobPurgeTime(workflow, currentTime, purgeInterval, rebalanceScheduler, manager);
    }

    private static void setNextJobPurgeTime(String workflow, long currentTime, long purgeInterval, RebalanceScheduler rebalanceScheduler, HelixManager manager) {
        long nextPurgeTime = currentTime + purgeInterval;
        long currentScheduledTime = rebalanceScheduler.getRebalanceTime(workflow);
        if (currentScheduledTime == -1L || currentScheduledTime > nextPurgeTime) {
            rebalanceScheduler.scheduleRebalance(manager, workflow, nextPurgeTime);
        }
    }
}

