/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class ResourceMonitor
extends DynamicMBeanProvider {
    private static final String GAUGE_METRIC_SUFFIX = "Gauge";
    private SimpleDynamicMetric<Long> _numOfPartitions;
    private SimpleDynamicMetric<Long> _numOfPartitionsInExternalView;
    private SimpleDynamicMetric<Long> _numOfErrorPartitions;
    private SimpleDynamicMetric<Long> _numNonTopStatePartitions;
    private SimpleDynamicMetric<Long> _externalViewIdealStateDiff;
    private SimpleDynamicMetric<Long> _numLessMinActiveReplicaPartitions;
    private SimpleDynamicMetric<Long> _numLessReplicaPartitions;
    private SimpleDynamicMetric<Long> _numPendingRecoveryRebalancePartitions;
    private SimpleDynamicMetric<Long> _numPendingLoadRebalancePartitions;
    private SimpleDynamicMetric<Long> _numRecoveryRebalanceThrottledPartitions;
    private SimpleDynamicMetric<Long> _numLoadRebalanceThrottledPartitions;
    private SimpleDynamicMetric<Long> _numPendingStateTransitions;
    private SimpleDynamicMetric<Long> _successfulTopStateHandoffDurationCounter;
    private SimpleDynamicMetric<Long> _successTopStateHandoffCounter;
    private SimpleDynamicMetric<Long> _failedTopStateHandoffCounter;
    private SimpleDynamicMetric<Long> _maxSinglePartitionTopStateHandoffDuration;
    private SimpleDynamicMetric<Long> _totalMessageReceived;
    private HistogramDynamicMetric _partitionTopStateHandoffDurationGauge;
    private HistogramDynamicMetric _partitionTopStateHandoffHelixLatencyGauge;
    private HistogramDynamicMetric _partitionTopStateNonGracefulHandoffDurationGauge;
    private SimpleDynamicMetric<String> _rebalanceState;
    private String _tag = "DEFAULT";
    private long _lastResetTime;
    private final String _resourceName;
    private final String _clusterName;
    private final ObjectName _initObjectName;
    private final Map<String, SimpleDynamicMetric<Long>> _dynamicCapacityMetricsMap;

    @Override
    public DynamicMBeanProvider register() throws JMException {
        this.doRegister(this.buildAttributeList(), this._initObjectName);
        return this;
    }

    public ResourceMonitor(String clusterName, String resourceName, ObjectName objectName) throws JMException {
        this._clusterName = clusterName;
        this._resourceName = resourceName;
        this._initObjectName = objectName;
        this._dynamicCapacityMetricsMap = new ConcurrentHashMap<String, SimpleDynamicMetric<Long>>();
        this._externalViewIdealStateDiff = new SimpleDynamicMetric<Long>("DifferenceWithIdealStateGauge", 0L);
        this._numLoadRebalanceThrottledPartitions = new SimpleDynamicMetric<Long>("LoadRebalanceThrottledPartitionGauge", 0L);
        this._numRecoveryRebalanceThrottledPartitions = new SimpleDynamicMetric<Long>("RecoveryRebalanceThrottledPartitionGauge", 0L);
        this._numPendingLoadRebalancePartitions = new SimpleDynamicMetric<Long>("PendingLoadRebalancePartitionGauge", 0L);
        this._numPendingRecoveryRebalancePartitions = new SimpleDynamicMetric<Long>("PendingRecoveryRebalancePartitionGauge", 0L);
        this._numLessReplicaPartitions = new SimpleDynamicMetric<Long>("MissingReplicaPartitionGauge", 0L);
        this._numLessMinActiveReplicaPartitions = new SimpleDynamicMetric<Long>("MissingMinActiveReplicaPartitionGauge", 0L);
        this._numNonTopStatePartitions = new SimpleDynamicMetric<Long>("MissingTopStatePartitionGauge", 0L);
        this._numOfErrorPartitions = new SimpleDynamicMetric<Long>("ErrorPartitionGauge", 0L);
        this._numOfPartitionsInExternalView = new SimpleDynamicMetric<Long>("ExternalViewPartitionGauge", 0L);
        this._numOfPartitions = new SimpleDynamicMetric<Long>("PartitionGauge", 0L);
        this._numPendingStateTransitions = new SimpleDynamicMetric<Long>("PendingStateTransitionGauge", 0L);
        this._partitionTopStateHandoffDurationGauge = new HistogramDynamicMetric("PartitionTopStateHandoffDurationGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._partitionTopStateHandoffHelixLatencyGauge = new HistogramDynamicMetric("PartitionTopStateHandoffHelixLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._partitionTopStateNonGracefulHandoffDurationGauge = new HistogramDynamicMetric("PartitionTopStateNonGracefulHandoffGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._totalMessageReceived = new SimpleDynamicMetric<Long>("TotalMessageReceived", 0L);
        this._maxSinglePartitionTopStateHandoffDuration = new SimpleDynamicMetric<Long>("MaxSinglePartitionTopStateHandoffDurationGauge", 0L);
        this._failedTopStateHandoffCounter = new SimpleDynamicMetric<Long>("FailedTopStateHandoffCounter", 0L);
        this._successTopStateHandoffCounter = new SimpleDynamicMetric<Long>("SucceededTopStateHandoffCounter", 0L);
        this._successfulTopStateHandoffDurationCounter = new SimpleDynamicMetric<Long>("SuccessfulTopStateHandoffDurationCounter", 0L);
        this._rebalanceState = new SimpleDynamicMetric<String>("RebalanceStatus", RebalanceStatus.UNKNOWN.name());
    }

    @Override
    public String getSensorName() {
        return String.format("%s.%s.%s.%s", "ResourceStatus", this._clusterName, this._tag, this._resourceName);
    }

    public long getPartitionGauge() {
        return this._numOfPartitions.getValue();
    }

    public long getErrorPartitionGauge() {
        return this._numOfErrorPartitions.getValue();
    }

    public long getMissingTopStatePartitionGauge() {
        return this._numNonTopStatePartitions.getValue();
    }

    public long getDifferenceWithIdealStateGauge() {
        return this._externalViewIdealStateDiff.getValue();
    }

    public long getSuccessfulTopStateHandoffDurationCounter() {
        return this._successfulTopStateHandoffDurationCounter.getValue();
    }

    public long getSucceededTopStateHandoffCounter() {
        return this._successTopStateHandoffCounter.getValue();
    }

    public long getMaxSinglePartitionTopStateHandoffDurationGauge() {
        return this._maxSinglePartitionTopStateHandoffDuration.getValue();
    }

    public HistogramDynamicMetric getPartitionTopStateHandoffDurationGauge() {
        return this._partitionTopStateHandoffDurationGauge;
    }

    public HistogramDynamicMetric getPartitionTopStateNonGracefulHandoffDurationGauge() {
        return this._partitionTopStateNonGracefulHandoffDurationGauge;
    }

    public HistogramDynamicMetric getPartitionTopStateHandoffHelixLatencyGauge() {
        return this._partitionTopStateHandoffHelixLatencyGauge;
    }

    public long getFailedTopStateHandoffCounter() {
        return this._failedTopStateHandoffCounter.getValue();
    }

    public long getTotalMessageReceived() {
        return this._totalMessageReceived.getValue();
    }

    public synchronized void increaseMessageCount(long messageReceived) {
        this._totalMessageReceived.updateValue(this._totalMessageReceived.getValue() + messageReceived);
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public String getBeanName() {
        return this._clusterName + " " + this._resourceName;
    }

    public void updateResourceState(ExternalView externalView, IdealState idealState, StateModelDefinition stateModelDef) {
        int replica;
        List<String> priorityList;
        if (externalView == null) {
            this._logger.warn("External view is null");
            return;
        }
        String topState = null;
        if (stateModelDef != null && !(priorityList = stateModelDef.getStatesPriorityList()).isEmpty()) {
            topState = priorityList.get(0);
        }
        this.resetResourceStateGauges();
        if (idealState == null) {
            this._logger.warn("ideal state is null for {}", (Object)this._resourceName);
            return;
        }
        assert (this._resourceName.equals(idealState.getId()));
        assert (this._resourceName.equals(externalView.getId()));
        long numOfErrorPartitions = 0L;
        long numOfDiff = 0L;
        long numOfPartitionWithTopState = 0L;
        Set<String> partitions = idealState.getPartitionSet();
        try {
            replica = Integer.valueOf(idealState.getReplicas());
        }
        catch (NumberFormatException e) {
            this._logger.info("Unspecified replica count for {}, skip updating the ResourceMonitor Mbean: {}", (Object)this._resourceName, (Object)idealState.getReplicas());
            return;
        }
        catch (Exception ex) {
            this._logger.warn("Failed to get replica count for {}, cannot update the ResourceMonitor Mbean.", (Object)this._resourceName);
            return;
        }
        int minActiveReplica = idealState.getMinActiveReplicas();
        minActiveReplica = minActiveReplica >= 0 ? minActiveReplica : replica;
        HashSet<String> activeStates = new HashSet<String>(stateModelDef.getStatesPriorityList());
        activeStates.remove(stateModelDef.getInitialState());
        activeStates.remove(HelixDefinedState.DROPPED.name());
        activeStates.remove(HelixDefinedState.ERROR.name());
        for (String partition : partitions) {
            Map<String, String> idealRecord = idealState.getInstanceStateMap(partition);
            Map<String, String> externalViewRecord = externalView.getStateMap(partition);
            if (idealRecord == null) {
                idealRecord = Collections.emptyMap();
            }
            if (externalViewRecord == null) {
                externalViewRecord = Collections.emptyMap();
            }
            if (!idealRecord.entrySet().equals(externalViewRecord.entrySet())) {
                ++numOfDiff;
            }
            int activeReplicaCount = 0;
            boolean hasTopState = false;
            for (String host : externalViewRecord.keySet()) {
                String currentState = externalViewRecord.get(host);
                if (HelixDefinedState.ERROR.toString().equalsIgnoreCase(currentState)) {
                    ++numOfErrorPartitions;
                }
                if (topState != null && topState.equalsIgnoreCase(currentState)) {
                    hasTopState = true;
                }
                if (currentState == null || !activeStates.contains(currentState)) continue;
                ++activeReplicaCount;
            }
            if (hasTopState) {
                ++numOfPartitionWithTopState;
            }
            if (replica > 0 && activeReplicaCount < replica) {
                this._numLessReplicaPartitions.updateValue(this._numLessReplicaPartitions.getValue() + 1L);
            }
            if (minActiveReplica < 0 || activeReplicaCount >= minActiveReplica) continue;
            this._numLessMinActiveReplicaPartitions.updateValue(this._numLessMinActiveReplicaPartitions.getValue() + 1L);
        }
        this._numOfPartitions.updateValue(Long.valueOf(partitions.size()));
        this._numOfErrorPartitions.updateValue(numOfErrorPartitions);
        this._externalViewIdealStateDiff.updateValue(numOfDiff);
        this._numOfPartitionsInExternalView.updateValue(Long.valueOf(externalView.getPartitionSet().size()));
        this._numNonTopStatePartitions.updateValue(this._numOfPartitions.getValue() - numOfPartitionWithTopState);
        String tag = idealState.getInstanceGroupTag();
        this._tag = tag == null || tag.equals("") || tag.equals("null") ? "DEFAULT" : tag;
    }

    private void resetResourceStateGauges() {
        this._numOfErrorPartitions.updateValue(0L);
        this._numNonTopStatePartitions.updateValue(0L);
        this._externalViewIdealStateDiff.updateValue(0L);
        this._numOfPartitionsInExternalView.updateValue(0L);
        this._numLessMinActiveReplicaPartitions.updateValue(0L);
        this._numLessReplicaPartitions.updateValue(0L);
    }

    public void updatePendingStateTransitionMessages(int messageCount) {
        this._numPendingStateTransitions.updateValue(Long.valueOf(messageCount));
    }

    public void updateStateHandoffStats(MonitorState monitorState, long totalDuration, long helixLatency, boolean isGraceful, boolean succeeded) {
        switch (monitorState) {
            case TOP_STATE: {
                if (succeeded) {
                    this._successTopStateHandoffCounter.updateValue(this._successTopStateHandoffCounter.getValue() + 1L);
                    this._successfulTopStateHandoffDurationCounter.updateValue(this._successfulTopStateHandoffDurationCounter.getValue() + totalDuration);
                    if (isGraceful) {
                        this._partitionTopStateHandoffDurationGauge.updateValue(totalDuration);
                        this._partitionTopStateHandoffHelixLatencyGauge.updateValue(helixLatency);
                    } else {
                        this._partitionTopStateNonGracefulHandoffDurationGauge.updateValue(totalDuration);
                    }
                    if (totalDuration <= this._maxSinglePartitionTopStateHandoffDuration.getValue()) break;
                    this._maxSinglePartitionTopStateHandoffDuration.updateValue(totalDuration);
                    this._lastResetTime = System.currentTimeMillis();
                    break;
                }
                this._failedTopStateHandoffCounter.updateValue(this._failedTopStateHandoffCounter.getValue() + 1L);
                break;
            }
            default: {
                this._logger.warn(String.format("Wrong monitor state \"%s\" that not supported ", monitorState.name()));
            }
        }
    }

    public void updateRebalancerStats(long numPendingRecoveryRebalancePartitions, long numPendingLoadRebalancePartitions, long numRecoveryRebalanceThrottledPartitions, long numLoadRebalanceThrottledPartitions) {
        this._numPendingRecoveryRebalancePartitions.updateValue(numPendingRecoveryRebalancePartitions);
        this._numPendingLoadRebalancePartitions.updateValue(numPendingLoadRebalancePartitions);
        this._numRecoveryRebalanceThrottledPartitions.updateValue(numRecoveryRebalanceThrottledPartitions);
        this._numLoadRebalanceThrottledPartitions.updateValue(numLoadRebalanceThrottledPartitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePartitionWeightStats(Map<String, Integer> partitionWeightMap) {
        Map<String, SimpleDynamicMetric<Long>> map = this._dynamicCapacityMetricsMap;
        synchronized (map) {
            if (this._dynamicCapacityMetricsMap.keySet().equals(partitionWeightMap.keySet())) {
                for (Map.Entry<String, Integer> entry : partitionWeightMap.entrySet()) {
                    this._dynamicCapacityMetricsMap.get(entry.getKey()).updateValue((long)entry.getValue());
                }
                return;
            }
            this._dynamicCapacityMetricsMap.clear();
            for (Map.Entry<String, Integer> entry : partitionWeightMap.entrySet()) {
                String capacityKey = entry.getKey();
                this._dynamicCapacityMetricsMap.put(capacityKey, new SimpleDynamicMetric<Long>(capacityKey + GAUGE_METRIC_SUFFIX, Long.valueOf(entry.getValue().intValue())));
            }
        }
        this.updateAttributesInfo(this.buildAttributeList(), "Resource monitor for resource: " + this.getResourceName());
    }

    public void setRebalanceState(RebalanceStatus state) {
        this._rebalanceState.updateValue(state.name());
    }

    public long getExternalViewPartitionGauge() {
        return this._numOfPartitionsInExternalView.getValue();
    }

    public long getMissingMinActiveReplicaPartitionGauge() {
        return this._numLessMinActiveReplicaPartitions.getValue();
    }

    public long getMissingReplicaPartitionGauge() {
        return this._numLessReplicaPartitions.getValue();
    }

    public long getPendingRecoveryRebalancePartitionGauge() {
        return this._numPendingRecoveryRebalancePartitions.getValue();
    }

    public long getPendingLoadRebalancePartitionGauge() {
        return this._numPendingLoadRebalancePartitions.getValue();
    }

    public long getRecoveryRebalanceThrottledPartitionGauge() {
        return this._numRecoveryRebalanceThrottledPartitions.getValue();
    }

    public long getLoadRebalanceThrottledPartitionGauge() {
        return this._numLoadRebalanceThrottledPartitions.getValue();
    }

    public long getNumPendingStateTransitionGauge() {
        return this._numPendingStateTransitions.getValue();
    }

    public String getRebalanceState() {
        return this._rebalanceState.getValue();
    }

    public void resetMaxTopStateHandoffGauge() {
        if (this._lastResetTime + 3600000L <= System.currentTimeMillis()) {
            this._maxSinglePartitionTopStateHandoffDuration.updateValue(0L);
            this._lastResetTime = System.currentTimeMillis();
        }
    }

    private List<DynamicMetric<?, ?>> buildAttributeList() {
        ArrayList attributeList = Lists.newArrayList((Object[])new DynamicMetric[]{this._numOfPartitions, this._numOfPartitionsInExternalView, this._numOfErrorPartitions, this._numNonTopStatePartitions, this._numLessMinActiveReplicaPartitions, this._numLessReplicaPartitions, this._numPendingRecoveryRebalancePartitions, this._numPendingLoadRebalancePartitions, this._numRecoveryRebalanceThrottledPartitions, this._numLoadRebalanceThrottledPartitions, this._externalViewIdealStateDiff, this._successfulTopStateHandoffDurationCounter, this._successTopStateHandoffCounter, this._failedTopStateHandoffCounter, this._maxSinglePartitionTopStateHandoffDuration, this._partitionTopStateHandoffDurationGauge, this._partitionTopStateHandoffHelixLatencyGauge, this._partitionTopStateNonGracefulHandoffDurationGauge, this._totalMessageReceived, this._numPendingStateTransitions, this._rebalanceState});
        attributeList.addAll(this._dynamicCapacityMetricsMap.values());
        return attributeList;
    }

    public static enum MonitorState {
        TOP_STATE;

    }

    public static enum RebalanceStatus {
        UNKNOWN,
        NORMAL,
        BEST_POSSIBLE_STATE_CAL_FAILED,
        INTERMEDIATE_STATE_CAL_FAILED;

    }
}

