/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.CustomizedViewCache;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CustomizedStateOutput;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedViewAggregationStage
extends AbstractAsyncBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(CustomizedViewAggregationStage.class);

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.CustomizedStateViewComputeWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (manager == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires ClusterManager|RESOURCES|DataCache");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        CustomizedStateOutput customizedStateOutput = (CustomizedStateOutput)event.getAttribute(AttributeName.CUSTOMIZED_STATE.name());
        Map<String, CustomizedViewCache> customizedViewCacheMap = cache.getCustomizedViewCacheMap();
        HashSet<String> customizedTypesToRemove = new HashSet<String>();
        for (String stateType : customizedViewCacheMap.keySet()) {
            if (customizedStateOutput.getAllStateTypes().contains(stateType)) continue;
            LogUtil.logInfo(LOG, this._eventId, "Remove customizedView for stateType: " + stateType);
            dataAccessor.removeProperty(keyBuilder.customizedView(stateType));
            customizedTypesToRemove.add(stateType);
        }
        cache.removeCustomizedViewTypes(customizedTypesToRemove);
        for (String stateType : customizedStateOutput.getAllStateTypes()) {
            ArrayList<CustomizedView> updatedCustomizedViews = new ArrayList<CustomizedView>();
            HashMap<String, CustomizedView> curCustomizedViews = new HashMap();
            CustomizedViewCache customizedViewCache = customizedViewCacheMap.get(stateType);
            if (customizedViewCache != null) {
                curCustomizedViews = customizedViewCache.getCustomizedViewMap();
            }
            for (Resource resource : resourceMap.values()) {
                try {
                    this.computeCustomizedStateView(resource, stateType, customizedStateOutput, curCustomizedViews, updatedCustomizedViews);
                    ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
                    for (CustomizedView view : updatedCustomizedViews) {
                        String resourceName = view.getResourceName();
                        keys.add(keyBuilder.customizedView(stateType, resourceName));
                    }
                    if (updatedCustomizedViews.size() > 0) {
                        dataAccessor.setChildren(keys, updatedCustomizedViews);
                        cache.updateCustomizedViews(stateType, updatedCustomizedViews);
                    }
                    ArrayList<String> customizedViewToRemove = new ArrayList<String>();
                    for (String resourceName : curCustomizedViews.keySet()) {
                        if (resourceMap.keySet().contains(resourceName)) continue;
                        LogUtil.logInfo(LOG, this._eventId, "Remove customizedView for resource: " + resourceName);
                        dataAccessor.removeProperty(keyBuilder.customizedView(stateType, resourceName));
                        customizedViewToRemove.add(resourceName);
                    }
                    cache.removeCustomizedViews(stateType, customizedViewToRemove);
                }
                catch (HelixException ex) {
                    LogUtil.logError(LOG, this._eventId, "Failed to calculate customized view for resource " + resource.getResourceName(), ex);
                }
            }
        }
    }

    private void computeCustomizedStateView(Resource resource, String stateType, CustomizedStateOutput customizedStateOutput, Map<String, CustomizedView> curCustomizedViews, List<CustomizedView> updatedCustomizedViews) {
        String resourceName = resource.getResourceName();
        CustomizedView view = new CustomizedView(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> customizedStateMap = customizedStateOutput.getPartitionCustomizedStateMap(stateType, resourceName, partition);
            if (customizedStateMap == null || customizedStateMap.size() <= 0) continue;
            for (String instance : customizedStateMap.keySet()) {
                view.setState(partition.getPartitionName(), instance, customizedStateMap.get(instance));
            }
        }
        CustomizedView curCustomizedView = curCustomizedViews.get(resourceName);
        if (curCustomizedView == null || !curCustomizedView.getRecord().equals(view.getRecord())) {
            updatedCustomizedViews.add(view);
        }
    }
}

