/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.constraints.SoftConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.OptimalAssignment;
import org.apache.helix.model.ResourceAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConstraintBasedAlgorithm
implements RebalanceAlgorithm {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintBasedAlgorithm.class);
    private final List<HardConstraint> _hardConstraints;
    private final Map<SoftConstraint, Float> _softConstraints;

    ConstraintBasedAlgorithm(List<HardConstraint> hardConstraints, Map<SoftConstraint, Float> softConstraints) {
        this._hardConstraints = hardConstraints;
        this._softConstraints = softConstraints;
    }

    @Override
    public OptimalAssignment calculate(ClusterModel clusterModel) throws HelixRebalanceException {
        OptimalAssignment optimalAssignment = new OptimalAssignment();
        ArrayList<AssignableNode> nodes = new ArrayList<AssignableNode>(clusterModel.getAssignableNodes().values());
        Set<String> busyInstances = this.getBusyInstances(clusterModel.getContext().getBestPossibleAssignment().values());
        for (AssignableReplica replica : this.getOrderedAssignableReplica(clusterModel)) {
            Optional<AssignableNode> maybeBestNode = this.getNodeWithHighestPoints(replica, nodes, clusterModel.getContext(), busyInstances, optimalAssignment);
            if (optimalAssignment.hasAnyFailure()) {
                String errorMessage = String.format("Unable to find any available candidate node for partition %s; Fail reasons: %s", replica.getPartitionName(), optimalAssignment.getFailures());
                throw new HelixRebalanceException(errorMessage, HelixRebalanceException.Type.FAILED_TO_CALCULATE);
            }
            maybeBestNode.ifPresent(node -> clusterModel.assign(replica.getResourceName(), replica.getPartitionName(), replica.getReplicaState(), node.getInstanceName()));
        }
        optimalAssignment.updateAssignments(clusterModel);
        return optimalAssignment;
    }

    private Optional<AssignableNode> getNodeWithHighestPoints(AssignableReplica replica, List<AssignableNode> assignableNodes, ClusterContext clusterContext, Set<String> busyInstances, OptimalAssignment optimalAssignment) {
        ConcurrentHashMap hardConstraintFailures = new ConcurrentHashMap();
        List candidateNodes = assignableNodes.parallelStream().filter(candidateNode -> {
            boolean isValid = true;
            for (HardConstraint hardConstraint : this._hardConstraints) {
                if (hardConstraint.isAssignmentValid((AssignableNode)candidateNode, replica, clusterContext)) continue;
                hardConstraintFailures.computeIfAbsent(candidateNode, node -> new ArrayList()).add(hardConstraint);
                isValid = false;
            }
            return isValid;
        }).collect(Collectors.toList());
        if (candidateNodes.isEmpty()) {
            optimalAssignment.recordAssignmentFailure(replica, Maps.transformValues(hardConstraintFailures, this::convertFailureReasons));
            return Optional.empty();
        }
        return candidateNodes.parallelStream().map(node -> new AbstractMap.SimpleEntry<AssignableNode, Double>((AssignableNode)node, this.getAssignmentNormalizedScore((AssignableNode)node, replica, clusterContext))).max((nodeEntry1, nodeEntry2) -> {
            int scoreCompareResult = ((Double)nodeEntry1.getValue()).compareTo((Double)nodeEntry2.getValue());
            if (scoreCompareResult == 0) {
                String instanceName1 = ((AssignableNode)nodeEntry1.getKey()).getInstanceName();
                String instanceName2 = ((AssignableNode)nodeEntry2.getKey()).getInstanceName();
                int idleScore1 = busyInstances.contains(instanceName1) ? 0 : 1;
                int idleScore2 = busyInstances.contains(instanceName2) ? 0 : 1;
                return idleScore1 != idleScore2 ? idleScore1 - idleScore2 : -instanceName1.compareTo(instanceName2);
            }
            return scoreCompareResult;
        }).map(Map.Entry::getKey);
    }

    private double getAssignmentNormalizedScore(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        double sum = 0.0;
        for (Map.Entry<SoftConstraint, Float> softConstraintEntry : this._softConstraints.entrySet()) {
            SoftConstraint softConstraint = softConstraintEntry.getKey();
            float weight = softConstraintEntry.getValue().floatValue();
            if (weight == 0.0f) continue;
            sum += (double)weight * softConstraint.getAssignmentNormalizedScore(node, replica, clusterContext);
        }
        return sum;
    }

    private List<String> convertFailureReasons(List<HardConstraint> hardConstraints) {
        return hardConstraints.stream().map(HardConstraint::getDescription).collect(Collectors.toList());
    }

    private List<AssignableReplica> getOrderedAssignableReplica(ClusterModel clusterModel) {
        Map<String, Set<AssignableReplica>> replicasByResource = clusterModel.getAssignableReplicaMap();
        List<AssignableReplica> orderedAssignableReplicas = replicasByResource.values().stream().flatMap(replicas -> replicas.stream()).collect(Collectors.toList());
        Map<String, ResourceAssignment> bestPossibleAssignment = clusterModel.getContext().getBestPossibleAssignment();
        Map<String, ResourceAssignment> baselineAssignment = clusterModel.getContext().getBaselineAssignment();
        Map<String, Integer> replicaHashCodeMap = orderedAssignableReplicas.parallelStream().collect(Collectors.toMap(AssignableReplica::toString, replica -> Objects.hash(replica.toString(), clusterModel.getAssignableNodes().keySet()), (hash1, hash2) -> hash2));
        orderedAssignableReplicas.sort((replica1, replica2) -> {
            String resourceName1 = replica1.getResourceName();
            String resourceName2 = replica2.getResourceName();
            if (bestPossibleAssignment.containsKey(resourceName1) == bestPossibleAssignment.containsKey(resourceName2)) {
                if (baselineAssignment.containsKey(resourceName1) == baselineAssignment.containsKey(resourceName2)) {
                    int statePriority2;
                    int statePriority1 = replica1.getStatePriority();
                    if (statePriority1 == (statePriority2 = replica2.getStatePriority())) {
                        Integer replicaHash2;
                        Integer replicaHash1 = (Integer)replicaHashCodeMap.get(replica1.toString());
                        if (!replicaHash1.equals(replicaHash2 = (Integer)replicaHashCodeMap.get(replica2.toString()))) {
                            return replicaHash1.compareTo(replicaHash2);
                        }
                        return replica1.toString().compareTo(replica2.toString());
                    }
                    return statePriority1 - statePriority2;
                }
                return baselineAssignment.containsKey(resourceName1) ? -1 : 1;
            }
            return bestPossibleAssignment.containsKey(resourceName1) ? -1 : 1;
        });
        return orderedAssignableReplicas;
    }

    private Set<String> getBusyInstances(Collection<ResourceAssignment> assignments) {
        return assignments.stream().flatMap(resourceAssignment -> resourceAssignment.getRecord().getMapFields().values().stream().flatMap(instanceStateMap -> instanceStateMap.keySet().stream()).collect(Collectors.toSet()).stream()).collect(Collectors.toSet());
    }
}

