/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.BucketDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.manager.zk.ZNRecordJacksonSerializer;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;

public class AssignmentMetadataStore {
    private static final String ASSIGNMENT_METADATA_KEY = "ASSIGNMENT_METADATA";
    private static final String BASELINE_TEMPLATE = "/%s/%s/BASELINE";
    private static final String BEST_POSSIBLE_TEMPLATE = "/%s/%s/BEST_POSSIBLE";
    private static final String BASELINE_KEY = "BASELINE";
    private static final String BEST_POSSIBLE_KEY = "BEST_POSSIBLE";
    private static final ZkSerializer SERIALIZER = new ZNRecordJacksonSerializer();
    private BucketDataAccessor _dataAccessor;
    private String _baselinePath;
    private String _bestPossiblePath;
    protected Map<String, ResourceAssignment> _globalBaseline;
    protected Map<String, ResourceAssignment> _bestPossibleAssignment;

    AssignmentMetadataStore(String metadataStoreAddrs, String clusterName) {
        this(new ZkBucketDataAccessor(metadataStoreAddrs), clusterName);
    }

    protected AssignmentMetadataStore(BucketDataAccessor bucketDataAccessor, String clusterName) {
        this._dataAccessor = bucketDataAccessor;
        this._baselinePath = String.format(BASELINE_TEMPLATE, clusterName, ASSIGNMENT_METADATA_KEY);
        this._bestPossiblePath = String.format(BEST_POSSIBLE_TEMPLATE, clusterName, ASSIGNMENT_METADATA_KEY);
    }

    public synchronized Map<String, ResourceAssignment> getBaseline() {
        if (this._globalBaseline == null) {
            try {
                HelixProperty baseline = this._dataAccessor.compressedBucketRead(this._baselinePath, HelixProperty.class);
                this._globalBaseline = this.splitAssignments(baseline);
            }
            catch (ZkNoNodeException ex) {
                this._globalBaseline = Collections.emptyMap();
            }
        }
        return this._globalBaseline;
    }

    public synchronized Map<String, ResourceAssignment> getBestPossibleAssignment() {
        if (this._bestPossibleAssignment == null) {
            try {
                HelixProperty baseline = this._dataAccessor.compressedBucketRead(this._bestPossiblePath, HelixProperty.class);
                this._bestPossibleAssignment = this.splitAssignments(baseline);
            }
            catch (ZkNoNodeException ex) {
                this._bestPossibleAssignment = Collections.emptyMap();
            }
        }
        return this._bestPossibleAssignment;
    }

    public synchronized boolean persistBaseline(Map<String, ResourceAssignment> globalBaseline) {
        if (this.compareAssignments(this._globalBaseline, globalBaseline)) {
            return false;
        }
        HelixProperty combinedAssignments = this.combineAssignments(BASELINE_KEY, globalBaseline);
        try {
            this._dataAccessor.compressedBucketWrite(this._baselinePath, combinedAssignments);
        }
        catch (IOException e) {
            throw new HelixException("Failed to persist baseline!", e);
        }
        this._globalBaseline = globalBaseline;
        return true;
    }

    public synchronized boolean persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) {
        if (this.compareAssignments(this._bestPossibleAssignment, bestPossibleAssignment)) {
            return false;
        }
        HelixProperty combinedAssignments = this.combineAssignments(BEST_POSSIBLE_KEY, bestPossibleAssignment);
        try {
            this._dataAccessor.compressedBucketWrite(this._bestPossiblePath, combinedAssignments);
        }
        catch (IOException e) {
            throw new HelixException("Failed to persist BestPossibleAssignment!", e);
        }
        this._bestPossibleAssignment = bestPossibleAssignment;
        return true;
    }

    protected synchronized void reset() {
        if (this._bestPossibleAssignment != null) {
            this._bestPossibleAssignment.clear();
            this._bestPossibleAssignment = null;
        }
        if (this._globalBaseline != null) {
            this._globalBaseline.clear();
            this._globalBaseline = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        this._dataAccessor.disconnect();
    }

    private HelixProperty combineAssignments(String name, Map<String, ResourceAssignment> assignmentMap) {
        HelixProperty property = new HelixProperty(name);
        assignmentMap.forEach((resource, assignment) -> property.getRecord().setSimpleField((String)resource, new String(SERIALIZER.serialize(assignment.getRecord()))));
        return property;
    }

    private Map<String, ResourceAssignment> splitAssignments(HelixProperty property) {
        HashMap<String, ResourceAssignment> assignmentMap = new HashMap<String, ResourceAssignment>();
        property.getRecord().getSimpleFields().forEach((resource, assignmentStr) -> assignmentMap.put((String)resource, new ResourceAssignment((ZNRecord)SERIALIZER.deserialize(assignmentStr.getBytes()))));
        return assignmentMap;
    }

    protected boolean compareAssignments(Map<String, ResourceAssignment> oldAssignment, Map<String, ResourceAssignment> newAssignment) {
        return oldAssignment != null && oldAssignment.equals(newAssignment);
    }
}

