/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowsResource.class);

    public WorkflowsResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            presentation = this.getHostedEntitiesRepresentation(clusterName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getHostedEntitiesRepresentation(String clusterName) throws JsonGenerationException, JsonMappingException, IOException {
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        Map resourceConfigMap = accessor.getChildValuesMap(keyBuilder.resourceConfigs());
        ZNRecord hostedEntitiesRecord = new ZNRecord("Workflows");
        Iterator it = resourceConfigMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            HelixProperty resource = (HelixProperty)e.getValue();
            Map simpleFields = resource.getRecord().getSimpleFields();
            if (simpleFields.containsKey(WorkflowConfig.WorkflowConfigProperty.TargetState.name()) && simpleFields.containsKey(WorkflowConfig.WorkflowConfigProperty.Dag.name())) continue;
            it.remove();
        }
        ArrayList allResources = Lists.newArrayList(resourceConfigMap.keySet());
        hostedEntitiesRecord.setListField("WorkflowList", (List)allResources);
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(hostedEntitiesRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Representation post(Representation entity) {
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            Form form = new Form(entity);
            if (form.size() < 1) {
                throw new HelixException("yaml workflow is required!");
            }
            Parameter payload = (Parameter)form.get(0);
            String yamlPayload = payload.getName();
            if (yamlPayload == null) {
                throw new HelixException("yaml workflow is required!");
            }
            String zkAddr = (String)this.getContext().getAttributes().get("zkSvr");
            HelixManager manager = HelixManagerFactory.getZKHelixManager((String)clusterName, null, (InstanceType)InstanceType.ADMINISTRATOR, (String)zkAddr);
            manager.connect();
            try {
                Workflow workflow = Workflow.parse((String)yamlPayload);
                TaskDriver driver = new TaskDriver(manager);
                driver.start(workflow);
            }
            finally {
                manager.disconnect();
            }
            this.getResponse().setEntity((Representation)this.getHostedEntitiesRepresentation(clusterName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }
}

