/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import java.util.Arrays;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceGroupResource.class);

    public ResourceGroupResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
            presentation = this.getIdealStateRepresentation(clusterName, resourceName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get resource group", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getIdealStateRepresentation(String clusterName, String resourceName) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.RAW_ZKCLIENT);
        String idealStateStr = ResourceUtil.readZkAsBytes(zkclient, keyBuilder.idealStates(resourceName));
        StringRepresentation representation = new StringRepresentation((CharSequence)idealStateStr, MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation delete() {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
            ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkclient);
            setupTool.dropResourceFromCluster(clusterName, resourceName);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("", (Throwable)e);
        }
        return null;
    }

    public Representation post(Representation entity) {
        block4: {
            try {
                String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
                String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
                ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
                ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkclient);
                JsonParameters jsonParameters = new JsonParameters(entity);
                String command = jsonParameters.getCommand();
                if (command.equalsIgnoreCase("resetResource")) {
                    setupTool.getClusterManagementTool().resetResource(clusterName, Arrays.asList(resourceName));
                    break block4;
                }
                if (command.equalsIgnoreCase("enableResource")) {
                    jsonParameters.verifyCommand("enableResource");
                    boolean enabled = Boolean.parseBoolean(jsonParameters.getParameter("enabled"));
                    setupTool.getClusterManagementTool().enableResource(clusterName, resourceName, enabled);
                    break block4;
                }
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "resetResource" + "]");
            }
            catch (Exception e) {
                this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
                this.getResponse().setStatus(Status.SUCCESS_OK);
                LOG.error("", (Throwable)e);
            }
        }
        return null;
    }
}

