/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.data.Form;
import org.restlet.representation.Representation;

public class JsonParameters {
    public static final String JSON_PARAMETERS = "jsonParameters";
    public static final String PARTITION = "partition";
    public static final String RESOURCE = "resource";
    public static final String MANAGEMENT_COMMAND = "command";
    public static final String ENABLED = "enabled";
    public static final String GRAND_CLUSTER = "grandCluster";
    public static final String REPLICAS = "replicas";
    public static final String RESOURCE_KEY_PREFIX = "key";
    public static final String INSTANCE_NAME = "instanceName";
    public static final String INSTANCE_NAMES = "instanceNames";
    public static final String OLD_INSTANCE = "oldInstance";
    public static final String NEW_INSTANCE = "newInstance";
    public static final String CONFIGS = "configs";
    public static final String CONSTRAINT_ATTRIBUTES = "constraintAttributes";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String PARTITIONS = "partitions";
    public static final String RESOURCE_GROUP_NAME = "resourceGroupName";
    public static final String STATE_MODEL_DEF_REF = "stateModelDefRef";
    public static final String IDEAL_STATE_MODE = "mode";
    public static final String MAX_PARTITIONS_PER_NODE = "maxPartitionsPerNode";
    public static final String BUCKET_SIZE = "bucketSize";
    public static final String ZK_DELETE_CHILDREN = "zkDeleteChildren";
    public static final String NEW_IDEAL_STATE = "newIdealState";
    public static final String NEW_STATE_MODEL_DEF = "newStateModelDef";
    public static final String TAG = "tag";
    public static Map<String, Set<String>> CLUSTERSETUP_COMMAND_ALIASES = new HashMap<String, Set<String>>();
    final Map<String, String> _parameterMap;
    final Map<String, ZNRecord> _extraParameterMap = new HashMap<String, ZNRecord>();

    public JsonParameters(Representation entity) throws Exception {
        this(new Form(entity));
    }

    public JsonParameters(Form form) throws Exception {
        String newStateModelString;
        String jsonPayload = form.getFirstValue(JSON_PARAMETERS, true);
        this._parameterMap = jsonPayload == null || jsonPayload.isEmpty() ? Collections.emptyMap() : ClusterRepresentationUtil.JsonToMap(jsonPayload);
        ObjectMapper mapper = new ObjectMapper();
        String newIdealStateString = form.getFirstValue(NEW_IDEAL_STATE, true);
        if (newIdealStateString != null) {
            ZNRecord newIdealState = (ZNRecord)mapper.readValue((Reader)new StringReader(newIdealStateString), ZNRecord.class);
            this._extraParameterMap.put(NEW_IDEAL_STATE, newIdealState);
        }
        if ((newStateModelString = form.getFirstValue(NEW_STATE_MODEL_DEF, true)) != null) {
            ZNRecord newStateModel = (ZNRecord)mapper.readValue((Reader)new StringReader(newStateModelString), ZNRecord.class);
            this._extraParameterMap.put(NEW_STATE_MODEL_DEF, newStateModel);
        }
    }

    public String getParameter(String key) {
        return this._parameterMap.get(key);
    }

    public String getCommand() {
        String command = this._parameterMap.get(MANAGEMENT_COMMAND);
        return command;
    }

    public ZNRecord getExtraParameter(String key) {
        return this._extraParameterMap.get(key);
    }

    public Map<String, String> cloneParameterMap() {
        TreeMap<String, String> parameterMap = new TreeMap<String, String>();
        parameterMap.putAll(this._parameterMap);
        return parameterMap;
    }

    public void verifyCommand(String command) {
        if (this._parameterMap.isEmpty()) {
            throw new HelixException("'jsonParameters' in the POST body is empty");
        }
        if (!this._parameterMap.containsKey(MANAGEMENT_COMMAND)) {
            throw new HelixException("Missing management parameter 'command'");
        }
        if (!(this._parameterMap.get(MANAGEMENT_COMMAND).equalsIgnoreCase(command) || CLUSTERSETUP_COMMAND_ALIASES.get(command) != null && CLUSTERSETUP_COMMAND_ALIASES.get(command).contains(this._parameterMap.get(MANAGEMENT_COMMAND)))) {
            throw new HelixException("command must be '" + command + "'");
        }
        if (command.equalsIgnoreCase("enableInstance")) {
            if (!this._parameterMap.containsKey(ENABLED)) {
                throw new HelixException("Missing Json parameters: 'enabled'");
            }
        } else if (command.equalsIgnoreCase("enableResource")) {
            if (!this._parameterMap.containsKey(ENABLED)) {
                throw new HelixException("Missing Json parameters: 'enabled'");
            }
        } else if (command.equalsIgnoreCase("enablePartition")) {
            if (!this._parameterMap.containsKey(ENABLED)) {
                throw new HelixException("Missing Json parameters: 'enabled'");
            }
            if (!this._parameterMap.containsKey(PARTITION)) {
                throw new HelixException("Missing Json parameters: 'partition'");
            }
            if (!this._parameterMap.containsKey(RESOURCE)) {
                throw new HelixException("Missing Json parameters: 'resource'");
            }
        } else if (command.equalsIgnoreCase("resetPartition")) {
            if (!this._parameterMap.containsKey(PARTITION)) {
                throw new HelixException("Missing Json parameters: 'partition'");
            }
            if (!this._parameterMap.containsKey(RESOURCE)) {
                throw new HelixException("Missing Json parameters: 'resource'");
            }
        } else if (!command.equalsIgnoreCase("resetInstance")) {
            if (command.equalsIgnoreCase("activateCluster")) {
                if (!this._parameterMap.containsKey(GRAND_CLUSTER)) {
                    throw new HelixException("Missing Json parameters: 'grandCluster'");
                }
            } else if (command.equalsIgnoreCase("setConfig")) {
                if (!this._parameterMap.containsKey(CONFIGS)) {
                    throw new HelixException("Missing Json parameters: 'configs'");
                }
            } else if (command.equalsIgnoreCase("removeConfig")) {
                if (!this._parameterMap.containsKey(CONFIGS)) {
                    throw new HelixException("Missing Json parameters: 'configs'");
                }
            } else if (command.equalsIgnoreCase("addInstanceTag")) {
                if (!this._parameterMap.containsKey("instanceGroupTag")) {
                    throw new HelixException("Missing Json parameters: 'instanceGroupTag'");
                }
            } else if (command.equalsIgnoreCase("removeInstanceTag")) {
                if (!this._parameterMap.containsKey("instanceGroupTag")) {
                    throw new HelixException("Missing Json parameters: 'instanceGroupTag'");
                }
            } else if (command.equalsIgnoreCase("addCluster")) {
                if (!this._parameterMap.containsKey(CLUSTER_NAME)) {
                    throw new HelixException("Missing Json parameters: 'clusterName'");
                }
            } else if (command.equalsIgnoreCase("addResource")) {
                if (!this._parameterMap.containsKey(RESOURCE_GROUP_NAME)) {
                    throw new HelixException("Missing Json parameters: 'resourceGroupName'");
                }
                if (!this._parameterMap.containsKey(PARTITIONS)) {
                    throw new HelixException("Missing Json parameters: 'partitions'");
                }
                if (!this._parameterMap.containsKey(STATE_MODEL_DEF_REF)) {
                    throw new HelixException("Missing Json parameters: 'stateModelDefRef'");
                }
            }
        }
    }

    static {
        CLUSTERSETUP_COMMAND_ALIASES.put("addResource", new HashSet<String>(Arrays.asList("addResourceGroup")));
        CLUSTERSETUP_COMMAND_ALIASES.put("activateCluster", new HashSet<String>(Arrays.asList("enableStorageCluster")));
        CLUSTERSETUP_COMMAND_ALIASES.put("addNode", new HashSet<String>(Arrays.asList("addInstance")));
    }
}

