/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import java.util.Arrays;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceResource.class);

    public InstanceResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            presentation = this.getInstanceRepresentation();
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get instance", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getInstanceRepresentation() throws JsonGenerationException, JsonMappingException, IOException {
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String instanceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.INSTANCE_NAME);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.RAW_ZKCLIENT);
        String instanceCfgStr = ResourceUtil.readZkAsBytes(zkclient, keyBuilder.instanceConfig(instanceName));
        StringRepresentation representation = new StringRepresentation((CharSequence)instanceCfgStr, MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String instanceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.INSTANCE_NAME);
            ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkclient);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command.equalsIgnoreCase("enableInstance")) {
                jsonParameters.verifyCommand("enableInstance");
                boolean enabled = Boolean.parseBoolean(jsonParameters.getParameter("enabled"));
                setupTool.getClusterManagementTool().enableInstance(clusterName, instanceName, enabled);
            } else if (command.equalsIgnoreCase("enablePartition")) {
                jsonParameters.verifyCommand("enablePartition");
                boolean enabled = Boolean.parseBoolean(jsonParameters.getParameter("enabled"));
                String[] partitions = jsonParameters.getParameter("partition").split(";");
                String resource = jsonParameters.getParameter("resource");
                setupTool.getClusterManagementTool().enablePartition(enabled, clusterName, instanceName, resource, Arrays.asList(partitions));
            } else if (command.equalsIgnoreCase("resetPartition")) {
                jsonParameters.verifyCommand("resetPartition");
                String resource = jsonParameters.getParameter("resource");
                String[] partitionNames = jsonParameters.getParameter("partition").split("\\s+");
                setupTool.getClusterManagementTool().resetPartition(clusterName, instanceName, resource, Arrays.asList(partitionNames));
            } else if (command.equalsIgnoreCase("resetInstance")) {
                jsonParameters.verifyCommand("resetInstance");
                setupTool.getClusterManagementTool().resetInstance(clusterName, Arrays.asList(instanceName));
            } else if (command.equalsIgnoreCase("addInstanceTag")) {
                jsonParameters.verifyCommand("addInstanceTag");
                String tag = jsonParameters.getParameter("instanceGroupTag");
                setupTool.getClusterManagementTool().addInstanceTag(clusterName, instanceName, tag);
            } else if (command.equalsIgnoreCase("removeInstanceTag")) {
                jsonParameters.verifyCommand("removeInstanceTag");
                String tag = jsonParameters.getParameter("instanceGroupTag");
                setupTool.getClusterManagementTool().removeInstanceTag(clusterName, instanceName, tag);
            } else {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "enableInstance" + ", " + "enablePartition" + ", " + "resetInstance" + "]");
            }
            this.getResponse().setEntity((Representation)this.getInstanceRepresentation());
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Exception in post instance", (Throwable)e);
        }
        return null;
    }

    public Representation delete() {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String instanceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.INSTANCE_NAME);
            ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkclient);
            setupTool.dropInstanceFromCluster(clusterName, instanceName);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in delete instance", (Throwable)e);
        }
        return null;
    }
}

