/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.IdealState;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdealStateResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(IdealStateResource.class);

    public IdealStateResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
            presentation = this.getIdealStateRepresentation(clusterName, resourceName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Exception in get idealState", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getIdealStateRepresentation(String clusterName, String resourceName) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        ZkClient zkclient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.RAW_ZKCLIENT);
        String idealStateStr = ResourceUtil.readZkAsBytes(zkclient, keyBuilder.idealStates(resourceName));
        StringRepresentation representation = new StringRepresentation((CharSequence)idealStateStr, MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String resourceName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.RESOURCE_NAME);
            ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
            ClusterSetup setupTool = new ClusterSetup((RealmAwareZkClient)zkClient);
            JsonParameters jsonParameters = new JsonParameters(entity);
            String command = jsonParameters.getCommand();
            if (command.equalsIgnoreCase("addIdealState")) {
                ZNRecord newIdealState = jsonParameters.getExtraParameter("newIdealState");
                HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
                accessor.setProperty(accessor.keyBuilder().idealStates(resourceName), (HelixProperty)new IdealState(newIdealState));
            } else if (command.equalsIgnoreCase("rebalance")) {
                int replicas = Integer.parseInt(jsonParameters.getParameter("replicas"));
                String keyPrefix = jsonParameters.getParameter("key");
                String groupTag = jsonParameters.getParameter("instanceGroupTag");
                setupTool.rebalanceCluster(clusterName, resourceName, replicas, keyPrefix, groupTag);
            } else if (command.equalsIgnoreCase("expandResource")) {
                setupTool.expandResource(clusterName, resourceName);
            } else if (command.equalsIgnoreCase("addResourceProperty")) {
                Map<String, String> parameterMap = jsonParameters.cloneParameterMap();
                parameterMap.remove("command");
                for (String key : parameterMap.keySet()) {
                    setupTool.addResourceProperty(clusterName, resourceName, key, parameterMap.get(key));
                }
            } else {
                throw new HelixException("Unsupported command: " + command + ". Should be one of [" + "addIdealState" + ", " + "rebalance" + ", " + "expandResource" + ", " + "addResourceProperty" + "]");
            }
            this.getResponse().setEntity((Representation)this.getIdealStateRepresentation(clusterName, resourceName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting " + entity, (Throwable)e);
        }
        return null;
    }
}

