/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobDag;
import org.apache.helix.task.ScheduleConfig;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.beans.JobBean;
import org.apache.helix.task.beans.WorkflowBean;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Workflow {
    public static final String UNSPECIFIED = "UNSPECIFIED";
    protected String _name;
    protected WorkflowConfig _workflowConfig;
    protected Map<String, Map<String, String>> _jobConfigs;
    protected Map<String, List<TaskConfig>> _taskConfigs;

    protected Workflow(String name, WorkflowConfig workflowConfig, Map<String, Map<String, String>> jobConfigs, Map<String, List<TaskConfig>> taskConfigs) {
        this._name = name;
        this._workflowConfig = workflowConfig;
        this._jobConfigs = jobConfigs;
        this._taskConfigs = taskConfigs;
        this.validate();
    }

    public String getName() {
        return this._name;
    }

    public Map<String, Map<String, String>> getJobConfigs() {
        return this._jobConfigs;
    }

    public Map<String, List<TaskConfig>> getTaskConfigs() {
        return this._taskConfigs;
    }

    public WorkflowConfig getWorkflowConfig() {
        return this._workflowConfig;
    }

    public Map<String, String> getResourceConfigMap() throws HelixException {
        return this._workflowConfig.getResourceConfigMap();
    }

    public static Workflow parse(File file) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(file));
        return Workflow.parse(br);
    }

    public static Workflow parse(String yaml) throws Exception {
        return Workflow.parse(new StringReader(yaml));
    }

    private static Workflow parse(Reader reader) throws Exception {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(WorkflowBean.class));
        WorkflowBean wf = (WorkflowBean)yaml.load(reader);
        Builder workflowBuilder = new Builder(wf.name);
        if (wf != null && wf.jobs != null) {
            for (JobBean job : wf.jobs) {
                if (job.name == null) {
                    throw new IllegalArgumentException("A job must have a name.");
                }
                JobConfig.Builder jobConfigBuilder = JobConfig.Builder.from(job);
                jobConfigBuilder.setWorkflow(wf.name);
                workflowBuilder.addJob(job.name, jobConfigBuilder);
                if (job.parents == null) continue;
                for (String parent : job.parents) {
                    workflowBuilder.addParentChildDependency(parent, job.name);
                }
            }
        }
        workflowBuilder.setWorkflowConfig(WorkflowConfig.Builder.from(wf).build());
        return workflowBuilder.build();
    }

    public void validate() {
        HashSet<String> jobNamesInDag;
        HashSet<String> jobNamesInConfig = new HashSet<String>(this._jobConfigs.keySet());
        if (!jobNamesInConfig.equals(jobNamesInDag = new HashSet<String>(this._workflowConfig.getJobDag().getAllNodes()))) {
            HashSet<String> jobNamesInConfigButNotInDag = new HashSet<String>(jobNamesInConfig);
            jobNamesInConfigButNotInDag.removeAll(jobNamesInDag);
            HashSet<String> jobNamesInDagButNotInConfig = new HashSet<String>(jobNamesInDag);
            jobNamesInDagButNotInConfig.removeAll(jobNamesInConfig);
            throw new IllegalArgumentException("Job Names dismatch. Names in config but not in dag: " + jobNamesInConfigButNotInDag + ", names in dag but not in config: " + jobNamesInDagButNotInConfig);
        }
        int capacity = this._workflowConfig.getCapacity();
        int dagSize = this._workflowConfig.getJobDag().size();
        if (capacity > 0 && dagSize > capacity) {
            throw new IllegalArgumentException(String.format("Failed to build workflow %s, number of jobs are more than its capacity! capacity(%d), jobs(%d)", this._name, capacity, dagSize));
        }
        this._workflowConfig.getJobDag().validate();
        for (String node : this._jobConfigs.keySet()) {
            this.buildConfig(node);
        }
    }

    private JobConfig buildConfig(String job) {
        JobConfig.Builder b = JobConfig.Builder.fromMap(this._jobConfigs.get(job));
        if (this._taskConfigs != null && this._taskConfigs.containsKey(job)) {
            b.addTaskConfigs(this._taskConfigs.get(job));
        }
        return b.build();
    }

    public static class Builder {
        protected String _name;
        protected JobDag _dag;
        protected Map<String, Map<String, String>> _jobConfigs;
        protected Map<String, List<TaskConfig>> _taskConfigs;
        protected WorkflowConfig.Builder _workflowConfigBuilder;

        public Builder(String name) {
            this._name = name;
            this._dag = new JobDag();
            this._jobConfigs = new TreeMap<String, Map<String, String>>();
            this._taskConfigs = new TreeMap<String, List<TaskConfig>>();
        }

        protected Builder addConfig(String job, String key, String val) {
            job = this.namespacify(job);
            this._dag.addNode(job);
            if (!this._jobConfigs.containsKey(job)) {
                this._jobConfigs.put(job, new TreeMap());
            }
            this._jobConfigs.get(job).put(key, val);
            return this;
        }

        private Builder addJobCommandConfigMap(String job, Map<String, String> jobConfigMap) {
            return this.addConfig(job, JobConfig.JobConfigProperty.JobCommandConfig.name(), TaskUtil.serializeJobCommandConfigMap(jobConfigMap));
        }

        @Deprecated
        public Builder addJobConfig(String job, JobConfig.Builder jobConfigBuilder) {
            return this.addJob(job, jobConfigBuilder);
        }

        public Builder addJob(String job, JobConfig.Builder jobConfigBuilder) {
            JobConfig jobConfig = jobConfigBuilder.setWorkflow(this._name).build();
            for (Map.Entry<String, String> e : jobConfig.getResourceConfigMap().entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                this.addConfig(job, key, val);
            }
            this.addTaskConfigs(job, jobConfig.getTaskConfigMap().values());
            return this;
        }

        protected Builder addTaskConfigs(String job, Collection<TaskConfig> taskConfigs) {
            job = this.namespacify(job);
            this._dag.addNode(job);
            if (!this._taskConfigs.containsKey(job)) {
                this._taskConfigs.put(job, new ArrayList());
            }
            if (!this._jobConfigs.containsKey(job)) {
                this._jobConfigs.put(job, new TreeMap());
            }
            this._taskConfigs.get(job).addAll(taskConfigs);
            return this;
        }

        public Builder addParentChildDependency(String parent, String child) {
            parent = this.namespacify(parent);
            child = this.namespacify(child);
            this._dag.addParentToChild(parent, child);
            return this;
        }

        public Builder fromMap(Map<String, String> workflowCfgMap) {
            return this.setWorkflowConfigMap(workflowCfgMap);
        }

        public Builder setWorkflowConfigMap(Map<String, String> workflowCfgMap) {
            if (workflowCfgMap != null && !workflowCfgMap.isEmpty()) {
                if (this._workflowConfigBuilder == null) {
                    this._workflowConfigBuilder = WorkflowConfig.Builder.fromMap(workflowCfgMap);
                } else {
                    this._workflowConfigBuilder.setConfigMap(workflowCfgMap);
                }
            }
            return this;
        }

        public Builder setWorkflowConfig(WorkflowConfig workflowConfig) {
            this._workflowConfigBuilder = new WorkflowConfig.Builder(workflowConfig);
            return this;
        }

        public WorkflowConfig getWorkflowConfig() {
            return this._workflowConfigBuilder.build();
        }

        public Builder setScheduleConfig(ScheduleConfig scheduleConfig) {
            if (this._workflowConfigBuilder == null) {
                this._workflowConfigBuilder = new WorkflowConfig.Builder();
            }
            this._workflowConfigBuilder.setScheduleConfig(scheduleConfig);
            return this;
        }

        public Builder setExpiry(long expiry) {
            if (this._workflowConfigBuilder == null) {
                this._workflowConfigBuilder = new WorkflowConfig.Builder();
            }
            this._workflowConfigBuilder.setExpiry(expiry);
            return this;
        }

        @Deprecated
        public Builder setCapacity(int capacity) {
            if (this._workflowConfigBuilder == null) {
                this._workflowConfigBuilder = new WorkflowConfig.Builder();
            }
            this._workflowConfigBuilder.setCapacity(capacity);
            return this;
        }

        public String namespacify(String job) {
            return TaskUtil.getNamespacedJobName(this._name, job);
        }

        public Workflow build() {
            this.buildConfig();
            return new Workflow(this._name, this._workflowConfigBuilder.build(), this._jobConfigs, this._taskConfigs);
        }

        protected void buildConfig() {
            for (String task : this._jobConfigs.keySet()) {
                this._jobConfigs.get(task).put(JobConfig.JobConfigProperty.WorkflowID.name(), this._name);
            }
            if (this._workflowConfigBuilder == null) {
                this._workflowConfigBuilder = new WorkflowConfig.Builder();
            }
            this._workflowConfigBuilder.setWorkflowId(this._name);
            this._workflowConfigBuilder.setJobDag(this._dag);
        }
    }
}

