/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.client;

import java.util.List;
import org.I0Itec.zkclient.IZkConnection;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.ZkConnectionManager;
import org.apache.helix.manager.zk.zookeeper.ZkConnection;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedZkClient
extends ZkClient
implements HelixZkClient {
    private static Logger LOG = LoggerFactory.getLogger(SharedZkClient.class);
    private static final ZkConnection IDLE_CONNECTION = new ZkConnection("Dummy_ZkServers");
    private final OnCloseCallback _onCloseCallback;
    private final ZkConnectionManager _connectionManager;

    protected SharedZkClient(ZkConnectionManager connectionManager, HelixZkClient.ZkClientConfig clientConfig, OnCloseCallback callback) {
        super(connectionManager.getConnection(), 0, clientConfig.getOperationRetryTimeout(), clientConfig.getZkSerializer(), clientConfig.getMonitorType(), clientConfig.getMonitorKey(), clientConfig.getMonitorInstanceName(), clientConfig.isMonitorRootPathOnly());
        this._connectionManager = connectionManager;
        this._connectionManager.registerWatcher(this);
        this._onCloseCallback = callback;
    }

    @Override
    public void close() {
        super.close();
        if (this.isClosed()) {
            if (this._connectionManager != null) {
                this._connectionManager.unregisterWatcher(this);
            }
            if (this._onCloseCallback != null) {
                this._onCloseCallback.onClose();
            }
        }
    }

    @Override
    public IZkConnection getConnection() {
        if (this.isClosed()) {
            return IDLE_CONNECTION;
        }
        return super.getConnection();
    }

    @Override
    public String create(String path, Object datat, List<ACL> acl, CreateMode mode) {
        if (mode.isEphemeral()) {
            throw new HelixException("Create ephemeral nodes using a " + SharedZkClient.class.getSimpleName() + " ZkClient is not supported.");
        }
        return super.create(path, datat, acl, mode);
    }

    @Override
    protected boolean isManagingZkConnection() {
        return false;
    }

    static interface OnCloseCallback {
        public void onClose();
    }
}

