/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.filters;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.helix.rest.common.HelixRestUtils;
import org.apache.helix.rest.server.auditlog.AuditLog;
import org.apache.helix.rest.server.auditlog.AuditLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class AuditLogFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static Logger _logger = LoggerFactory.getLogger((String)AuditLogFilter.class.getName());
    @Context
    private HttpServletRequest _servletRequest;
    private List<AuditLogger> _auditLoggers;

    public AuditLogFilter(List<AuditLogger> auditLoggers) {
        this._auditLoggers = auditLoggers;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        AuditLog.Builder auditLogBuilder = new AuditLog.Builder();
        auditLogBuilder.namespace(this.getNamespace()).requestPath(request.getUriInfo().getPath()).httpMethod(request.getMethod()).startTime(new Date()).requestHeaders(this.getHeaders((MultivaluedMap<String, String>)request.getHeaders())).principal(this._servletRequest.getUserPrincipal()).clientIP(this._servletRequest.getRemoteAddr()).clientHostPort(this._servletRequest.getRemoteHost() + ":" + this._servletRequest.getRemotePort());
        String entity = this.getEntity(request.getEntityStream());
        auditLogBuilder.requestEntity(entity);
        ByteArrayInputStream stream = new ByteArrayInputStream(entity.getBytes(StandardCharsets.UTF_8));
        request.setEntityStream((InputStream)stream);
        request.setProperty("AUDIT_LOG", (Object)auditLogBuilder);
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        try {
            AuditLog.Builder auditLogBuilder = (AuditLog.Builder)request.getProperty("AUDIT_LOG");
            auditLogBuilder.completeTime(new Date()).responseCode(response.getStatus());
            Object entity = response.getEntity();
            if (entity != null && entity instanceof String) {
                auditLogBuilder.responseEntity((String)response.getEntity());
            }
            AuditLog auditLog = auditLogBuilder.build();
            if (this._auditLoggers != null) {
                for (AuditLogger logger : this._auditLoggers) {
                    logger.write(auditLog);
                }
            }
        }
        catch (Exception ex) {
            _logger.error("Failed to add audit log " + ex);
        }
    }

    private List<String> getHeaders(MultivaluedMap<String, String> headersMap) {
        ArrayList<String> headers = new ArrayList<String>();
        for (String key : headersMap.keySet()) {
            headers.add(key + ":" + headersMap.get((Object)key));
        }
        return headers;
    }

    private String getEntity(InputStream entityStream) {
        if (entityStream != null) {
            try {
                return CharStreams.toString((Readable)new InputStreamReader(entityStream, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                _logger.warn("Failed to parse input entity stream " + e);
            }
        }
        return null;
    }

    private String getNamespace() {
        String servletPath = this._servletRequest.getServletPath();
        return HelixRestUtils.getNamespaceFromServletPath(servletPath);
    }
}

