/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.sps;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.sps.Context;
import org.apache.hadoop.hdfs.server.namenode.sps.SPSService;
import org.apache.hadoop.hdfs.server.namenode.sps.StoragePolicySatisfier;
import org.apache.hadoop.hdfs.server.sps.ExternalSPSContext;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStoragePolicySatisfierWithStripedFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestStoragePolicySatisfierWithStripedFile.class);
    private final int stripesPerBlock = 2;
    private ErasureCodingPolicy ecPolicy;
    private int dataBlocks;
    private int parityBlocks;
    private int cellSize;
    private int defaultStripeBlockSize;
    private Configuration conf;
    private StoragePolicySatisfier sps;
    private ExternalSPSContext ctxt;
    private NameNodeConnector nnc;

    private ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void init() {
        this.ecPolicy = this.getEcPolicy();
        this.dataBlocks = this.ecPolicy.getNumDataUnits();
        this.parityBlocks = this.ecPolicy.getNumParityUnits();
        this.cellSize = this.ecPolicy.getCellSize();
        this.defaultStripeBlockSize = this.cellSize * 2;
        this.conf = new HdfsConfiguration();
        this.conf.set("dfs.storage.policy.satisfier.mode", HdfsConstants.StoragePolicySatisfierMode.EXTERNAL.toString());
        this.conf.setLong("dfs.storage.policy.satisfier.datanode.cache.refresh.interval.ms", 1000L);
        this.conf.setInt("dfs.storage.policy.satisfier.retry.max.attempts", 30);
        TestStoragePolicySatisfierWithStripedFile.initConfWithStripe(this.conf, this.defaultStripeBlockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMoverWithFullStripe() throws Exception {
        int numOfDatanodes = 11;
        int storagesPerDatanode = 2;
        long capacity = 20 * this.defaultStripeBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).storageCapacities(capacities).build();
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        try {
            cluster.waitActive();
            this.startSPS();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)this.conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String barDir = "/bar";
            client.mkdirs(barDir, new FsPermission(777), true);
            client.setStoragePolicy(barDir, "HOT");
            client.setErasureCodingPolicy(barDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String fooFile = "/bar/foo";
            long fileLen = this.cellSize * this.dataBlocks;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/bar/foo"), fileLen, (short)3, 0L);
            LocatedBlocks locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.dataBlocks + this.parityBlocks);
            int numOfNewDatanodes = 5;
            capacities = new long[numOfNewDatanodes][storagesPerDatanode];
            for (int i = 0; i < numOfNewDatanodes; ++i) {
                for (int j = 0; j < storagesPerDatanode; ++j) {
                    capacities[i][j] = capacity;
                }
            }
            cluster.startDataNodes(this.conf, 5, new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}, true, null, null, null, capacities, null, false, false, false, null, null, null);
            cluster.triggerHeartbeats();
            client.setStoragePolicy(barDir, "COLD");
            hdfsAdmin.satisfyStoragePolicy(new Path("/bar/foo"));
            LOG.info("Sets storage policy to COLD and invoked satisfyStoragePolicy");
            cluster.triggerHeartbeats();
            this.waitExpectedStorageType(cluster, "/bar/foo", fileLen, StorageType.ARCHIVE, 9, 9, 60000);
        }
        finally {
            cluster.shutdown();
            this.sps.stopGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWhenOnlyFewTargetNodesAreAvailableToSatisfyStoragePolicy() throws Exception {
        int numOfDatanodes = 11;
        int storagesPerDatanode = 2;
        long capacity = 20 * this.defaultStripeBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).storageCapacities(capacities).build();
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        try {
            cluster.waitActive();
            this.startSPS();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)this.conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String barDir = "/bar";
            client.mkdirs(barDir, new FsPermission(777), true);
            client.setStoragePolicy(barDir, "HOT");
            client.setErasureCodingPolicy(barDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String fooFile = "/bar/foo";
            long fileLen = this.cellSize * this.dataBlocks;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/bar/foo"), fileLen, (short)3, 0L);
            LocatedBlocks locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
            Thread.sleep(5000L);
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.dataBlocks + this.parityBlocks);
            int numOfNewDatanodes = 2;
            capacities = new long[numOfNewDatanodes][storagesPerDatanode];
            for (int i = 0; i < numOfNewDatanodes; ++i) {
                for (int j = 0; j < storagesPerDatanode; ++j) {
                    capacities[i][j] = capacity;
                }
            }
            cluster.startDataNodes(this.conf, 2, new StorageType[][]{{StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}, true, null, null, null, capacities, null, false, false, false, null, null, null);
            cluster.triggerHeartbeats();
            client.setStoragePolicy(barDir, "COLD");
            hdfsAdmin.satisfyStoragePolicy(new Path("/bar/foo"));
            LOG.info("Sets storage policy to COLD and invoked satisfyStoragePolicy");
            cluster.triggerHeartbeats();
            this.waitForAttemptedItems(1L, 30000);
            this.waitExpectedStorageType(cluster, "/bar/foo", fileLen, StorageType.ARCHIVE, 5, 9, 60000);
        }
        finally {
            cluster.shutdown();
            this.sps.stopGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSPSWhenFileHasLowRedundancyBlocks() throws Exception {
        int numOfDatanodes = 9;
        int storagesPerDatanode = 2;
        long capacity = 20 * this.defaultStripeBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        this.conf.set("dfs.storage.policy.satisfier.recheck.timeout.millis", "3000");
        this.conf.set("dfs.storage.policy.satisfier.self.retry.timeout.millis", "5000");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}, {StorageType.DISK, StorageType.ARCHIVE}}).storageCapacities(capacities).build();
        try {
            int i;
            cluster.waitActive();
            this.startSPS();
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            Path barDir = new Path("/bar");
            fs.mkdirs(barDir);
            fs.setErasureCodingPolicy(barDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            Path fooFile = new Path("/bar/foo");
            long fileLen = this.cellSize * this.dataBlocks;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), fooFile, fileLen, (short)3, 0L);
            fs.setStoragePolicy(barDir, "COLD");
            ArrayList<MiniDFSCluster.DataNodeProperties> list = new ArrayList<MiniDFSCluster.DataNodeProperties>(numOfDatanodes);
            for (i = 0; i < numOfDatanodes; ++i) {
                list.add(cluster.stopDataNode(0));
            }
            cluster.restartNameNodes();
            for (i = 0; i < 5; ++i) {
                cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)list.get(i), false);
            }
            cluster.waitActive();
            fs.satisfyStoragePolicy(fooFile);
            DFSTestUtil.waitExpectedStorageType(fooFile.toString(), StorageType.ARCHIVE, 5, 30000, cluster.getFileSystem());
            for (i = numOfDatanodes - 1; i >= 5; --i) {
                cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)list.get(i), false);
            }
            cluster.waitActive();
            this.waitExpectedStorageType(cluster, fooFile.toString(), fileLen, StorageType.ARCHIVE, 9, 9, 60000);
        }
        finally {
            cluster.shutdown();
            this.sps.stopGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testWhenNoTargetDatanodeToSatisfyStoragePolicy() throws Exception {
        int numOfDatanodes = 10;
        int storagesPerDatanode = 2;
        long capacity = 20 * this.defaultStripeBlockSize;
        long[][] capacities = new long[numOfDatanodes][storagesPerDatanode];
        for (int i = 0; i < numOfDatanodes; ++i) {
            for (int j = 0; j < storagesPerDatanode; ++j) {
                capacities[i][j] = capacity;
            }
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numOfDatanodes).storagesPerDatanode(storagesPerDatanode).storageTypes(new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}}).storageCapacities(capacities).build();
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        try {
            cluster.waitActive();
            this.startSPS();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.enableErasureCodingPolicy(StripedFileTestUtil.getDefaultECPolicy().getName());
            ClientProtocol client = (ClientProtocol)NameNodeProxies.createProxy((Configuration)this.conf, (URI)cluster.getFileSystem(0).getUri(), ClientProtocol.class).getProxy();
            String barDir = "/bar";
            client.mkdirs(barDir, new FsPermission(777), true);
            client.setStoragePolicy(barDir, "HOT");
            client.setErasureCodingPolicy(barDir, StripedFileTestUtil.getDefaultECPolicy().getName());
            String fooFile = "/bar/foo";
            long fileLen = this.cellSize * this.dataBlocks;
            DFSTestUtil.createFile((FileSystem)cluster.getFileSystem(), new Path("/bar/foo"), fileLen, (short)3, 0L);
            LocatedBlocks locatedBlocks = client.getBlockLocations("/bar/foo", 0L, fileLen);
            for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                for (StorageType type : lb.getStorageTypes()) {
                    Assert.assertEquals((Object)StorageType.DISK, (Object)type);
                }
            }
            StripedFileTestUtil.verifyLocatedStripedBlocks(locatedBlocks, this.dataBlocks + this.parityBlocks);
            client.setStoragePolicy(barDir, "COLD");
            hdfsAdmin.satisfyStoragePolicy(new Path("/bar/foo"));
            LOG.info("Sets storage policy to COLD and invoked satisfyStoragePolicy");
            cluster.triggerHeartbeats();
            this.waitForAttemptedItems(1L, 30000);
            this.waitExpectedStorageType(cluster, "/bar/foo", fileLen, StorageType.DISK, 9, 9, 60000);
            this.waitForAttemptedItems(1L, 30000);
        }
        finally {
            cluster.shutdown();
            this.sps.stopGracefully();
        }
    }

    private void startSPS() throws IOException {
        this.nnc = DFSTestUtil.getNameNodeConnector(this.conf, HdfsServerConstants.MOVER_ID_PATH, 1, false);
        this.sps = new StoragePolicySatisfier(this.conf);
        this.ctxt = new ExternalSPSContext((SPSService)this.sps, this.nnc);
        this.sps.init((Context)this.ctxt);
        this.sps.start(HdfsConstants.StoragePolicySatisfierMode.EXTERNAL);
    }

    private static void initConfWithStripe(Configuration conf, int stripeBlockSize) {
        conf.setLong("dfs.blocksize", (long)stripeBlockSize);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.redundancy.interval.seconds", 1L);
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
    }

    private void waitExpectedStorageType(final MiniDFSCluster cluster, final String fileName, final long fileLen, final StorageType expectedStorageType, final int expectedStorageCount, final int expectedBlkLocationCount, int timeout) throws Exception {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                int actualStorageCount = 0;
                try {
                    LocatedBlocks locatedBlocks = cluster.getFileSystem().getClient().getLocatedBlocks(fileName, 0L, fileLen);
                    for (LocatedBlock lb : locatedBlocks.getLocatedBlocks()) {
                        LOG.info("LocatedBlocks => Size {}, locs {}", (Object)lb.getLocations().length, (Object)lb);
                        if (lb.getLocations().length > expectedBlkLocationCount) {
                            return false;
                        }
                        for (StorageType storageType : lb.getStorageTypes()) {
                            if (expectedStorageType == storageType) {
                                ++actualStorageCount;
                                continue;
                            }
                            LOG.info("Expected storage type {} and actual {}", (Object)expectedStorageType, (Object)storageType);
                        }
                    }
                    LOG.info(expectedStorageType + " replica count, expected={} and actual={}", (Object)expectedStorageCount, (Object)actualStorageCount);
                }
                catch (IOException e) {
                    LOG.error("Exception while getting located blocks", (Throwable)e);
                    return false;
                }
                return expectedStorageCount == actualStorageCount;
            }
        }, (long)100L, (long)timeout);
    }

    private void waitForAttemptedItems(final long expectedBlkMovAttemptedCount, int timeout) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                LOG.info("expectedAttemptedItemsCount={} actualAttemptedItemsCount={}", (Object)expectedBlkMovAttemptedCount, (Object)TestStoragePolicySatisfierWithStripedFile.this.sps.getAttemptedItemsMonitor().getAttemptedItemsCount());
                return (long)TestStoragePolicySatisfierWithStripedFile.this.sps.getAttemptedItemsMonitor().getAttemptedItemsCount() == expectedBlkMovAttemptedCount;
            }
        }, (long)100L, (long)timeout);
    }
}

