/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupsBalance
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsBalance.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsBalance.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsBalance.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsBalance.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testGroupBalance() throws Exception {
        String methodName = this.name.getMethodName();
        LOG.info(methodName);
        String newGroupName = this.getGroupName(methodName);
        final TableName tableName = TableName.valueOf((String)"Group_ns", (String)methodName);
        ServerName first = this.setupBalanceTest(newGroupName, tableName);
        admin.balancerSwitch(true, true);
        rsGroupAdmin.balanceRSGroup("default");
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        admin.balancerSwitch(false, true);
        Assert.assertFalse((boolean)rsGroupAdmin.balanceRSGroup(newGroupName).isBalancerRan());
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
        admin.balancerSwitch(true, true);
        rsGroupAdmin.balanceRSGroup(newGroupName);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (List<String> regions : TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName).values()) {
                    if (2 == regions.size()) continue;
                    return false;
                }
                return true;
            }
        });
        admin.balancerSwitch(false, true);
    }

    @Test
    public void testGroupDryRunBalance() throws Exception {
        String methodName = this.name.getMethodName();
        LOG.info(methodName);
        String newGroupName = this.getGroupName(methodName);
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)methodName);
        ServerName first = this.setupBalanceTest(newGroupName, tableName);
        admin.balancerSwitch(true, true);
        BalanceResponse response = rsGroupAdmin.balanceRSGroup(newGroupName, BalanceRequest.newBuilder().setDryRun(true).build());
        Assert.assertTrue((boolean)response.isBalancerRan());
        Assert.assertTrue((response.getMovesCalculated() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)response.getMovesExecuted());
        Assert.assertEquals((long)6L, (long)this.getTableServerRegionMap().get(tableName).get(first).size());
    }

    private ServerName setupBalanceTest(String newGroupName, final TableName tableName) throws Exception {
        this.addGroup(newGroupName, 3);
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", newGroupName).build());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        admin.createTable(desc, startKey, endKey, 6);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                List<String> regions = TestRSGroupsBalance.this.getTableRegionMap().get(tableName);
                if (regions == null) {
                    return false;
                }
                return regions.size() >= 6;
            }
        });
        Map<ServerName, List<String>> assignMap = this.getTableServerRegionMap().get(tableName);
        final ServerName first = assignMap.entrySet().iterator().next().getKey();
        for (RegionInfo region : admin.getRegions(tableName)) {
            if (assignMap.get(first).contains(region.getRegionNameAsString())) continue;
            admin.move(region.getEncodedNameAsBytes(), first);
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Map<ServerName, List<String>> map = TestRSGroupsBalance.this.getTableServerRegionMap().get(tableName);
                if (map == null) {
                    return true;
                }
                List<String> regions = map.get(first);
                if (regions == null) {
                    return true;
                }
                return regions.size() >= 6;
            }
        });
        return first;
    }

    @Test
    public void testMisplacedRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)"Group_testMisplacedRegions");
        LOG.info("testMisplacedRegions");
        final RSGroupInfo RSGroupInfo2 = this.addGroup("testMisplacedRegions", 1);
        TEST_UTIL.createMultiRegionTable(tableName, new byte[]{102}, 15);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        rsGroupAdminEndpoint.getGroupInfoManager().moveTables((Set)Sets.newHashSet((Object[])new TableName[]{tableName}), RSGroupInfo2.getName());
        admin.balancerSwitch(true, true);
        Assert.assertTrue((boolean)rsGroupAdmin.balanceRSGroup(RSGroupInfo2.getName()).isBalancerRan());
        admin.balancerSwitch(false, true);
        Assert.assertTrue((boolean)TestRSGroupsBalance.observer.preBalanceRSGroupCalled);
        Assert.assertTrue((boolean)TestRSGroupsBalance.observer.postBalanceRSGroupCalled);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                ServerName serverName = ServerName.valueOf((String)((Address)RSGroupInfo2.getServers().iterator().next()).toString(), (long)1L);
                return TestRSGroupsBase.admin.getConnection().getAdmin().getRegions(serverName).size() == 15;
            }
        });
    }

    @Test
    public void testGetRSGroupAssignmentsByTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY, 10);
        TableName disableTableName = TableName.valueOf((String)"testDisableTable");
        TEST_UTIL.createMultiRegionTable(disableTableName, HConstants.CATALOG_FAMILY, 10);
        TEST_UTIL.getAdmin().disableTable(disableTableName);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        Map assignments = rsGroupAdminEndpoint.getGroupAdminServer().getRSGroupAssignmentsByTable(master.getTableStateManager(), "default");
        Assert.assertFalse((boolean)assignments.containsKey(disableTableName));
        Assert.assertTrue((boolean)assignments.containsKey(tableName));
    }
}

