/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.HBCKAbstractFileStatusFilter;
import org.apache.hbase.HBCKFileStatusFilter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterators;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class HBCKFsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HBCKFsUtils.class);

    private HBCKFsUtils() {
    }

    public static Path getTableDir(Path rootdir, TableName tableName) {
        return new Path(HBCKFsUtils.getNamespaceDir(rootdir, tableName.getNamespaceAsString()), tableName.getQualifierAsString());
    }

    public static Path getNamespaceDir(Path rootdir, String namespace) {
        return new Path(rootdir, new Path("data", new Path(namespace)));
    }

    public static Path getRootDir(Configuration c) throws IOException {
        Path p = new Path(c.get("hbase.rootdir"));
        FileSystem fs = p.getFileSystem(c);
        return p.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public static List<Path> copyFilesParallel(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, Configuration conf, int threads) throws IOException {
        List<Path> traversedPaths;
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            traversedPaths = HBCKFsUtils.copyFiles(srcFS, src, dstFS, dst, conf, pool, futures);
            for (Future future : futures) {
                future.get();
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new IOException("Copy snapshot reference files failed", e);
        }
        finally {
            pool.shutdownNow();
        }
        return traversedPaths;
    }

    private static List<Path> copyFiles(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, Configuration conf, ExecutorService pool, List<Future<Void>> futures) throws IOException {
        ArrayList<Path> traversedPaths = new ArrayList<Path>();
        traversedPaths.add(dst);
        FileStatus currentFileStatus = srcFS.getFileStatus(src);
        if (currentFileStatus.isDirectory()) {
            FileStatus[] subPaths;
            if (!dstFS.mkdirs(dst)) {
                throw new IOException("Create directory failed: " + dst);
            }
            for (FileStatus subPath : subPaths = srcFS.listStatus(src)) {
                traversedPaths.addAll(HBCKFsUtils.copyFiles(srcFS, subPath.getPath(), dstFS, new Path(dst, subPath.getPath().getName()), conf, pool, futures));
            }
        } else {
            Future<Void> future = pool.submit(() -> {
                FileUtil.copy((FileSystem)srcFS, (Path)src, (FileSystem)dstFS, (Path)dst, (boolean)false, (boolean)false, (Configuration)conf);
                return null;
            });
            futures.add(future);
        }
        return traversedPaths;
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir, PathFilter filter) throws IOException {
        FileStatus[] status;
        block3: {
            status = null;
            try {
                status = filter == null ? fs.listStatus(dir) : fs.listStatus(dir, filter);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace(dir + " doesn't exist");
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        return status;
    }

    public static boolean delete(FileSystem fs, Path path, boolean recursive) throws IOException {
        return fs.delete(path, recursive);
    }

    public static boolean deleteDirectory(FileSystem fs, Path dir) throws IOException {
        return fs.exists(dir) && fs.delete(dir, true);
    }

    public static List<Path> getRegionDirs(FileSystem fs, Path tableDir) throws IOException {
        List<FileStatus> rds = HBCKFsUtils.listStatusWithStatusFilter(fs, tableDir, new RegionDirFilter(fs));
        if (rds == null) {
            return new ArrayList<Path>();
        }
        ArrayList<Path> regionDirs = new ArrayList<Path>(rds.size());
        for (FileStatus rdfs : rds) {
            Path rdPath = rdfs.getPath();
            regionDirs.add(rdPath);
        }
        return regionDirs;
    }

    public static List<FileStatus> listStatusWithStatusFilter(FileSystem fs, Path dir, HBCKFileStatusFilter filter) throws IOException {
        FileStatus[] status;
        block5: {
            status = null;
            try {
                status = fs.listStatus(dir);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block5;
                LOG.trace(dir + " doesn't exist");
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        if (filter == null) {
            return Arrays.asList(status);
        }
        List<FileStatus> status2 = HBCKFsUtils.filterFileStatuses(status, filter);
        if (status2 == null || status2.isEmpty()) {
            return null;
        }
        return status2;
    }

    public static List<FileStatus> filterFileStatuses(FileStatus[] input, HBCKFileStatusFilter filter) {
        if (input == null) {
            return null;
        }
        return HBCKFsUtils.filterFileStatuses((Iterator<FileStatus>)Iterators.forArray((Object[])input), filter);
    }

    public static List<FileStatus> filterFileStatuses(Iterator<FileStatus> input, HBCKFileStatusFilter filter) {
        if (input == null) {
            return null;
        }
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        while (input.hasNext()) {
            FileStatus f = input.next();
            if (!filter.accept(f)) continue;
            results.add(f);
        }
        return results;
    }

    public static class RegionDirFilter
    extends HBCKAbstractFileStatusFilter {
        public static final Pattern regionDirPattern = Pattern.compile("^[0-9a-f]*$");
        final FileSystem fs;

        public RegionDirFilter(FileSystem fs) {
            this.fs = fs;
        }

        @Override
        protected boolean accept(Path p, @CheckForNull Boolean isDir) {
            if (!regionDirPattern.matcher(p.getName()).matches()) {
                return false;
            }
            try {
                return this.isDirectory(this.fs, isDir, p);
            }
            catch (IOException ioe) {
                LOG.warn("Skipping file " + p + " due to IOException", ioe);
                return false;
            }
        }
    }

    public static class FamilyDirFilter
    extends HBCKAbstractFileStatusFilter {
        final FileSystem fs;

        public FamilyDirFilter(FileSystem fs) {
            this.fs = fs;
        }

        @Override
        protected boolean accept(Path p, @CheckForNull Boolean isDir) {
            try {
                ColumnFamilyDescriptorBuilder.isLegalColumnFamilyName((byte[])Bytes.toBytes((String)p.getName()));
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
            try {
                return this.isDirectory(this.fs, isDir, p);
            }
            catch (IOException ioe) {
                LOG.warn("Skipping file " + p + " due to IOException", ioe);
                return false;
            }
        }
    }
}

