/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StripeStoreEngine;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.PressureAwareFlushThroughputController;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestFlushWithThroughputController {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushWithThroughputController.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFlushWithThroughputController.class);
    private static final double EPSILON = 1.3E-6;
    private HBaseTestingUtility hbtu;
    @Rule
    public TestName testName = new TestName();
    private TableName tableName;
    private final byte[] family = Bytes.toBytes((String)"f");
    private final byte[] qualifier = Bytes.toBytes((String)"q");

    @Before
    public void setUp() {
        this.hbtu = new HBaseTestingUtility();
        this.tableName = TableName.valueOf((String)("Table-" + this.testName.getMethodName()));
        this.hbtu.getConfiguration().set("hbase.regionserver.flush.throughput.controller", PressureAwareFlushThroughputController.class.getName());
    }

    @After
    public void tearDown() throws Exception {
        this.hbtu.shutdownMiniCluster();
    }

    private HStore getStoreWithName(TableName tableName) {
        MiniHBaseCluster cluster = this.hbtu.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator iterator = hrs.getRegions(tableName).iterator();
            if (!iterator.hasNext()) continue;
            Region region = (Region)iterator.next();
            return (HStore)((HRegion)region).getStores().iterator().next();
        }
        return null;
    }

    private void setMaxMinThroughputs(long max, long min) {
        Configuration conf = this.hbtu.getConfiguration();
        conf.setLong("hbase.hstore.flush.throughput.lower.bound", min);
        conf.setLong("hbase.hstore.flush.throughput.upper.bound", max);
    }

    private Pair<Double, Long> generateAndFlushData(Table table) throws IOException {
        int NUM_FLUSHES = 3;
        int NUM_PUTS = 50;
        int VALUE_SIZE = 204800;
        long duration = 0L;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 50; ++j) {
                byte[] value = new byte[204800];
                Bytes.random((byte[])value);
                table.put(new Put(Bytes.toBytes((int)(i * 10 + j))).addColumn(this.family, this.qualifier, value));
            }
            long startTime = System.nanoTime();
            this.hbtu.getHBaseCluster().getRegions(this.tableName).stream().findFirst().ifPresent(r -> {
                try {
                    r.flush(true);
                }
                catch (IOException e) {
                    LOG.error("Failed flush region {}", r, (Object)e);
                    Assert.fail((String)("Failed flush region " + r.getRegionInfo().getRegionNameAsString()));
                }
            });
            duration += System.nanoTime() - startTime;
        }
        HStore store = this.getStoreWithName(this.tableName);
        Assert.assertEquals((long)3L, (long)store.getStorefilesCount());
        double throughput = (double)store.getStorefilesSize() / (double)TimeUnit.NANOSECONDS.toSeconds(duration);
        return new Pair((Object)throughput, (Object)duration);
    }

    private long testFlushWithThroughputLimit() throws Exception {
        long throughputLimit = 0x100000L;
        this.setMaxMinThroughputs(0x100000L, 0x100000L);
        Configuration conf = this.hbtu.getConfiguration();
        conf.setLong("hbase.hstore.flush.throughput.control.check.interval", 0x100000L);
        this.hbtu.startMiniCluster(1);
        Table table = this.hbtu.createTable(this.tableName, this.family);
        Pair<Double, Long> result = this.generateAndFlushData(table);
        this.hbtu.deleteTable(this.tableName);
        LOG.debug("Throughput is: " + (Double)result.getFirst() / 1024.0 / 1024.0 + " MB/s");
        Assert.assertTrue(((Double)result.getFirst() < 1258291.2 ? 1 : 0) != 0);
        Assert.assertTrue(((Double)result.getFirst() > 838860.8 ? 1 : 0) != 0);
        return (Long)result.getSecond();
    }

    @Test
    public void testFlushControl() throws Exception {
        this.testFlushWithThroughputLimit();
    }

    @Test
    public void testFlushThroughputTuning() throws Exception {
        Configuration conf = this.hbtu.getConfiguration();
        this.setMaxMinThroughputs(0x1400000L, 0xA00000L);
        conf.set("hbase.hstore.engine.class", DefaultStoreEngine.class.getName());
        conf.setInt("hbase.hstore.flush.throughput.tune.period", 3000);
        this.hbtu.startMiniCluster(1);
        Connection conn = ConnectionFactory.createConnection((Configuration)conf);
        this.hbtu.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])this.family)).setCompactionEnabled(false).build());
        this.hbtu.waitTableAvailable(this.tableName);
        HRegionServer regionServer = this.hbtu.getRSForFirstRegionInTable(this.tableName);
        double pressure = regionServer.getFlushPressure();
        LOG.debug("Flush pressure before flushing: " + pressure);
        PressureAwareFlushThroughputController throughputController = (PressureAwareFlushThroughputController)regionServer.getFlushThroughputController();
        for (HRegion region : regionServer.getRegions()) {
            region.flush(true);
        }
        Assert.assertTrue((regionServer.getFlushPressure() < pressure ? 1 : 0) != 0);
        Thread.sleep(5000L);
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)this.hbtu.getConfiguration());
        if (tablesOnMaster) {
            Assert.assertEquals((double)1.048576E7, (double)throughputController.getMaxThroughput(), (double)1.3E-6);
        }
        Table table = conn.getTable(this.tableName);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                byte[] value = new byte[262144];
                Bytes.random((byte[])value);
                table.put(new Put(Bytes.toBytes((int)(i * 10 + j))).addColumn(this.family, this.qualifier, value));
            }
        }
        Thread.sleep(5000L);
        double expectedThroughPut = 1.048576E7 * (1.0 + regionServer.getFlushPressure());
        Assert.assertEquals((double)expectedThroughPut, (double)throughputController.getMaxThroughput(), (double)1.3E-6);
        conf.set("hbase.regionserver.flush.throughput.controller", NoLimitThroughputController.class.getName());
        regionServer.onConfigurationChange(conf);
        Assert.assertTrue((boolean)throughputController.isStopped());
        Assert.assertTrue((boolean)(regionServer.getFlushThroughputController() instanceof NoLimitThroughputController));
        conn.close();
    }

    @Test
    public void testFlushControlForStripedStore() throws Exception {
        this.hbtu.getConfiguration().set("hbase.hstore.engine.class", StripeStoreEngine.class.getName());
        this.testFlushWithThroughputLimit();
    }
}

