/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.quotas.TestNoopOperationQuota;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestScannerLeaseCount {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerLeaseCount.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"ScannerLeaseCount");
    private static final byte[] FAM = Bytes.toBytes((String)"Fam");
    private static final String SCAN_IDENTIFIER_NAME = "_scan_id_";
    private static final byte[] SCAN_IDENTIFIER = Bytes.toBytes((String)"_scan_id_");
    private static final Scan SCAN = new Scan().setAttribute("_scan_id_", SCAN_IDENTIFIER);
    private static volatile boolean SHOULD_THROW = false;
    private static final AtomicBoolean EXCEPTION_THROWN = new AtomicBoolean(false);
    private static final AtomicBoolean SCAN_SEEN = new AtomicBoolean(false);
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().rsClass(MockedQuotaManagerRegionServer.class).build();
        UTIL.startMiniCluster(option);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM)).build());
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setInt("hbase.client.retries.number", 1);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
        UTIL.loadTable(TABLE, FAM);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try {
            TABLE.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CONN.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() {
        SHOULD_THROW = false;
        SCAN_SEEN.set(false);
        EXCEPTION_THROWN.set(false);
    }

    @Test
    public void itIncreasesScannerCount() throws Exception {
        try (ResultScanner scanner = TABLE.getScanner(SCAN);){
            scanner.next();
            UTIL.waitFor(1000L, () -> SCAN_SEEN.get() && !EXCEPTION_THROWN.get());
        }
    }

    @Test
    public void itDoesNotIncreaseScannerLeaseCount() throws Exception {
        SHOULD_THROW = true;
        try (ResultScanner scanner = TABLE.getScanner(SCAN);){
            Exception e = (Exception)Assert.assertThrows(RetriesExhaustedException.class, () -> ((ResultScanner)scanner).next());
            Throwable[] throwables = ExceptionUtils.getThrowables((Throwable)e);
            boolean foundThrottleException = false;
            for (Throwable throwable : throwables) {
                if (!(throwable instanceof RpcThrottlingException)) continue;
                foundThrottleException = true;
            }
            Assert.assertTrue((boolean)foundThrottleException);
            UTIL.waitFor(1000L, () -> !SCAN_SEEN.get() && EXCEPTION_THROWN.get());
        }
    }

    private static boolean isTestScan(ClientProtos.ScanRequest request) {
        ClientProtos.Scan scan = request.getScan();
        return scan.getAttributeList().stream().anyMatch(nbp -> nbp.getName().equals(SCAN_IDENTIFIER_NAME) && Bytes.equals((byte[])nbp.getValue().toByteArray(), (byte[])SCAN_IDENTIFIER));
    }

    private static class ScannerTrackingRSRpcServicesForTest
    extends RSRpcServices {
        public ScannerTrackingRSRpcServicesForTest(HRegionServer rs) throws IOException {
            super(rs);
        }

        RSRpcServices.RegionScannerContext checkQuotaAndGetRegionScannerContext(ClientProtos.ScanRequest request, ClientProtos.ScanResponse.Builder builder) throws IOException {
            RSRpcServices.RegionScannerContext rsx = super.checkQuotaAndGetRegionScannerContext(request, builder);
            if (TestScannerLeaseCount.isTestScan(request)) {
                SCAN_SEEN.set(true);
            }
            return rsx;
        }
    }

    private static class MockedRpcQuotaManager
    extends RegionServerRpcQuotaManager {
        private static final RpcThrottlingException EX = new RpcThrottlingException("test_ex");

        public MockedRpcQuotaManager(RegionServerServices rsServices) {
            super(rsServices);
        }

        public OperationQuota checkScanQuota(Region region, ClientProtos.ScanRequest scanRequest, long maxScannerResultSize, long maxBlockBytesScanned, long prevBlockBytesScannedDifference) throws IOException, RpcThrottlingException {
            if (TestScannerLeaseCount.isTestScan(scanRequest) && SHOULD_THROW) {
                EXCEPTION_THROWN.set(true);
                throw EX;
            }
            return TestNoopOperationQuota.INSTANCE;
        }

        public OperationQuota checkBatchQuota(Region region, OperationQuota.OperationType type) throws IOException, RpcThrottlingException {
            if (SHOULD_THROW) {
                throw EX;
            }
            return TestNoopOperationQuota.INSTANCE;
        }

        public OperationQuota checkBatchQuota(Region region, List<ClientProtos.Action> actions, boolean hasCondition) throws IOException, RpcThrottlingException {
            if (SHOULD_THROW) {
                throw EX;
            }
            return TestNoopOperationQuota.INSTANCE;
        }

        public OperationQuota checkBatchQuota(Region region, int numWrites, int numReads) throws IOException, RpcThrottlingException {
            if (SHOULD_THROW) {
                throw EX;
            }
            return TestNoopOperationQuota.INSTANCE;
        }
    }

    public static final class MockedQuotaManagerRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        private final MockedRpcQuotaManager rpcQuotaManager = new MockedRpcQuotaManager((RegionServerServices)this);

        public MockedQuotaManagerRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public RegionServerRpcQuotaManager getRegionServerRpcQuotaManager() {
            return this.rpcQuotaManager;
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new ScannerTrackingRSRpcServicesForTest(this);
        }
    }
}

