/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestQuotaCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaCache.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int REFRESH_TIME = 30000;

    @After
    public void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
        EnvironmentEdgeManager.reset();
        TEST_UTIL.shutdownMiniCluster();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 30000);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.default.user.machine.read.num", 1000);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @Test
    public void testDefaultUserRefreshFrequency() throws Exception {
        QuotaCache.TEST_BLOCK_REFRESH = true;
        QuotaCache quotaCache = (QuotaCache)ThrottleQuotaTestUtil.getQuotaCaches(TEST_UTIL).stream().findAny().get();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserQuotaState userQuotaState = quotaCache.getUserQuotaState(ugi);
        Assert.assertEquals((long)userQuotaState.getLastUpdate(), (long)0L);
        QuotaCache.TEST_BLOCK_REFRESH = false;
        TEST_UTIL.waitFor(5000L, () -> userQuotaState.getLastUpdate() != 0L);
        long lastUpdate = userQuotaState.getLastUpdate();
        quotaCache.triggerCacheRefresh();
        Thread.sleep(250L);
        long newLastUpdate = userQuotaState.getLastUpdate();
        Assert.assertEquals((long)lastUpdate, (long)newLastUpdate);
        quotaCache.triggerCacheRefresh();
        ThrottleQuotaTestUtil.waitMinuteQuota();
        TEST_UTIL.waitFor(5000L, () -> lastUpdate != userQuotaState.getLastUpdate());
    }
}

