/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, MediumTests.class})
public class TestPrefetchWithBucketCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestPrefetchWithBucketCache.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPrefetchWithBucketCache.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final int DATA_BLOCK_SIZE = 2048;
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;
    private BlockCache blockCache;

    @Before
    public void setUp() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.fs = HFileSystem.get((Configuration)this.conf);
        File testDir = new File(this.name.getMethodName());
        testDir.mkdir();
        this.conf.set("hbase.bucketcache.ioengine", "file:/" + testDir.getAbsolutePath() + "/bucket.cache");
    }

    @After
    public void tearDown() {
        File cacheFile = new File(this.name.getMethodName() + "/bucket.cache");
        File dir = new File(this.name.getMethodName());
        cacheFile.delete();
        dir.delete();
    }

    @Test
    public void testPrefetchDoesntOverwork() throws Exception {
        this.conf.setLong("hbase.bucketcache.size", 200L);
        this.blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        this.cacheConf = new CacheConfig(this.conf, this.blockCache);
        Path storeFile = this.writeStoreFile("TestPrefetchDoesntOverwork", 100);
        LOG.debug("First read should prefetch the blocks.");
        this.readStoreFile(storeFile);
        BucketCache bc = (BucketCache)BucketCache.getBucketCacheFromCacheConfig((CacheConfig)this.cacheConf).get();
        Waiter.waitFor((Configuration)this.conf, (long)300L, () -> bc.getBackingMap().size() == 6);
        ImmutableMap snapshot = ImmutableMap.copyOf((Map)bc.getBackingMap());
        LOG.debug("Second read, no prefetch should happen here.");
        this.readStoreFile(storeFile);
        snapshot.entrySet().forEach(e -> {
            BucketEntry entry = (BucketEntry)bc.getBackingMap().get(e.getKey());
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)((BucketEntry)e.getValue()).getCachedTime(), (long)entry.getCachedTime());
        });
        BlockCacheKey key = (BlockCacheKey)snapshot.keySet().stream().findFirst().get();
        LOG.debug("removing block {}", (Object)key);
        bc.getBackingMap().remove(key);
        ((Map)bc.getFullyCachedFiles().get()).remove(storeFile.getName());
        Assert.assertTrue((snapshot.size() > bc.getBackingMap().size() ? 1 : 0) != 0);
        LOG.debug("Third read should prefetch again, as we removed one block for the file.");
        this.readStoreFile(storeFile);
        Waiter.waitFor((Configuration)this.conf, (long)300L, () -> TestPrefetchWithBucketCache.lambda$testPrefetchDoesntOverwork$2((Map)snapshot, bc));
        Assert.assertTrue((((BucketEntry)snapshot.get(key)).getCachedTime() < ((BucketEntry)bc.getBackingMap().get(key)).getCachedTime() ? 1 : 0) != 0);
    }

    @Test
    public void testPrefetchInterruptOnCapacity() throws Exception {
        this.conf.setLong("hbase.bucketcache.size", 1L);
        this.conf.set("hbase.bucketcache.bucket.sizes", "3072");
        this.conf.setDouble("hbase.bucketcache.acceptfactor", 0.98);
        this.conf.setDouble("hbase.bucketcache.minfactor", 0.95);
        this.conf.setDouble("hbase.bucketcache.extrafreefactor", 0.01);
        this.blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        this.cacheConf = new CacheConfig(this.conf, this.blockCache);
        Path storeFile = this.writeStoreFile("testPrefetchInterruptOnCapacity", 10000);
        LOG.debug("First read should prefetch the blocks.");
        this.createReaderAndWaitForPrefetchInterruption(storeFile);
        BucketCache bc = (BucketCache)BucketCache.getBucketCacheFromCacheConfig((CacheConfig)this.cacheConf).get();
        long evictionsFirstPrefetch = bc.getStats().getEvictionCount();
        LOG.debug("evictions after first prefetch: {}", (Object)bc.getStats().getEvictionCount());
        HFile.Reader reader = this.createReaderAndWaitForPrefetchInterruption(storeFile);
        LOG.debug("evictions after second prefetch: {}", (Object)bc.getStats().getEvictionCount());
        Assert.assertTrue((bc.getStats().getEvictionCount() - evictionsFirstPrefetch < 10L ? 1 : 0) != 0);
        HFileScanner scanner = reader.getScanner(this.conf, true, true);
        scanner.seekTo();
        while (scanner.next()) {
            LOG.trace("Iterating the full scan to evict some blocks");
        }
        scanner.close();
        LOG.debug("evictions after scanner: {}", (Object)bc.getStats().getEvictionCount());
        Assert.assertTrue((bc.getStats().getEvictionCount() > evictionsFirstPrefetch ? 1 : 0) != 0);
    }

    @Test
    public void testPrefetchDoesntInterruptInMemoryOnCapacity() throws Exception {
        this.conf.setLong("hbase.bucketcache.size", 1L);
        this.conf.set("hbase.bucketcache.bucket.sizes", "3072");
        this.conf.setDouble("hbase.bucketcache.acceptfactor", 0.98);
        this.conf.setDouble("hbase.bucketcache.minfactor", 0.95);
        this.conf.setDouble("hbase.bucketcache.extrafreefactor", 0.01);
        this.blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        ColumnFamilyDescriptor family = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f")).setInMemory(true).build();
        this.cacheConf = new CacheConfig(this.conf, family, this.blockCache, ByteBuffAllocator.HEAP);
        Path storeFile = this.writeStoreFile("testPrefetchDoesntInterruptInMemoryOnCapacity", 10000);
        LOG.debug("First read should prefetch the blocks.");
        this.createReaderAndWaitForPrefetchInterruption(storeFile);
        BucketCache bc = (BucketCache)BucketCache.getBucketCacheFromCacheConfig((CacheConfig)this.cacheConf).get();
        Assert.assertTrue((bc.getStats().getEvictedCount() > 200L ? 1 : 0) != 0);
    }

    @Test
    public void testPrefetchMetricProgress() throws Exception {
        this.conf.setLong("hbase.bucketcache.size", 200L);
        this.blockCache = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        this.cacheConf = new CacheConfig(this.conf, this.blockCache);
        Path storeFile = this.writeStoreFile("testPrefetchMetricsProgress", 100);
        LOG.debug("First read should prefetch the blocks.");
        this.readStoreFile(storeFile);
        String regionName = storeFile.getParent().getParent().getName();
        BucketCache bc = (BucketCache)BucketCache.getBucketCacheFromCacheConfig((CacheConfig)this.cacheConf).get();
        MutableLong regionCachedSize = new MutableLong(0L);
        long waitedTime = Waiter.waitFor((Configuration)this.conf, (long)300L, () -> {
            if (bc.getBackingMap().size() > 0) {
                long currentSize = (Long)((Map)bc.getRegionCachedInfo().get()).get(regionName);
                Assert.assertTrue((regionCachedSize.getValue() <= currentSize ? 1 : 0) != 0);
                LOG.debug("Logging progress of region caching: {}", (Object)currentSize);
                regionCachedSize.setValue(currentSize);
            }
            return bc.getBackingMap().size() == 6;
        });
    }

    private void readStoreFile(Path storeFilePath) throws Exception {
        this.readStoreFile(storeFilePath, (r, o) -> {
            HFileBlock block = null;
            try {
                block = r.readBlock(o.longValue(), -1L, false, true, false, true, null, null);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            return block;
        }, (key, block) -> {
            boolean isCached;
            boolean bl = isCached = this.blockCache.getBlock(key, true, false, true) != null;
            if (block.getBlockType() == BlockType.DATA || block.getBlockType() == BlockType.ROOT_INDEX || block.getBlockType() == BlockType.INTERMEDIATE_INDEX) {
                Assert.assertTrue((boolean)isCached);
            }
        });
    }

    private void readStoreFile(Path storeFilePath, BiFunction<HFile.Reader, Long, HFileBlock> readFunction, BiConsumer<BlockCacheKey, HFileBlock> validationFunction) throws Exception {
        HFileBlock block;
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)storeFilePath, (CacheConfig)this.cacheConf, (boolean)true, (Configuration)this.conf);
        while (!reader.prefetchComplete()) {
            Thread.sleep(1000L);
        }
        long sizeForDataBlocks = 0L;
        for (long offset = 0L; offset < reader.getTrailer().getLoadOnOpenDataOffset(); offset += (long)block.getOnDiskSizeWithHeader()) {
            block = readFunction.apply(reader, offset);
            BlockCacheKey blockCacheKey = new BlockCacheKey(reader.getName(), offset);
            validationFunction.accept(blockCacheKey, block);
        }
    }

    private HFile.Reader createReaderAndWaitForPrefetchInterruption(Path storeFilePath) throws Exception {
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)storeFilePath, (CacheConfig)this.cacheConf, (boolean)true, (Configuration)this.conf);
        while (!reader.prefetchComplete()) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)0L, (long)((Map)((BucketCache)BucketCache.getBucketCacheFromCacheConfig((CacheConfig)this.cacheConf).get()).getFullyCachedFiles().get()).size());
        return reader;
    }

    private Path writeStoreFile(String fname, int numKVs) throws IOException {
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        return this.writeStoreFile(fname, meta, numKVs);
    }

    private Path writeStoreFile(String fname, HFileContext context, int numKVs) throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), fname);
        StoreFileWriter sfw = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withFileContext(context).build();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int rowLen = 32;
        for (int i = 0; i < numKVs; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] v = RandomKeyValueUtil.randomValue(rand);
            int cfLen = ((Random)rand).nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, ((Random)rand).nextLong(), TestPrefetchWithBucketCache.generateKeyType(rand), v, 0, v.length);
            sfw.append((Cell)kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }

    private static /* synthetic */ boolean lambda$testPrefetchDoesntOverwork$2(Map snapshot, BucketCache bc) throws Exception {
        return snapshot.size() == bc.getBackingMap().size();
    }
}

