/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.OperationTimeoutExceededException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.function.ThrowingRunnable;

@Category(value={ClientTests.class, MediumTests.class})
public class TestClientOperationTimeout {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientOperationTimeout.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int DELAY_GET;
    private static int DELAY_SCAN;
    private static int DELAY_MUTATE;
    private static int DELAY_BATCH;
    private static int DELAY_META_SCAN;
    private static boolean FAIL_BATCH;
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] ROW;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUpClass() throws Exception {
        StartMiniClusterOption option = StartMiniClusterOption.builder().rsClass(DelayedRegionServer.class).build();
        UTIL.startMiniCluster(option);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.operation.timeout", 500L);
        conf.setLong("hbase.client.meta.operation.timeout", 500L);
        conf.setLong("hbase.client.scanner.timeout.period", 500L);
        conf.setLong("hbase.client.retries.number", 1L);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
    }

    @Before
    public void setUp() throws Exception {
        DELAY_GET = 0;
        DELAY_SCAN = 0;
        DELAY_MUTATE = 0;
        DELAY_BATCH = 0;
        DELAY_META_SCAN = 0;
        FAIL_BATCH = false;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)TABLE, (boolean)true);
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetTimeout() {
        DELAY_GET = 600;
        try {
            TABLE.get(new Get(ROW));
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof SocketTimeoutException && e.getCause() instanceof CallTimeoutException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPutTimeout() {
        DELAY_MUTATE = 600;
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        try {
            TABLE.put(put);
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof SocketTimeoutException && e.getCause() instanceof CallTimeoutException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiTimeout() {
        DELAY_BATCH = 600;
        Put put1 = new Put(ROW);
        put1.addColumn(FAMILY, QUALIFIER, VALUE);
        Put put2 = new Put(ROW);
        put2.addColumn(FAMILY, QUALIFIER, VALUE);
        ArrayList<Put> puts = new ArrayList<Put>();
        puts.add(put1);
        puts.add(put2);
        this.assertMultiException(() -> TABLE.batch(puts, new Object[2]));
        Get get1 = new Get(ROW);
        get1.addColumn(FAMILY, QUALIFIER);
        Get get2 = new Get(ROW);
        get2.addColumn(FAMILY, QUALIFIER);
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(get1);
        gets.add(get2);
        this.assertMultiException(() -> TABLE.batch(gets, new Object[2]));
    }

    private void assertMultiException(ThrowingRunnable runnable) {
        IOException e = (IOException)Assert.assertThrows(IOException.class, (ThrowingRunnable)runnable);
        if (e instanceof SocketTimeoutException) {
            return;
        }
        Assert.assertTrue((String)("Expected SocketTimeoutException or RetriesExhaustedWithDetailsException but was " + e.getClass()), (boolean)(e instanceof RetriesExhaustedWithDetailsException));
        for (Throwable cause : ((RetriesExhaustedWithDetailsException)((Object)e)).getCauses()) {
            Assert.assertEquals(OperationTimeoutExceededException.class, cause.getClass());
        }
    }

    @Test
    public void testMultiGetMetaTimeout() throws IOException {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.operation.timeout", 400L);
        conf.setBoolean("hbase.client.metrics.enable", true);
        try (Connection specialConnection = ConnectionFactory.createConnection((Configuration)conf);
             Table specialTable = specialConnection.getTable(TABLE_NAME);){
            MetricsConnection metrics = ((ConnectionImplementation)specialConnection).getConnectionMetrics();
            long metaCacheNumClearServerPreFailure = metrics.getMetaCacheNumClearServer().getCount();
            DELAY_META_SCAN = 400;
            ArrayList<Get> gets = new ArrayList<Get>();
            for (int i = 0; i < 100; ++i) {
                gets.add(new Get(Bytes.toBytes((int)i)).addColumn(FAMILY, QUALIFIER));
            }
            try {
                specialTable.get(gets);
                Assert.fail((String)"should not reach here");
            }
            catch (Exception e) {
                RetriesExhaustedWithDetailsException expected = (RetriesExhaustedWithDetailsException)((Object)e);
                Assert.assertEquals((long)100L, (long)expected.getNumExceptions());
                long metaCacheNumClearServerPostFailure = metrics.getMetaCacheNumClearServer().getCount();
                Assert.assertEquals((long)metaCacheNumClearServerPreFailure, (long)metaCacheNumClearServerPostFailure);
                for (Throwable cause : expected.getCauses()) {
                    Assert.assertTrue((boolean)(cause instanceof OperationTimeoutExceededException));
                    Assert.assertTrue((boolean)cause.getMessage().contains("Operation timeout exceeded during"));
                }
            }
        }
    }

    @Test
    public void testMultiGetRetryTimeout() {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.operation.timeout", 500L);
        conf.setInt("hbase.client.retries.number", 1);
        conf.setLong("hbase.client.pause", 0L);
        conf.setBoolean("hbase.client.metrics.enable", true);
        try (Connection specialConnection = ConnectionFactory.createConnection((Configuration)conf);
             Table specialTable = specialConnection.getTable(TABLE_NAME);){
            MetricsConnection metrics = ((ConnectionImplementation)specialConnection).getConnectionMetrics();
            long metaCacheNumClearServerPreFailure = metrics.getMetaCacheNumClearRegion().getCount();
            DELAY_META_SCAN = 300;
            FAIL_BATCH = true;
            ArrayList<Get> gets = new ArrayList<Get>();
            gets.add(new Get(Bytes.toBytes((int)0)).addColumn(FAMILY, QUALIFIER));
            try {
                specialTable.batch(gets, new Object[1]);
                Assert.fail((String)"should not reach here");
            }
            catch (Exception e) {
                RetriesExhaustedWithDetailsException expected = (RetriesExhaustedWithDetailsException)((Object)e);
                Assert.assertEquals((long)1L, (long)expected.getNumExceptions());
                long metaCacheNumClearServerPostFailure = metrics.getMetaCacheNumClearRegion().getCount();
                Assert.assertEquals((long)(metaCacheNumClearServerPreFailure + 1L), (long)metaCacheNumClearServerPostFailure);
                for (Throwable cause : expected.getCauses()) {
                    Assert.assertTrue((boolean)(cause instanceof OperationTimeoutExceededException));
                    Assert.assertTrue((boolean)cause.getMessage().contains("Timeout exceeded before call began"));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testScanTimeout() {
        DELAY_SCAN = 600;
        try {
            ResultScanner scanner = TABLE.getScanner(new Scan());
            scanner.next();
            Assert.fail((String)"should not reach here");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof RetriesExhaustedException && e.getCause() instanceof SocketTimeoutException ? 1 : 0) != 0);
        }
    }

    static {
        FAIL_BATCH = false;
        TABLE_NAME = TableName.valueOf((String)"Timeout");
        FAMILY = Bytes.toBytes((String)"family");
        ROW = Bytes.toBytes((String)"row");
        QUALIFIER = Bytes.toBytes((String)"qualifier");
        VALUE = Bytes.toBytes((String)"value");
    }

    public static class DelayedRSRpcServices
    extends RSRpcServices {
        DelayedRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_GET);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during get operation", (Throwable)e);
            }
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_MUTATE);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during mutate operation", (Throwable)e);
            }
            return super.mutate(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                String regionName = Bytes.toString((byte[])request.getRegion().getValue().toByteArray());
                if (regionName.contains(TableName.META_TABLE_NAME.getNameAsString())) {
                    Thread.sleep(DELAY_META_SCAN);
                } else {
                    Thread.sleep(DELAY_SCAN);
                }
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during scan operation", (Throwable)e);
            }
            return super.scan(controller, request);
        }

        public ClientProtos.MultiResponse multi(RpcController rpcc, ClientProtos.MultiRequest request) throws ServiceException {
            try {
                if (FAIL_BATCH) {
                    throw new ServiceException((Throwable)new NotServingRegionException("simulated failure"));
                }
                Thread.sleep(DELAY_BATCH);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during multi operation", (Throwable)e);
            }
            return super.multi(rpcc, request);
        }
    }

    private static class DelayedRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public DelayedRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new DelayedRSRpcServices(this);
        }
    }
}

