/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AggregationHelper;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AggregateImplementation<T, S, P extends Message, Q extends Message, R extends Message>
extends AggregateProtos.AggregateService
implements RegionCoprocessor {
    protected static final Logger log = LoggerFactory.getLogger(AggregateImplementation.class);
    private RegionCoprocessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMax(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        boolean hasMoreRows;
        Object max;
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                RegionScanner scanner = null;
                response = null;
                partialResultContext = new PartialResultContext();
                max = null;
                hasMoreRows = false;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            max = max == null || temp != null && ci.compare(temp, max) > 0 ? temp : max;
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                    }
                    if (max != null) {
                        AggregateProtos.AggregateResponse.Builder builder = AggregateProtos.AggregateResponse.newBuilder();
                        builder.addFirstPart(ci.getProtoForCellType(max).toByteString());
                        this.setPartialResultResponse(builder, request, hasMoreRows, partialResultContext);
                        response = builder.build();
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        log.debug("Maximum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), max, hasMoreRows, RpcServer.getRequestUser()});
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMin(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        boolean hasMoreRows;
        Object min;
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = new PartialResultContext();
                min = null;
                hasMoreRows = false;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            min = min == null || temp != null && ci.compare(temp, min) < 0 ? temp : min;
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                    }
                    if (min != null) {
                        AggregateProtos.AggregateResponse.Builder responseBuilder = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(min).toByteString());
                        this.setPartialResultResponse(responseBuilder, request, hasMoreRows, partialResultContext);
                        response = responseBuilder.build();
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        log.debug("Minimum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), min, hasMoreRows, RpcServer.getRequestUser()});
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        boolean hasMoreRows;
        long sum;
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = new PartialResultContext();
                sum = 0L;
                hasMoreRows = false;
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Object temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                            if (temp == null) continue;
                            sumVal = ci.add(sumVal, ci.castToReturnType(temp));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                    }
                    if (sumVal != null) {
                        AggregateProtos.AggregateResponse.Builder responseBuilder = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForPromotedType(sumVal).toByteString());
                        this.setPartialResultResponse(responseBuilder, request, hasMoreRows, partialResultContext);
                        response = responseBuilder.build();
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        log.debug("Sum from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), sum, hasMoreRows, RpcServer.getRequestUser()});
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRowNum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        boolean hasMoreRows;
        long counter;
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                counter = 0L;
                ArrayList<Cell> results = new ArrayList<Cell>();
                RegionScanner scanner = null;
                partialResultContext = new PartialResultContext();
                hasMoreRows = false;
                try {
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    byte[][] colFamilies = scan.getFamilies();
                    byte[] colFamily = colFamilies != null ? colFamilies[0] : null;
                    NavigableSet qualifiers = colFamilies != null ? (NavigableSet)scan.getFamilyMap().get(colFamily) : null;
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    if (scan.getFilter() == null && qualifier == null) {
                        scan.setFilter((Filter)new FirstKeyOnlyFilter());
                    }
                    scanner = this.env.getRegion().getScanner(scan);
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        hasMoreRows = scanner.next(results);
                        if (!results.isEmpty()) {
                            ++counter;
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        if (hasMoreRows) continue;
                    }
                    ByteBuffer bb = ByteBuffer.allocate(8).putLong(counter);
                    bb.rewind();
                    AggregateProtos.AggregateResponse.Builder responseBuilder = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ByteString.copyFrom((ByteBuffer)bb));
                    this.setPartialResultResponse(responseBuilder, request, hasMoreRows, partialResultContext);
                    response = responseBuilder.build();
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        log.debug("Row counter from this region is {}: {} (partial result: {}) (client {})", new Object[]{this.env.getRegion().getRegionInfo().getRegionNameAsString(), counter, hasMoreRows, RpcServer.getRequestUser()});
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAvg(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = new PartialResultContext();
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Long rowCountVal = 0L;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = false;
                    do {
                        results.clear();
                        if (this.shouldBreakForThrottling(request, scan, partialResultContext)) break;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            sumVal = ci.add(sumVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                        }
                        Long i = rowCountVal;
                        Long l = rowCountVal = Long.valueOf(rowCountVal + 1L);
                        this.postScanPartialResultUpdate(results, partialResultContext);
                    } while (hasMoreRows);
                    if (sumVal != null) {
                        ByteString first = ci.getProtoForPromotedType(sumVal).toByteString();
                        AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                        pair.addFirstPart(first);
                        ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                        bb.rewind();
                        pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        this.setPartialResultResponse(pair, request, hasMoreRows, partialResultContext);
                        response = pair.build();
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStd(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block11: {
            PartialResultContext partialResultContext;
            block10: {
                RegionScanner scanner = null;
                response = null;
                partialResultContext = new PartialResultContext();
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Object sumSqVal = null;
                    Object tempVal = null;
                    long rowCountVal = 0L;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] qualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        qualifier = (byte[])qualifiers.pollFirst();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = false;
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        tempVal = null;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        sumVal = ci.add(sumVal, tempVal);
                        sumSqVal = ci.add(sumSqVal, ci.multiply(tempVal, tempVal));
                        ++rowCountVal;
                        if (hasMoreRows) continue;
                    }
                    if (sumVal != null) {
                        ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                        ByteString first_sumSqVal = ci.getProtoForPromotedType(sumSqVal).toByteString();
                        AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                        pair.addFirstPart(first_sumVal);
                        pair.addFirstPart(first_sumSqVal);
                        ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                        bb.rewind();
                        pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                        this.setPartialResultResponse(pair, request, hasMoreRows, partialResultContext);
                        response = pair.build();
                    }
                    if (scanner == null) break block10;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block11;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMedian(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response;
        block10: {
            PartialResultContext partialResultContext;
            block9: {
                response = null;
                RegionScanner scanner = null;
                partialResultContext = new PartialResultContext();
                try {
                    ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
                    Object sumVal = null;
                    Object sumWeights = null;
                    Object tempVal = null;
                    Object tempWeight = null;
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)request.getScan());
                    scanner = this.env.getRegion().getScanner(scan);
                    byte[] colFamily = scan.getFamilies()[0];
                    NavigableSet qualifiers = (NavigableSet)scan.getFamilyMap().get(colFamily);
                    byte[] valQualifier = null;
                    byte[] weightQualifier = null;
                    if (qualifiers != null && !qualifiers.isEmpty()) {
                        valQualifier = (byte[])qualifiers.pollFirst();
                        weightQualifier = (byte[])qualifiers.pollLast();
                    }
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    boolean hasMoreRows = false;
                    while (!this.shouldBreakForThrottling(request, scan, partialResultContext)) {
                        tempVal = null;
                        tempWeight = null;
                        hasMoreRows = scanner.next(results);
                        int listSize = results.size();
                        for (int i = 0; i < listSize; ++i) {
                            Cell kv = (Cell)results.get(i);
                            tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, valQualifier, kv)));
                            if (weightQualifier == null) continue;
                            tempWeight = ci.add(tempWeight, ci.castToReturnType(ci.getValue(colFamily, weightQualifier, kv)));
                        }
                        this.postScanPartialResultUpdate(results, partialResultContext);
                        results.clear();
                        sumVal = ci.add(sumVal, tempVal);
                        sumWeights = ci.add(sumWeights, tempWeight);
                        if (hasMoreRows) continue;
                    }
                    ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                    Object s = sumWeights == null ? ci.castToReturnType(ci.getMinValue()) : sumWeights;
                    ByteString first_sumWeights = ci.getProtoForPromotedType(s).toByteString();
                    AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                    pair.addFirstPart(first_sumVal);
                    pair.addFirstPart(first_sumWeights);
                    this.setPartialResultResponse(pair, request, hasMoreRows, partialResultContext);
                    response = pair.build();
                    if (scanner == null) break block9;
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    break block10;
                }
                finally {
                    if (scanner != null) {
                        IOUtils.closeQuietly(scanner);
                    }
                    this.closeQuota(partialResultContext);
                }
                IOUtils.closeQuietly((Closeable)scanner);
            }
            this.closeQuota(partialResultContext);
        }
        done.run(response);
    }

    private boolean shouldBreakForThrottling(AggregateProtos.AggregateRequest request, Scan scan, PartialResultContext context) throws IOException {
        if (request.getClientSupportsPartialResult()) {
            long maxBlockBytesScanned = context.quota == null ? Long.MAX_VALUE : context.quota.getMaxResultSize();
            try {
                context.quota = this.env.checkScanQuota(scan, maxBlockBytesScanned, context.previousReadConsumedDifference);
            }
            catch (RpcThrottlingException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Ending early for throttling for region {}", (Object)this.env.getRegion().getRegionInfo().getRegionNameAsString());
                }
                context.waitIntervalMs = e.getWaitInterval();
                return true;
            }
        }
        return false;
    }

    private void postScanPartialResultUpdate(List<Cell> results, PartialResultContext context) {
        if (context.quota != null) {
            context.quota.addScanResultCells(results);
        }
        if (!results.isEmpty()) {
            Cell result = results.get(results.size() - 1);
            PartialResultContext.access$402(context, result.getRowArray());
            context.lastRowSuccessfullyProcessedOffset = result.getRowOffset();
            context.lastRowSuccessfullyProcessedLength = result.getRowLength();
        }
    }

    private void setPartialResultResponse(AggregateProtos.AggregateResponse.Builder builder, AggregateProtos.AggregateRequest request, boolean hasMoreRows, PartialResultContext context) throws IOException {
        if (request.getClientSupportsPartialResult() && hasMoreRows) {
            if (context.lastRowSuccessfullyProcessedArray != null) {
                byte[] lastRowSuccessfullyProcessed = Arrays.copyOfRange(context.lastRowSuccessfullyProcessedArray, context.lastRowSuccessfullyProcessedOffset, context.lastRowSuccessfullyProcessedOffset + context.lastRowSuccessfullyProcessedLength);
                builder.setNextChunkStartRow(ByteString.copyFrom((byte[])ClientUtil.calculateTheClosestNextRowKeyForPrefix((byte[])lastRowSuccessfullyProcessed)));
            }
            builder.setWaitIntervalMs(context.waitIntervalMs);
        }
    }

    ColumnInterpreter<T, S, P, Q, R> constructColumnInterpreterFromRequest(AggregateProtos.AggregateRequest request) throws IOException {
        String className = request.getInterpreterClassName();
        try {
            Class<?> cls = Class.forName(className);
            ColumnInterpreter ci = (ColumnInterpreter)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (request.hasInterpreterSpecificBytes()) {
                ByteString b = request.getInterpreterSpecificBytes();
                Object initMsg = AggregationHelper.getParsedGenericInstance(ci.getClass(), 2, b);
                ci.initialize(initMsg);
            }
            return ci;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private void closeQuota(PartialResultContext context) {
        if (context != null && context.quota != null) {
            context.quota.close();
            long readConsumed = context.quota.getReadConsumed();
            context.previousReadConsumedDifference = readConsumed - context.previousReadConsumed;
            context.previousReadConsumed = readConsumed;
        }
    }

    private static final class PartialResultContext {
        private OperationQuota quota = null;
        private long waitIntervalMs = 0L;
        private byte[] lastRowSuccessfullyProcessedArray = null;
        private int lastRowSuccessfullyProcessedOffset = 0;
        private int lastRowSuccessfullyProcessedLength = 0;
        private long previousReadConsumed = 0L;
        private long previousReadConsumedDifference = 0L;

        private PartialResultContext() {
        }

        static /* synthetic */ byte[] access$402(PartialResultContext x0, byte[] x1) {
            x0.lastRowSuccessfullyProcessedArray = x1;
            return x1;
        }
    }
}

