/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.BootstrapNodeProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SecurityInfo {
    private static ConcurrentMap<String, SecurityInfo> infos = new ConcurrentHashMap<String, SecurityInfo>();
    private final List<String> serverPrincipals;
    private final AuthenticationProtos.TokenIdentifier.Kind tokenKind;

    public static void addInfo(String serviceName, SecurityInfo securityInfo) {
        infos.putIfAbsent(serviceName, securityInfo);
    }

    public static SecurityInfo getInfo(String serviceName) {
        return (SecurityInfo)infos.get(serviceName);
    }

    public SecurityInfo(String serverPrincipal, AuthenticationProtos.TokenIdentifier.Kind tokenKind) {
        this(tokenKind, serverPrincipal);
    }

    public SecurityInfo(AuthenticationProtos.TokenIdentifier.Kind tokenKind, String ... serverPrincipal) {
        Preconditions.checkArgument(serverPrincipal.length > 0);
        this.tokenKind = tokenKind;
        this.serverPrincipals = Arrays.asList(serverPrincipal);
    }

    @Deprecated
    public String getServerPrincipal() {
        return this.serverPrincipals.get(0);
    }

    public List<String> getServerPrincipals() {
        return this.serverPrincipals;
    }

    public AuthenticationProtos.TokenIdentifier.Kind getTokenKind() {
        return this.tokenKind;
    }

    static {
        infos.put(AdminProtos.AdminService.getDescriptor().getName(), new SecurityInfo("hbase.regionserver.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(ClientProtos.ClientService.getDescriptor().getName(), new SecurityInfo("hbase.regionserver.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(MasterProtos.MasterService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(RegionServerStatusProtos.RegionServerStatusService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(MasterProtos.HbckService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(RegistryProtos.ClientMetaService.getDescriptor().getName(), new SecurityInfo(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, "hbase.master.kerberos.principal", "hbase.regionserver.kerberos.principal"));
        infos.put(BootstrapNodeProtos.BootstrapNodeService.getDescriptor().getName(), new SecurityInfo("hbase.regionserver.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        infos.put(LockServiceProtos.LockService.getDescriptor().getName(), new SecurityInfo("hbase.master.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
    }
}

