/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupCopyJob;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupRestoreFactory;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.IncrementalBackupManager;
import org.apache.hadoop.hbase.backup.impl.TableBackupClient;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IncrementalTableBackupClient
extends TableBackupClient {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalTableBackupClient.class);

    protected IncrementalTableBackupClient() {
    }

    public IncrementalTableBackupClient(Connection conn, String backupId, BackupRequest request) throws IOException {
        super(conn, backupId, request);
    }

    protected List<String> filterMissingFiles(List<String> incrBackupFileList) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (String file : incrBackupFileList) {
            Path p = new Path(file);
            if (this.fs.exists(p) || this.isActiveWalPath(p)) {
                list.add(file);
                continue;
            }
            LOG.warn("Can't find file: " + file);
        }
        return list;
    }

    protected boolean isActiveWalPath(Path p) {
        return !AbstractFSWALProvider.isArchivedLogFile((Path)p);
    }

    protected static int getIndex(TableName tbl, List<TableName> sTableList) {
        if (sTableList == null) {
            return 0;
        }
        for (int i = 0; i < sTableList.size(); ++i) {
            if (!tbl.equals((Object)sTableList.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected List<byte[]> handleBulkLoad(List<TableName> sTableList) throws IOException {
        FileSystem tgtFs;
        Map[] mapForSrc = new Map[sTableList.size()];
        ArrayList<String> activeFiles = new ArrayList<String>();
        ArrayList<String> archiveFiles = new ArrayList<String>();
        Pair<Map<TableName, Map<String, Map<String, List<Pair<String, Boolean>>>>>, List<byte[]>> pair = this.backupManager.readBulkloadRows(sTableList);
        Map map = (Map)pair.getFirst();
        try {
            tgtFs = FileSystem.get((URI)new URI(this.backupInfo.getBackupRootDir()), (Configuration)this.conf);
        }
        catch (URISyntaxException use) {
            throw new IOException("Unable to get FileSystem", use);
        }
        Path rootdir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path tgtRoot = new Path(new Path(this.backupInfo.getBackupRootDir()), this.backupId);
        for (Map.Entry tblEntry : map.entrySet()) {
            TableName srcTable = (TableName)tblEntry.getKey();
            int srcIdx = IncrementalTableBackupClient.getIndex(srcTable, sTableList);
            if (srcIdx < 0) {
                LOG.warn("Couldn't find " + srcTable + " in source table List");
                continue;
            }
            if (mapForSrc[srcIdx] == null) {
                mapForSrc[srcIdx] = new TreeMap(Bytes.BYTES_COMPARATOR);
            }
            Path tblDir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)srcTable);
            Path tgtTable = new Path(new Path(tgtRoot, srcTable.getNamespaceAsString()), srcTable.getQualifierAsString());
            for (Map.Entry regionEntry : ((Map)tblEntry.getValue()).entrySet()) {
                String regionName = (String)regionEntry.getKey();
                Path regionDir = new Path(tblDir, regionName);
                for (Map.Entry famEntry : ((Map)regionEntry.getValue()).entrySet()) {
                    List<Path> files;
                    String fam = (String)famEntry.getKey();
                    Path famDir = new Path(regionDir, fam);
                    if (!mapForSrc[srcIdx].containsKey(Bytes.toBytes((String)fam))) {
                        files = new ArrayList();
                        mapForSrc[srcIdx].put(Bytes.toBytes((String)fam), files);
                    } else {
                        files = (List)mapForSrc[srcIdx].get(Bytes.toBytes((String)fam));
                    }
                    Path archiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)this.conf, (TableName)srcTable, (String)regionName, (String)fam);
                    String tblName = srcTable.getQualifierAsString();
                    Path tgtFam = new Path(new Path(tgtTable, regionName), fam);
                    if (!tgtFs.mkdirs(tgtFam)) {
                        throw new IOException("couldn't create " + tgtFam);
                    }
                    for (Pair fileWithState : (List)famEntry.getValue()) {
                        String file = (String)fileWithState.getFirst();
                        int idx = file.lastIndexOf("/");
                        String filename = file;
                        if (idx > 0) {
                            filename = file.substring(idx + 1);
                        }
                        Path p = new Path(famDir, filename);
                        Path tgt = new Path(tgtFam, filename);
                        Path archive = new Path(archiveDir, filename);
                        if (this.fs.exists(p)) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("found bulk hfile " + file + " in " + famDir + " for " + tblName);
                            }
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("copying " + p + " to " + tgt);
                            }
                            activeFiles.add(p.toString());
                        } else if (this.fs.exists(archive)) {
                            LOG.debug("copying archive " + archive + " to " + tgt);
                            archiveFiles.add(archive.toString());
                        }
                        files.add(tgt);
                    }
                }
            }
        }
        this.copyBulkLoadedFiles(activeFiles, archiveFiles);
        return (List)pair.getSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBulkLoadedFiles(List<String> activeFiles, List<String> archiveFiles) throws IOException {
        try {
            String[] toCopy;
            this.conf.setInt("num.levels.preserve", 5);
            String tgtDest = this.backupInfo.getBackupRootDir() + "/" + this.backupInfo.getBackupId();
            int attempt = 1;
            while (activeFiles.size() > 0) {
                LOG.info("Copy " + activeFiles.size() + " active bulk loaded files. Attempt =" + attempt++);
                toCopy = new String[activeFiles.size()];
                activeFiles.toArray(toCopy);
                try {
                    this.incrementalCopyHFiles(toCopy, tgtDest);
                    break;
                }
                catch (IOException e) {
                    int numOfActive = activeFiles.size();
                    this.updateFileLists(activeFiles, archiveFiles);
                    if (activeFiles.size() < numOfActive) continue;
                    throw e;
                }
            }
            if (archiveFiles.size() > 0) {
                toCopy = new String[archiveFiles.size()];
                archiveFiles.toArray(toCopy);
                this.incrementalCopyHFiles(toCopy, tgtDest);
            }
        }
        finally {
            this.conf.unset("num.levels.preserve");
        }
    }

    private void updateFileLists(List<String> activeFiles, List<String> archiveFiles) throws IOException {
        ArrayList<String> newlyArchived = new ArrayList<String>();
        for (String spath : activeFiles) {
            if (this.fs.exists(new Path(spath))) continue;
            newlyArchived.add(spath);
        }
        if (newlyArchived.size() > 0) {
            activeFiles.removeAll(newlyArchived);
            archiveFiles.addAll(newlyArchived);
        }
        LOG.debug(newlyArchived.size() + " files have been archived.");
    }

    @Override
    public void execute() throws IOException {
        try {
            this.beginBackup(this.backupManager, this.backupInfo);
            this.backupInfo.setPhase(BackupInfo.BackupPhase.PREPARE_INCREMENTAL);
            LOG.debug("For incremental backup, current table set is " + this.backupManager.getIncrementalBackupTableSet());
            this.newTimestamps = ((IncrementalBackupManager)this.backupManager).getIncrBackupLogFileMap();
        }
        catch (Exception e) {
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, "Unexpected Exception : ", BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
        try {
            BackupUtils.copyTableRegionInfo(this.conn, this.backupInfo, this.conf);
            this.convertWALsToHFiles();
            this.incrementalCopyHFiles(new String[]{this.getBulkOutputDir().toString()}, this.backupInfo.getBackupRootDir());
        }
        catch (Exception e) {
            String msg = "Unexpected exception in incremental-backup: incremental copy " + this.backupId;
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, msg, BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
        try {
            Map<TableName, Map<String, Long>> previousTimestampMap = this.backupManager.readLogTimestampMap();
            this.backupInfo.setIncrTimestampMap(previousTimestampMap);
            this.backupManager.writeRegionServerLogTimestamp(this.backupInfo.getTables(), this.newTimestamps);
            Map<TableName, Map<String, Long>> newTableSetTimestampMap = this.backupManager.readLogTimestampMap();
            this.backupInfo.setTableSetTimestampMap(newTableSetTimestampMap);
            Long newStartCode = BackupUtils.getMinValue(BackupUtils.getRSLogTimestampMins(newTableSetTimestampMap));
            this.backupManager.writeBackupStartCode(newStartCode);
            List<byte[]> bulkLoadedRows = this.handleBulkLoad(this.backupInfo.getTableNames());
            this.completeBackup(this.conn, this.backupInfo, BackupType.INCREMENTAL, this.conf);
            this.backupManager.deleteBulkLoadedRows(bulkLoadedRows);
        }
        catch (IOException e) {
            this.failBackup(this.conn, this.backupInfo, this.backupManager, e, "Unexpected Exception : ", BackupType.INCREMENTAL, this.conf);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementalCopyHFiles(String[] files, String backupDest) throws IOException {
        try {
            LOG.debug("Incremental copy HFiles is starting. dest=" + backupDest);
            this.backupInfo.setPhase(BackupInfo.BackupPhase.INCREMENTAL_COPY);
            String[] strArr = new String[files.length + 1];
            System.arraycopy(files, 0, strArr, 0, files.length);
            strArr[strArr.length - 1] = backupDest;
            String jobname = "Incremental_Backup-HFileCopy-" + this.backupInfo.getBackupId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting incremental copy HFiles job name to : " + jobname);
            }
            this.conf.set("mapreduce.job.name", jobname);
            BackupCopyJob copyService = BackupRestoreFactory.getBackupCopyJob(this.conf);
            int res = copyService.copy(this.backupInfo, this.backupManager, this.conf, BackupType.INCREMENTAL, strArr);
            if (res != 0) {
                LOG.error("Copy incremental HFile files failed with return code: " + res + ".");
                throw new IOException("Failed copy from " + StringUtils.join((Object[])files, (char)',') + " to " + backupDest);
            }
            LOG.debug("Incremental copy HFiles from " + StringUtils.join((Object[])files, (char)',') + " to " + backupDest + " finished.");
        }
        finally {
            this.deleteBulkLoadDirectory();
        }
    }

    protected void deleteBulkLoadDirectory() throws IOException {
        Path path = this.getBulkOutputDir();
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
        boolean result = fs.delete(path, true);
        if (!result) {
            LOG.warn("Could not delete " + path);
        }
    }

    protected void convertWALsToHFiles() throws IOException {
        List<String> incrBackupFileList = this.backupInfo.getIncrBackupFileList();
        Set<TableName> tableSet = this.backupManager.getIncrementalBackupTableSet();
        incrBackupFileList = this.filterMissingFiles(incrBackupFileList);
        ArrayList<String> tableList = new ArrayList<String>();
        for (TableName table : tableSet) {
            if (this.tableExists(table, this.conn)) {
                tableList.add(table.getNameAsString());
                continue;
            }
            LOG.warn("Table " + table + " does not exists. Skipping in WAL converter");
        }
        this.walToHFiles(incrBackupFileList, tableList);
    }

    protected boolean tableExists(TableName table, Connection conn) throws IOException {
        try (Admin admin = conn.getAdmin();){
            boolean bl = admin.tableExists(table);
            return bl;
        }
    }

    protected void walToHFiles(List<String> dirPaths, List<String> tableList) throws IOException {
        WALPlayer player = new WALPlayer();
        String dirs = StringUtils.join(dirPaths, (char)';');
        String jobname = "Incremental_Backup-" + this.backupId;
        Path bulkOutputPath = this.getBulkOutputDir();
        this.conf.set("wal.bulk.output", bulkOutputPath.toString());
        this.conf.set("wal.input.separator", ";");
        this.conf.setBoolean("hbase.hfileoutputformat.tablename.namespace.inclusive", true);
        this.conf.setBoolean("wal.multi.tables.support", true);
        this.conf.set("mapreduce.job.name", jobname);
        String[] playerArgs = new String[]{dirs, StringUtils.join(tableList, (String)",")};
        try {
            player.setConf(this.conf);
            int result = player.run(playerArgs);
            if (result != 0) {
                throw new IOException("WAL Player failed");
            }
            this.conf.unset("wal.input.separator");
            this.conf.unset("mapreduce.job.name");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new IOException("Can not convert from directory " + dirs + " (check Hadoop, HBase and WALPlayer M/R job logs) ", ee);
        }
    }

    protected Path getBulkOutputDirForTable(TableName table) {
        Path tablePath = this.getBulkOutputDir();
        tablePath = new Path(tablePath, table.getNamespaceAsString());
        tablePath = new Path(tablePath, table.getQualifierAsString());
        return new Path(tablePath, "data");
    }

    protected Path getBulkOutputDir() {
        String backupId = this.backupInfo.getBackupId();
        Path path = new Path(this.backupInfo.getBackupRootDir());
        path = new Path(path, ".tmp");
        path = new Path(path, backupId);
        return path;
    }
}

