/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.backup.BackupCopyJob;
import org.apache.hadoop.hbase.backup.BackupMergeJob;
import org.apache.hadoop.hbase.backup.RestoreJob;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceBackupCopyJob;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceBackupMergeJob;
import org.apache.hadoop.hbase.backup.mapreduce.MapReduceRestoreJob;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class BackupRestoreFactory {
    public static final String HBASE_INCR_RESTORE_IMPL_CLASS = "hbase.incremental.restore.class";
    public static final String HBASE_BACKUP_COPY_IMPL_CLASS = "hbase.backup.copy.class";
    public static final String HBASE_BACKUP_MERGE_IMPL_CLASS = "hbase.backup.merge.class";

    private BackupRestoreFactory() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static RestoreJob getRestoreJob(Configuration conf) {
        Class cls = conf.getClass(HBASE_INCR_RESTORE_IMPL_CLASS, MapReduceRestoreJob.class, RestoreJob.class);
        RestoreJob service = (RestoreJob)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        service.setConf(conf);
        return service;
    }

    public static BackupCopyJob getBackupCopyJob(Configuration conf) {
        Class cls = conf.getClass(HBASE_BACKUP_COPY_IMPL_CLASS, MapReduceBackupCopyJob.class, BackupCopyJob.class);
        BackupCopyJob service = (BackupCopyJob)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        service.setConf(conf);
        return service;
    }

    public static BackupMergeJob getBackupMergeJob(Configuration conf) {
        Class cls = conf.getClass(HBASE_BACKUP_MERGE_IMPL_CLASS, MapReduceBackupMergeJob.class, BackupMergeJob.class);
        BackupMergeJob service = (BackupMergeJob)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        service.setConf(conf);
        return service;
    }
}

